/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.query;

import com.microsoft.azure.documentdb.ChangeFeedOptions;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.DocumentCollection;
import com.microsoft.azure.documentdb.DocumentQueryClientInternal;
import com.microsoft.azure.documentdb.FeedOptions;
import com.microsoft.azure.documentdb.FeedOptionsBase;
import com.microsoft.azure.documentdb.PartitionKeyRange;
import com.microsoft.azure.documentdb.Resource;
import com.microsoft.azure.documentdb.SqlQuerySpec;
import com.microsoft.azure.documentdb.internal.DocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.DocumentServiceResponse;
import com.microsoft.azure.documentdb.internal.OperationType;
import com.microsoft.azure.documentdb.internal.ResourceType;
import com.microsoft.azure.documentdb.internal.query.QueryExecutionContext;
import com.microsoft.azure.documentdb.internal.routing.PartitionKeyInternal;
import com.microsoft.azure.documentdb.internal.routing.PartitionKeyRangeIdentity;
import com.microsoft.azure.documentdb.internal.routing.Range;
import com.microsoft.azure.documentdb.internal.routing.RoutingMapProviderHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

abstract class AbstractQueryExecutionContext<T extends Resource>
implements QueryExecutionContext<T> {
    private static final String IF_NONE_MATCH_ALL_HEADER_VALUE = "*";
    protected final DocumentQueryClientInternal client;
    protected final ResourceType resourceType;
    protected final Class<T> classT;
    protected final SqlQuerySpec querySpec;
    protected final FeedOptionsBase options;
    protected final String resourceLink;
    private boolean isChangeFeedContext;
    protected int prefetchedStatusCode;
    protected Map<String, String> responseHeaders;

    protected AbstractQueryExecutionContext(DocumentQueryClientInternal client, ResourceType resourceType, Class<T> classT, SqlQuerySpec querySpec, FeedOptionsBase options, String resourceLink) {
        this.client = client;
        this.resourceType = resourceType;
        this.classT = classT;
        this.querySpec = querySpec;
        this.options = options;
        this.resourceLink = resourceLink;
        this.responseHeaders = null;
        this.isChangeFeedContext = options instanceof ChangeFeedOptions;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    protected boolean hasNextInternal() {
        return this.responseHeaders == null || !this.isChangeFeedContext && !StringUtils.isEmpty((CharSequence)this.getContinuationToken()) || this.isChangeFeedContext && this.prefetchedStatusCode != 304;
    }

    public boolean shouldExecuteQuery() {
        return this.querySpec != null;
    }

    protected String getContinuationToken() {
        if (!this.isChangeFeedContext) {
            return this.responseHeaders == null ? null : this.responseHeaders.get("x-ms-continuation");
        }
        return this.responseHeaders.get("etag");
    }

    protected Collection<PartitionKeyRange> getTargetPartitionKeyRanges(List<Range<String>> providedRanges) {
        return RoutingMapProviderHelper.getOverlappingRanges(this.client.getPartitionKeyRangeCache(), this.resourceLink, providedRanges);
    }

    protected Map<String, String> getFeedHeaders(FeedOptionsBase options) {
        FeedOptions feedOptions;
        if (options == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        if (options.getPageSize() != null) {
            headers.put("x-ms-max-item-count", options.getPageSize().toString());
        }
        if (this.isChangeFeedContext) {
            ChangeFeedOptions changeFeedOptions = (ChangeFeedOptions)options;
            String ifNoneMatchValue = null;
            if (changeFeedOptions.getRequestContinuation() != null) {
                ifNoneMatchValue = changeFeedOptions.getRequestContinuation();
            } else if (!changeFeedOptions.isStartFromBeginning()) {
                ifNoneMatchValue = IF_NONE_MATCH_ALL_HEADER_VALUE;
            }
            if (ifNoneMatchValue != null) {
                headers.put("If-None-Match", ifNoneMatchValue);
            }
            headers.put("A-IM", "Incremental feed");
        } else if (options.getRequestContinuation() != null) {
            headers.put("x-ms-continuation", options.getRequestContinuation());
        }
        FeedOptions feedOptions2 = feedOptions = options instanceof FeedOptions ? (FeedOptions)options : null;
        if (feedOptions != null) {
            if (feedOptions.getSessionToken() != null) {
                headers.put("x-ms-session-token", feedOptions.getSessionToken());
            }
            if (feedOptions.getEnableScanInQuery() != null) {
                headers.put("x-ms-documentdb-query-enable-scan", feedOptions.getEnableScanInQuery().toString());
            }
            if (feedOptions.getEmitVerboseTracesInQuery() != null) {
                headers.put("x-ms-documentdb-query-emit-traces", feedOptions.getEmitVerboseTracesInQuery().toString());
            }
            if (feedOptions.getEnableCrossPartitionQuery() != null) {
                headers.put("x-ms-documentdb-query-enablecrosspartition", feedOptions.getEnableCrossPartitionQuery().toString());
            }
            if (feedOptions.getMaxDegreeOfParallelism() != 0) {
                headers.put("x-ms-documentdb-query-parallelizecrosspartitionquery", Boolean.TRUE.toString());
            }
            if (feedOptions.getDisableRUPerMinuteUsage() != null) {
                headers.put("x-ms-documentdb-disable-ru-per-minute-usage", feedOptions.getDisableRUPerMinuteUsage().toString());
            }
        }
        return headers;
    }

    private void populatePartitionKeyInfo(DocumentServiceRequest request, PartitionKeyInternal partitionKey) {
        if (request == null) {
            throw new IllegalArgumentException("request");
        }
        if (request.getResourceType().isPartitioned() && partitionKey != null) {
            request.getHeaders().put("x-ms-documentdb-partitionkey", partitionKey.toJson());
        }
    }

    private void populatePartitionKeyRangeInfo(DocumentServiceRequest request, String partitionKeyRangeId) {
        if (request == null) {
            throw new IllegalArgumentException("request");
        }
        if (partitionKeyRangeId == null) {
            throw new IllegalArgumentException("partitionKeyRangeId");
        }
        DocumentCollection collection = this.client.getCollectionCache().resolveCollection(request);
        if (request.getResourceType().isPartitioned()) {
            request.routeTo(new PartitionKeyRangeIdentity(collection.getResourceId(), partitionKeyRangeId));
        }
    }

    DocumentServiceRequest createRequest(SqlQuerySpec querySpec, PartitionKeyInternal partitionKeyInternal) {
        Map<String, String> requestHeaders = this.getFeedHeaders(this.options);
        DocumentServiceRequest request = querySpec == null ? DocumentServiceRequest.create(OperationType.ReadFeed, this.resourceType, this.resourceLink, requestHeaders) : DocumentServiceRequest.create(this.resourceType, this.resourceLink, querySpec, this.client.getQueryCompatiblityMode(), requestHeaders);
        this.populatePartitionKeyInfo(request, partitionKeyInternal);
        return request;
    }

    DocumentServiceRequest createRequest(SqlQuerySpec querySpec, String partitionKeyRangeId) {
        Map<String, String> requestHeaders = this.getFeedHeaders(this.options);
        DocumentServiceRequest request = querySpec == null ? DocumentServiceRequest.create(OperationType.ReadFeed, this.resourceType, this.resourceLink, requestHeaders) : DocumentServiceRequest.create(this.resourceType, this.resourceLink, querySpec, this.client.getQueryCompatiblityMode(), requestHeaders);
        this.populatePartitionKeyRangeInfo(request, partitionKeyRangeId);
        return request;
    }

    PartitionKeyInternal getPartitionKeyInternal() {
        FeedOptions feedOptions;
        FeedOptions feedOptions2 = feedOptions = this.options instanceof FeedOptions ? (FeedOptions)this.options : null;
        if (feedOptions == null) {
            return null;
        }
        return feedOptions.getPartitionKey() == null ? null : feedOptions.getPartitionKey().getInternalPartitionKey();
    }

    DocumentServiceResponse executeRequest(DocumentServiceRequest request) throws DocumentClientException {
        return this.shouldExecuteQuery() ? this.client.doQuery(request) : this.client.doReadFeed(request);
    }
}

