/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.directconnectivity;

import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.internal.AuthorizationTokenProvider;
import com.microsoft.azure.documentdb.internal.DocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.directconnectivity.ReadBarrierRequestHelper;
import com.microsoft.azure.documentdb.internal.directconnectivity.ReadPrimaryResult;
import com.microsoft.azure.documentdb.internal.directconnectivity.ReadQuorumResult;
import com.microsoft.azure.documentdb.internal.directconnectivity.ReadQuorumResultKind;
import com.microsoft.azure.documentdb.internal.directconnectivity.StoreReadResult;
import com.microsoft.azure.documentdb.internal.directconnectivity.StoreReader;
import com.microsoft.azure.documentdb.internal.directconnectivity.StoreResponse;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QuorumReader {
    private static final int MAX_NUMBER_OF_READ_BARRIER_RETRIES = 6;
    private static final int MAX_NUMBER_OF_READ_QUORUM_RETRIES = 6;
    private static final int DELAY_BETWEEN_READ_BARRIER_CALLS_IN_MS = 10;
    private final Logger logger = LoggerFactory.getLogger(QuorumReader.class);
    private StoreReader storeReader;
    private AuthorizationTokenProvider authorizationTokenProvider;

    public QuorumReader(StoreReader storeReader, AuthorizationTokenProvider authorizationTokenProvider) {
        this.storeReader = storeReader;
        this.authorizationTokenProvider = authorizationTokenProvider;
    }

    StoreResponse readStrong(DocumentServiceRequest request, int quorumValue) throws DocumentClientException {
        int readQuorumRetry = 6;
        boolean shouldRetryOnSecondary = false;
        boolean hasPerformedReadFromPrimary = false;
        do {
            shouldRetryOnSecondary = false;
            ReadQuorumResult secondaryQuorumReadResult = this.readQuorum(request, quorumValue, false);
            switch (secondaryQuorumReadResult.getQuorumResult()) {
                case QuorumMet: {
                    return secondaryQuorumReadResult.getResponse();
                }
                case QuorumSelected: {
                    DocumentServiceRequest barrierRequest = ReadBarrierRequestHelper.create(request, this.authorizationTokenProvider);
                    if (this.waitForBarrierRequest(barrierRequest, true, quorumValue, secondaryQuorumReadResult.getSelectedLsn())) {
                        return secondaryQuorumReadResult.getResponse();
                    }
                    this.logger.debug("Couldn't converge on the LSN {} after primary read barrier with read quorum {} for strong read.", (Object)secondaryQuorumReadResult.getSelectedLsn(), (Object)quorumValue);
                    request.setQuorumSelectedLSN(secondaryQuorumReadResult.getSelectedLsn());
                    request.setQuorumSelectedStoreResponse(secondaryQuorumReadResult.getStoreReadResult());
                    break;
                }
                case QuorumNotSelected: {
                    if (hasPerformedReadFromPrimary) {
                        this.logger.warn("Primary read already attempted. Quorum couldn't be selected after retrying on secondaries.");
                        throw new DocumentClientException(410, "Primary read already attempted. Quorum couldn't be selected after retrying on secondaries.");
                    }
                    this.logger.debug("Quorum could not be selected with read quorum of {}", (Object)quorumValue);
                    ReadPrimaryResult response = this.readPrimary(request, quorumValue);
                    if (response.isSuccessful()) {
                        this.logger.debug("Primary read succeeded");
                        return response.getResponse();
                    }
                    if (response.isShouldRetryOnSecondary()) {
                        this.logger.debug("ReadPrimary did not succeed. Will retry on secondary.");
                        shouldRetryOnSecondary = true;
                        hasPerformedReadFromPrimary = true;
                        break;
                    }
                    this.logger.warn("Could not get successful response from ReadPrimary");
                    throw new DocumentClientException(410, "Could not get successful response from ReadPrimary");
                }
                default: {
                    this.logger.error("Unknown read quorum result {}", (Object)secondaryQuorumReadResult.getQuorumResult().toString());
                    throw new DocumentClientException(500, "Unknown read quorum result.");
                }
            }
        } while (--readQuorumRetry > 0 && shouldRetryOnSecondary);
        this.logger.warn("Could not complete read quorum with read quorum value of {}", (Object)quorumValue);
        throw new DocumentClientException(410, "Could not complete read quorum.");
    }

    private ReadPrimaryResult readPrimary(DocumentServiceRequest request, int readQuorum) throws DocumentClientException {
        request.setForceAddressRefresh(false);
        StoreReadResult storeReadResult = this.storeReader.readPrimary(request, true);
        if (!storeReadResult.isValid()) {
            throw storeReadResult.getExcetpion();
        }
        if (storeReadResult.getCurrentReplicaSetSize() <= 0 || storeReadResult.getLSN() < 0L || storeReadResult.getQuorumAckedLSN() < 0L) {
            this.logger.warn("Invalid value received from response header. CurrentReplicaSetSize {}, StoreLSN {}, QuorumAckedLSN {}. Throwing gone exception", new Object[]{storeReadResult.getCurrentReplicaSetSize(), storeReadResult.getLSN(), storeReadResult.getQuorumAckedLSN()});
            throw new DocumentClientException(410, "Invalid value received from response header.");
        }
        if (storeReadResult.getCurrentReplicaSetSize() > readQuorum) {
            this.logger.debug("Unexpected response. Replica Set size is {} which is greater than min value {}", (Object)storeReadResult.getCurrentReplicaSetSize(), (Object)readQuorum);
            return new ReadPrimaryResult(false, true, null, request.getRequestChargeTracker());
        }
        return new ReadPrimaryResult(true, false, storeReadResult, request.getRequestChargeTracker());
    }

    private ReadQuorumResult readQuorum(DocumentServiceRequest request, int readQuorum, boolean includePrimary) throws DocumentClientException {
        long maxLsn = 0L;
        StoreReadResult highestLsnResult = null;
        if (request.getQuorumSelectedStoreResponse() == null) {
            boolean quorumMet;
            List<StoreReadResult> responseResult = this.storeReader.readMultipleReplica(request, includePrimary, readQuorum);
            int responseCount = responseResult.size();
            if (responseCount < readQuorum) {
                return new ReadQuorumResult(ReadQuorumResultKind.QuorumNotSelected, -1L, null, request.getRequestChargeTracker());
            }
            int replicaCountMaxLsn = 0;
            for (StoreReadResult storeReadResult : responseResult) {
                if (storeReadResult.getLSN() == maxLsn) {
                    ++replicaCountMaxLsn;
                    continue;
                }
                if (storeReadResult.getLSN() <= maxLsn) continue;
                replicaCountMaxLsn = 1;
                maxLsn = storeReadResult.getLSN();
                highestLsnResult = storeReadResult;
            }
            boolean bl = quorumMet = replicaCountMaxLsn >= readQuorum;
            if (quorumMet) {
                return new ReadQuorumResult(ReadQuorumResultKind.QuorumMet, maxLsn, highestLsnResult, request.getRequestChargeTracker());
            }
        } else {
            this.logger.warn("wait to catch up max lsn");
            maxLsn = request.getQuorumSelectedLSN();
            highestLsnResult = request.getQuorumSelectedStoreResponse();
        }
        DocumentServiceRequest barrierRequest = ReadBarrierRequestHelper.create(request, this.authorizationTokenProvider);
        if (this.waitForBarrierRequest(barrierRequest, false, readQuorum, maxLsn)) {
            return new ReadQuorumResult(ReadQuorumResultKind.QuorumMet, maxLsn, highestLsnResult, request.getRequestChargeTracker());
        }
        this.logger.warn("Quorum selected with maxLsn {}", (Object)maxLsn);
        return new ReadQuorumResult(ReadQuorumResultKind.QuorumSelected, maxLsn, highestLsnResult, request.getRequestChargeTracker());
    }

    private boolean waitForBarrierRequest(DocumentServiceRequest barrierRequest, boolean allowPrimary, int readQuorum, long readBarrierLsn) throws DocumentClientException {
        int readBarrierRetryCount = 6;
        do {
            barrierRequest.setForceAddressRefresh(false);
            List<StoreReadResult> responses = this.storeReader.readMultipleReplica(barrierRequest, allowPrimary, readQuorum);
            int validLsnCount = 0;
            for (StoreReadResult storeReadResult : responses) {
                if (storeReadResult.getLSN() < readBarrierLsn) continue;
                ++validLsnCount;
            }
            if (validLsnCount >= readQuorum) {
                this.logger.debug("secondaries barrier requeest succeeded");
                return true;
            }
            this.logger.warn("Barrier request failed with validLsnCount = {} and readQuorum {} with remaining retries {} and allow primary is {}", new Object[]{validLsnCount, readQuorum, readBarrierRetryCount, allowPrimary});
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Delay thread interruped with exception: ", e);
            }
        } while (--readBarrierRetryCount > 0);
        return false;
    }

    StoreResponse readBoundedStaleness(DocumentServiceRequest request, int readQuorumValue) throws DocumentClientException {
        int readQuorumRetry = 6;
        boolean shouldRetryOnSecondary = false;
        boolean hasPerformedReadFromPrimary = false;
        block5: do {
            this.logger.warn("remaining retries {}", (Object)readQuorumRetry);
            ReadQuorumResult secondaryQuorumReadResult = this.readQuorum(request, readQuorumValue, false);
            shouldRetryOnSecondary = false;
            switch (secondaryQuorumReadResult.getQuorumResult()) {
                case QuorumMet: {
                    this.logger.debug("ReadQuorum successful");
                    return secondaryQuorumReadResult.getResponse();
                }
                case QuorumSelected: {
                    this.logger.warn("Could not converge on the LSN {} after read barrier with read quorum {}. Will not perform barrier call on Primary for BoundedStaleness", (Object)secondaryQuorumReadResult.getSelectedLsn(), (Object)readQuorumValue);
                    request.setQuorumSelectedStoreResponse(secondaryQuorumReadResult.getStoreReadResult());
                    request.setQuorumSelectedLSN(secondaryQuorumReadResult.getSelectedLsn());
                    break;
                }
                case QuorumNotSelected: {
                    if (hasPerformedReadFromPrimary) {
                        this.logger.warn("Primary read already attempted. Quorum could not be selected after retrying on secondaries.");
                        throw new DocumentClientException(410, "Primary read already attempted. Quorum could not be selected after retrying on secondaries.");
                    }
                    this.logger.debug("Quorum could not be selected with read quorum of {}", (Object)readQuorumValue);
                    ReadPrimaryResult response = this.readPrimary(request, readQuorumValue);
                    if (response.isSuccessful() && response.isShouldRetryOnSecondary()) {
                        this.logger.error("PrimaryResult has both Successful and ShouldRetryOnSecondary flags set");
                        assert (false) : "PrimaryResult has both Successful and ShouldRetryOnSecondary flags set";
                        continue block5;
                    }
                    if (response.isSuccessful()) {
                        this.logger.debug("ReadPrimary successful");
                        return response.getResponse();
                    }
                    if (response.isShouldRetryOnSecondary()) {
                        shouldRetryOnSecondary = true;
                        this.logger.debug("ReadPrimary did not succeed. Will retry on secondary.");
                        hasPerformedReadFromPrimary = true;
                        break;
                    }
                    this.logger.warn("Could not get successful response from ReadPrimary");
                    throw new DocumentClientException(410, "Could not get successful response from ReadPrimary");
                }
                default: {
                    this.logger.warn("Unknown ReadQuorum result {}", (Object)secondaryQuorumReadResult.getQuorumResult().toString());
                    throw new DocumentClientException(500, "Unknown ReadQuorum");
                }
            }
        } while (--readQuorumRetry > 0 && shouldRetryOnSecondary);
        this.logger.error("Could not complete read quourm with read quorum value of {}", (Object)readQuorumValue);
        throw new DocumentClientException(410, String.format("Could not complete read quourm with read quorum value of %d", readQuorumValue));
    }
}

