/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.directconnectivity;

import com.microsoft.azure.documentdb.ConnectionPolicy;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.Error;
import com.microsoft.azure.documentdb.internal.DocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.ErrorUtils;
import com.microsoft.azure.documentdb.internal.OperationType;
import com.microsoft.azure.documentdb.internal.ResourceType;
import com.microsoft.azure.documentdb.internal.UserAgentContainer;
import com.microsoft.azure.documentdb.internal.Utils;
import com.microsoft.azure.documentdb.internal.directconnectivity.StoreResponse;
import com.microsoft.azure.documentdb.internal.directconnectivity.TransportClient;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.NameValuePair;
import org.apache.http.NoHttpResponseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTransportClient
extends TransportClient {
    private final Logger logger = LoggerFactory.getLogger(HttpTransportClient.class);
    private final HttpClient httpClient;
    private final LinkedList<NameValuePair> defaultHeaders;
    private HttpHost proxy;

    public HttpTransportClient(HttpClient httpClient, ConnectionPolicy connectionPolicy, UserAgentContainer userAgentContainer) {
        this.httpClient = httpClient;
        this.proxy = connectionPolicy.getProxy();
        if (userAgentContainer == null) {
            userAgentContainer = new UserAgentContainer();
        }
        this.defaultHeaders = new LinkedList();
        this.defaultHeaders.add((NameValuePair)new BasicNameValuePair("x-ms-version", "2017-02-22"));
        this.defaultHeaders.add((NameValuePair)new BasicNameValuePair("User-Agent", userAgentContainer.getUserAgent()));
        this.defaultHeaders.add((NameValuePair)new BasicNameValuePair("Accept", "application/json"));
        this.defaultHeaders.add((NameValuePair)new BasicNameValuePair("Cache-Control", "no-cache"));
    }

    private static void addHeader(LinkedList<NameValuePair> requestHeaders, String headerName, DocumentServiceRequest request) {
        String headerValue = request.getHeaders().get(headerName);
        if (!StringUtils.isEmpty((CharSequence)headerValue)) {
            requestHeaders.add((NameValuePair)new BasicNameValuePair(headerName, headerValue));
        }
    }

    private static void addHeader(LinkedList<NameValuePair> requestHeaders, String headerName, String headerValue) {
        if (!StringUtils.isEmpty((CharSequence)headerValue)) {
            requestHeaders.add((NameValuePair)new BasicNameValuePair(headerName, headerValue));
        }
    }

    private static String GetDateHeader(Map<String, String> headers) {
        if (headers == null) {
            return "";
        }
        String date = headers.get("x-ms-date");
        if (StringUtils.isEmpty((CharSequence)date)) {
            date = headers.get("date");
        }
        return date != null ? date : "";
    }

    public StoreResponse invokeStore(URI physicalAddress, HttpRequestBase httpRequest, boolean isMedia, String activityId) throws DocumentClientException {
        HttpResponse response;
        try {
            response = this.httpClient.execute((HttpUriRequest)httpRequest, (HttpContext)HttpClientContext.create());
        }
        catch (ClientProtocolException e) {
            httpRequest.releaseConnection();
            throw new DocumentClientException(503, (Exception)((Object)e));
        }
        catch (IOException e) {
            httpRequest.releaseConnection();
            if (e instanceof NoHttpResponseException) {
                throw new DocumentClientException(410, e);
            }
            throw new DocumentClientException(503, e);
        }
        catch (Exception e) {
            httpRequest.releaseConnection();
            throw e;
        }
        return this.processResponse(physicalAddress.getPath(), isMedia, response, activityId);
    }

    @Override
    public StoreResponse invokeStore(URI physicalAddress, DocumentServiceRequest request) throws DocumentClientException {
        HttpRequestBase httpRequest = this.prepareHttpMessage(request.getActivityId(), physicalAddress, request.getOperationType(), request.getResourceType(), request);
        return this.invokeStore(physicalAddress, httpRequest, request.getIsMedia(), request.getActivityId());
    }

    private StoreResponse processResponse(String requestUri, boolean isMedia, HttpResponse response, String activityId) throws DocumentClientException {
        if (requestUri == null) {
            throw new IllegalArgumentException("requestUri");
        }
        if (response == null) {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-ms-activity-id", activityId);
            headers.put("x-ms-request-validation-failure", "1");
            String errorBodyTemplate = "{'code':'%d', 'message':'Message: {\"Errors\":[\"%s\"]}'}";
            String errorBody = String.format(errorBodyTemplate, 500, "The backend response was not in the correct format.");
            throw new DocumentClientException(500, new Error(errorBody), headers);
        }
        if (response.getStatusLine().getStatusCode() < 300 || response.getStatusLine().getStatusCode() == 304) {
            return StoreResponse.fromHttpResponse(response, isMedia);
        }
        ErrorUtils.maybeThrowException(requestUri, response, false, this.logger);
        return null;
    }

    public HttpRequestBase prepareHttpMessage(String activityId, URI physicalAddress, OperationType operationType, ResourceType resourceType, DocumentServiceRequest request) {
        HttpDelete httpRequest;
        LinkedList<NameValuePair> requestHeaders = new LinkedList<NameValuePair>();
        HttpTransportClient.addHeader(requestHeaders, "x-ms-version", request);
        HttpTransportClient.addHeader(requestHeaders, "User-Agent", request);
        HttpTransportClient.addHeader(requestHeaders, "x-ms-max-item-count", request);
        HttpTransportClient.addHeader(requestHeaders, "x-ms-documentdb-pre-trigger-include", request);
        HttpTransportClient.addHeader(requestHeaders, "x-ms-documentdb-pre-trigger-exclude", request);
        HttpTransportClient.addHeader(requestHeaders, "x-ms-documentdb-post-trigger-include", request);
        HttpTransportClient.addHeader(requestHeaders, "x-ms-documentdb-post-trigger-exclude", request);
        HttpTransportClient.addHeader(requestHeaders, "authorization", request);
        HttpTransportClient.addHeader(requestHeaders, "x-ms-indexing-directive", request);
        HttpTransportClient.addHeader(requestHeaders, "x-ms-consistency-level", request);
        HttpTransportClient.addHeader(requestHeaders, "x-ms-session-token", request);
        HttpTransportClient.addHeader(requestHeaders, "Prefer", request);
        HttpTransportClient.addHeader(requestHeaders, "x-ms-documentdb-expiry-seconds", request);
        HttpTransportClient.addHeader(requestHeaders, "x-ms-documentdb-query-enable-scan", request);
        HttpTransportClient.addHeader(requestHeaders, "x-ms-documentdb-query-emit-traces", request);
        HttpTransportClient.addHeader(requestHeaders, "x-ms-continuation", request.getContinuation());
        HttpTransportClient.addHeader(requestHeaders, "x-ms-activity-id", activityId);
        HttpTransportClient.addHeader(requestHeaders, "x-ms-documentdb-partitionkey", request);
        HttpTransportClient.addHeader(requestHeaders, "x-ms-documentdb-partitionkeyrangeid", request);
        String dateHeader = HttpTransportClient.GetDateHeader(request.getHeaders());
        HttpTransportClient.addHeader(requestHeaders, "x-ms-date", dateHeader);
        HttpTransportClient.addHeader(requestHeaders, "Match", this.GetMatch(request, request.getOperationType()));
        String fanoutRequestHeader = request.getHeaders().get("x-ms-is-fanout-request");
        HttpTransportClient.addHeader(requestHeaders, "x-ms-is-fanout-request", fanoutRequestHeader);
        if (!request.getIsNameBased()) {
            HttpTransportClient.addHeader(requestHeaders, "x-docdb-resource-id", request.getResourceId());
        }
        if (request.getResourceType() == ResourceType.DocumentCollection) {
            HttpTransportClient.addHeader(requestHeaders, "collection-partition-index", request.getHeaders().get("collection-partition-index"));
            HttpTransportClient.addHeader(requestHeaders, "collection-service-index", request.getHeaders().get("collection-service-index"));
        }
        if (request.getHeaders().get("x-ms-bind-replica") != null) {
            HttpTransportClient.addHeader(requestHeaders, "x-ms-bind-replica", request.getHeaders().get("x-ms-bind-replica"));
            HttpTransportClient.addHeader(requestHeaders, "x-ms-primary-master-key", request.getHeaders().get("x-ms-primary-master-key"));
            HttpTransportClient.addHeader(requestHeaders, "x-ms-secondary-master-key", request.getHeaders().get("x-ms-secondary-master-key"));
            HttpTransportClient.addHeader(requestHeaders, "x-ms-primary-readonly-key", request.getHeaders().get("x-ms-primary-readonly-key"));
            HttpTransportClient.addHeader(requestHeaders, "x-ms-secondary-readonly-key", request.getHeaders().get("x-ms-secondary-readonly-key"));
            HttpTransportClient.addHeader(requestHeaders, "x-ms-documentdb-bindmineffectivepartitionkey", request.getHeaders().get("x-ms-documentdb-bindmineffectivepartitionkey"));
            HttpTransportClient.addHeader(requestHeaders, "x-ms-documentdb-bindmaxeffectivepartitionkey", request.getHeaders().get("x-ms-documentdb-bindmaxeffectivepartitionkey"));
            HttpTransportClient.addHeader(requestHeaders, "x-ms-documentdb-bindpartitionkeyrangeid", request.getHeaders().get("x-ms-documentdb-bindpartitionkeyrangeid"));
            HttpTransportClient.addHeader(requestHeaders, "x-ms-documentdb-bindpartitionkeyrangeridprefix", request.getHeaders().get("x-ms-documentdb-bindpartitionkeyrangeridprefix"));
            HttpTransportClient.addHeader(requestHeaders, "x-ms-documentdb-minimumallowedclientversion", request.getHeaders().get("x-ms-documentdb-minimumallowedclientversion"));
        }
        HttpTransportClient.addHeader(requestHeaders, "x-ms-documentdb-is-upsert", request);
        HttpTransportClient.addHeader(requestHeaders, "x-ms-documentdb-partitioncount", request);
        HttpTransportClient.addHeader(requestHeaders, "x-ms-documentdb-collection-rid", request);
        HttpTransportClient.addHeader(requestHeaders, "x-ms-documentdb-script-enable-logging", request);
        HttpTransportClient.addHeader(requestHeaders, "x-ms-documentdb-populatequotainfo", request);
        HttpTransportClient.addHeader(requestHeaders, "x-ms-documentdb-disable-ru-per-minute-usage", request);
        HttpTransportClient.addHeader(requestHeaders, "A-IM", request);
        URI resourceUri = null;
        try {
            resourceUri = new URI(physicalAddress.getScheme(), physicalAddress.getUserInfo(), physicalAddress.getHost(), physicalAddress.getPort(), physicalAddress.getPath() + Utils.trimBeginingAndEndingSlashes(request.getPath()), physicalAddress.getQuery(), physicalAddress.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        switch (operationType) {
            case Create: 
            case Upsert: 
            case ExecuteJavaScript: {
                HttpPost postRequest = new HttpPost(resourceUri);
                postRequest.setEntity(request.getBody());
                this.addHeadersToRequest((HttpRequestBase)postRequest, requestHeaders);
                httpRequest = postRequest;
                break;
            }
            case Replace: {
                HttpPut putRequest = new HttpPut(resourceUri);
                putRequest.setEntity(request.getBody());
                this.addHeadersToRequest((HttpRequestBase)putRequest, requestHeaders);
                httpRequest = putRequest;
                break;
            }
            case Delete: {
                HttpDelete deleteRequest = new HttpDelete(resourceUri);
                this.addHeadersToRequest((HttpRequestBase)deleteRequest, requestHeaders);
                httpRequest = deleteRequest;
                break;
            }
            case Read: 
            case ReadFeed: {
                HttpGet getRequest = new HttpGet(resourceUri);
                this.addHeadersToRequest((HttpRequestBase)getRequest, requestHeaders);
                httpRequest = getRequest;
                break;
            }
            case Query: 
            case SqlQuery: {
                HttpPost queryPostRequest = new HttpPost(resourceUri);
                queryPostRequest.setEntity(request.getBody());
                HttpTransportClient.addHeader(requestHeaders, "Content-Type", "application/query+json");
                HttpTransportClient.addHeader(requestHeaders, "x-ms-documentdb-isquery", Boolean.TRUE.toString());
                this.addHeadersToRequest((HttpRequestBase)queryPostRequest, requestHeaders);
                httpRequest = queryPostRequest;
                break;
            }
            case Head: {
                HttpHead headRequest = new HttpHead(resourceUri);
                this.addHeadersToRequest((HttpRequestBase)headRequest, requestHeaders);
                httpRequest = headRequest;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid operation type");
            }
        }
        if (this.proxy != null) {
            RequestConfig requestConfig = RequestConfig.custom().setProxy(this.proxy).build();
            httpRequest.setConfig(requestConfig);
        }
        httpRequest.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        return httpRequest;
    }

    private void addHeadersToRequest(HttpRequestBase request, LinkedList<NameValuePair> requestHeaders) {
        for (NameValuePair nameValuePair : requestHeaders) {
            if (nameValuePair.getName().equals("x-ms-session-token")) continue;
            request.addHeader(nameValuePair.getName(), nameValuePair.getValue());
        }
        for (NameValuePair nameValuePair : this.defaultHeaders) {
            request.addHeader(nameValuePair.getName(), nameValuePair.getValue());
        }
    }

    private String GetMatch(DocumentServiceRequest request, OperationType resourceOperation) {
        switch (resourceOperation) {
            case ExecuteJavaScript: 
            case Replace: 
            case Delete: 
            case Update: {
                return request.getHeaders().get("If-Match");
            }
            case Read: 
            case ReadFeed: {
                return request.getHeaders().get("If-None-Match");
            }
        }
        return null;
    }
}

