/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.directconnectivity;

import com.microsoft.azure.documentdb.ConnectionPolicy;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.DocumentCollection;
import com.microsoft.azure.documentdb.PartitionKeyRange;
import com.microsoft.azure.documentdb.internal.AuthorizationTokenProvider;
import com.microsoft.azure.documentdb.internal.DocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.DocumentServiceResponse;
import com.microsoft.azure.documentdb.internal.ErrorUtils;
import com.microsoft.azure.documentdb.internal.OperationType;
import com.microsoft.azure.documentdb.internal.PathsHelper;
import com.microsoft.azure.documentdb.internal.ResourceType;
import com.microsoft.azure.documentdb.internal.UserAgentContainer;
import com.microsoft.azure.documentdb.internal.Utils;
import com.microsoft.azure.documentdb.internal.directconnectivity.Address;
import com.microsoft.azure.documentdb.internal.directconnectivity.AddressCache;
import com.microsoft.azure.documentdb.internal.directconnectivity.AddressInformation;
import com.microsoft.azure.documentdb.internal.routing.CollectionCache;
import com.microsoft.azure.documentdb.internal.routing.PartitionKeyInternal;
import com.microsoft.azure.documentdb.internal.routing.PartitionKeyRangeIdentity;
import com.microsoft.azure.documentdb.internal.routing.Range;
import com.microsoft.azure.documentdb.internal.routing.RoutingMapProvider;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayAddressCache
extends AddressCache {
    private static final String PROTOCOL_HTTPS = "https";
    private static final String PROTOCOL_FILTER_FORMAT = "%1$s eq %2$s";
    private final Logger logger = LoggerFactory.getLogger(GatewayAddressCache.class);
    private ConcurrentHashMap<PartitionKeyRangeIdentity, AddressInformation[]> serverPartitionAddressCache = new ConcurrentHashMap();
    private String protocolFilter;
    private HttpClient httpClient;
    private List<NameValuePair> defaultHeaders;
    private String addressEndpoint;
    private AuthorizationTokenProvider authorizationTokenProvider;
    private final CollectionCache collectionCache;
    private RoutingMapProvider partitionKeyRangeCache;
    private ImmutablePair<String, AddressInformation[]> masterPartitionAddressCache;
    private HttpHost proxy;

    public GatewayAddressCache(String serviceEndpoint, ConnectionPolicy connectionPolicy, CollectionCache collectionCache, RoutingMapProvider partitionKeyRangeCache, UserAgentContainer userAgent, AuthorizationTokenProvider authorizationTokenProvider, HttpClient httpClient) {
        this.authorizationTokenProvider = authorizationTokenProvider;
        this.collectionCache = collectionCache;
        this.partitionKeyRangeCache = partitionKeyRangeCache;
        this.httpClient = httpClient;
        this.proxy = connectionPolicy.getProxy();
        if (userAgent == null) {
            userAgent = new UserAgentContainer();
        }
        this.protocolFilter = String.format(PROTOCOL_FILTER_FORMAT, "protocol", PROTOCOL_HTTPS);
        this.defaultHeaders = new LinkedList<NameValuePair>();
        this.defaultHeaders.add((NameValuePair)new BasicNameValuePair("x-ms-version", "2017-02-22"));
        this.defaultHeaders.add((NameValuePair)new BasicNameValuePair("User-Agent", userAgent.getUserAgent()));
        this.addressEndpoint = serviceEndpoint.substring(0, serviceEndpoint.lastIndexOf(":")) + "//" + "addresses";
    }

    @Override
    public AddressInformation[] resolve(DocumentServiceRequest request) {
        boolean isMasterResource = GatewayAddressCache.isReadingFromMaster(request.getResourceType(), request.getOperationType());
        return isMasterResource ? this.resolveMaster(request) : this.resolveServer(request);
    }

    private AddressInformation[] resolveMaster(DocumentServiceRequest request) {
        if (request.isForceNameCacheRefresh() || this.masterPartitionAddressCache == null) {
            List<Address> response = this.resolveAddressesViaGatewayAsync(request, null, request.getResourceType() == ResourceType.DocumentCollection);
            this.masterPartitionAddressCache = this.toPartitionAddressAndRange(response);
        }
        request.setResolvedCollectionRid((String)this.masterPartitionAddressCache.getLeft());
        return (AddressInformation[])this.masterPartitionAddressCache.getRight();
    }

    private AddressInformation[] resolveServer(DocumentServiceRequest request) {
        DocumentCollection collection = this.collectionCache.resolveCollection(request);
        String partitionKeyRangeId = null;
        if (request.getHeaders().get("x-ms-documentdb-partitionkey") != null) {
            partitionKeyRangeId = this.tryResolveServerPartitionByPartitionKey(request.getHeaders().get("x-ms-documentdb-partitionkey"), collection);
        } else if (request.getPartitionKeyRangeIdentity() != null) {
            partitionKeyRangeId = request.getPartitionKeyRangeIdentity().getPartitionKeyRangeId();
        }
        if (partitionKeyRangeId == null) {
            this.logger.warn("Request contains neither partition key nor partition range Id.");
            throw new IllegalStateException();
        }
        request.setResolvedPartitionKeyRangeId(partitionKeyRangeId);
        return this.resolveAddressesForRangeId(request, collection, partitionKeyRangeId);
    }

    private AddressInformation[] resolveAddressesForRangeId(DocumentServiceRequest request, DocumentCollection collection, String partitionKeyRangeId) {
        PartitionKeyRangeIdentity partitionKeyRangeIdentity = new PartitionKeyRangeIdentity(collection.getResourceId(), partitionKeyRangeId);
        AddressInformation[] addresses = null;
        if (request.isForceAddressRefresh() || !this.serverPartitionAddressCache.containsKey(partitionKeyRangeIdentity)) {
            addresses = this.getAddressesForRangeId(request, collection, partitionKeyRangeId);
            this.serverPartitionAddressCache.put(partitionKeyRangeIdentity, addresses);
        }
        return this.serverPartitionAddressCache.get(partitionKeyRangeIdentity);
    }

    /*
     * WARNING - void declaration
     */
    private AddressInformation[] getAddressesForRangeId(DocumentServiceRequest request, DocumentCollection collection, String partitionKeyRangeId) {
        void var7_11;
        List<Address> addresses = this.resolveAddressesViaGatewayAsync(request, new String[]{partitionKeyRangeId}, false);
        HashMap addressesByPartitionRangeId = new HashMap();
        for (Address address : addresses) {
            String string = address.getParitionKeyRangeId();
            if (!addressesByPartitionRangeId.containsKey(string)) {
                addressesByPartitionRangeId.put(string, new ArrayList());
            }
            ((List)addressesByPartitionRangeId.get(string)).add(address);
        }
        ArrayList<ImmutablePair<String, AddressInformation[]>> addressInfos = new ArrayList<ImmutablePair<String, AddressInformation[]>>();
        for (Map.Entry entry : addressesByPartitionRangeId.entrySet()) {
            addressInfos.add(this.toPartitionAddressAndRange((List)entry.getValue()));
        }
        Object var7_9 = null;
        for (ImmutablePair immutablePair : addressInfos) {
            if (!((String)immutablePair.getLeft()).equals(partitionKeyRangeId)) continue;
            ImmutablePair immutablePair2 = immutablePair;
            break;
        }
        if (var7_11 == null) {
            throw new IllegalStateException(String.format("PartitionKeyRange with id %s in collection %s doesn't exist.", partitionKeyRangeId, collection.getSelfLink()));
        }
        return (AddressInformation[])var7_11.getRight();
    }

    private String tryResolveServerPartitionByPartitionKey(String partitionKeyString, DocumentCollection collection) {
        PartitionKeyInternal partitionKey = null;
        try {
            partitionKey = (PartitionKeyInternal)Utils.getSimpleObjectMapper().readValue(partitionKeyString, PartitionKeyInternal.class);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to deserialize PartitionKeyInternal due to I/O error");
        }
        if (partitionKey.getComponents().size() == collection.getPartitionKey().getPaths().size()) {
            String effectivePartitionKey = partitionKey.getEffectivePartitionKeyString(collection.getPartitionKey(), true);
            Collection<PartitionKeyRange> ranges = this.partitionKeyRangeCache.getOverlappingRanges(collection.getSelfLink(), Range.getPointRange(effectivePartitionKey));
            return ranges.size() > 0 ? ranges.iterator().next().getId() : null;
        }
        return null;
    }

    private ImmutablePair<String, AddressInformation[]> toPartitionAddressAndRange(List<Address> addresses) {
        ArrayList<AddressInformation> addressInfos = new ArrayList<AddressInformation>();
        for (Address address : addresses) {
            addressInfos.add(new AddressInformation(true, address.IsPrimary(), address.getPhyicalUri()));
        }
        AddressInformation[] addressInfoArr = new AddressInformation[addressInfos.size()];
        return new ImmutablePair((Object)addresses.get(0).getParitionKeyRangeId(), (Object)addressInfos.toArray(addressInfoArr));
    }

    private List<Address> resolveAddressesViaGatewayAsync(DocumentServiceRequest request, String[] partitionKeyRangeIds, boolean useMasterCollectionResolver) {
        String entryUrl = PathsHelper.generatePath(request.getResourceType(), request, Utils.isFeedRequest(request.getOperationType()));
        ResourceType resourceType = request.getResourceType();
        boolean forceRefresh = request.isForceAddressRefresh();
        LinkedList<NameValuePair> addressQuery = new LinkedList<NameValuePair>();
        try {
            addressQuery.add((NameValuePair)new BasicNameValuePair("$resolveFor", URLEncoder.encode(entryUrl, "UTF-8")));
            addressQuery.add((NameValuePair)new BasicNameValuePair("$filter", new URI(null, null, null, this.protocolFilter, null).toString().substring(1)));
            if (partitionKeyRangeIds != null && partitionKeyRangeIds.length > 0) {
                addressQuery.add((NameValuePair)new BasicNameValuePair("$partitionKeyRangeIds", StringUtils.join((Object[])partitionKeyRangeIds, (String)",")));
            }
        }
        catch (UnsupportedEncodingException e1) {
            this.logger.warn(e1.toString(), (Throwable)e1);
        }
        catch (URISyntaxException e) {
            this.logger.warn(e.toString(), (Throwable)e);
        }
        URL targetEndpoint = Utils.setQuery(this.addressEndpoint, Utils.createQuery(addressQuery));
        HttpGet httpGet = new HttpGet(targetEndpoint.toString());
        HashMap<String, String> headers = new HashMap<String, String>();
        for (NameValuePair nameValuePair : this.defaultHeaders) {
            httpGet.addHeader(nameValuePair.getName(), nameValuePair.getValue());
            headers.put(nameValuePair.getName(), nameValuePair.getValue());
        }
        if (forceRefresh) {
            httpGet.addHeader("x-ms-force-refresh", Boolean.TRUE.toString());
            headers.put("x-ms-force-refresh", Boolean.TRUE.toString());
        }
        Date currentTime = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        String xDate = sdf.format(currentTime);
        httpGet.addHeader("x-ms-date", xDate);
        headers.put("x-ms-date", xDate);
        String token = null;
        token = !request.getIsNameBased() ? this.authorizationTokenProvider.generateKeyAuthorizationSignature("get", request.getResourceAddress().toLowerCase(), resourceType, headers) : this.authorizationTokenProvider.generateKeyAuthorizationSignature("get", request.getResourceFullName(), resourceType, headers);
        try {
            httpGet.addHeader("authorization", URLEncoder.encode(token, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unsupported encoding", e);
        }
        if (this.proxy != null) {
            RequestConfig requestConfig = RequestConfig.custom().setProxy(this.proxy).build();
            httpGet.setConfig(requestConfig);
        }
        HttpResponse httpResponse = null;
        try {
            httpResponse = this.httpClient.execute((HttpUriRequest)httpGet);
            ErrorUtils.maybeThrowException(targetEndpoint.getPath(), httpResponse, true, this.logger);
        }
        catch (IOException e) {
            httpGet.releaseConnection();
            throw new IllegalStateException("Http client execution failed.", e);
        }
        catch (DocumentClientException e) {
            httpGet.releaseConnection();
            throw new IllegalStateException("Http client execution failed.", e);
        }
        catch (Exception e) {
            httpGet.releaseConnection();
            throw e;
        }
        DocumentServiceResponse response = new DocumentServiceResponse(httpResponse, request.getIsMedia());
        List<Address> addresses = response.getQueryResponse(Address.class);
        return addresses;
    }

    public static boolean isReadingFromMaster(ResourceType resourceType, OperationType operationType) {
        return resourceType == ResourceType.Offer || resourceType == ResourceType.Database || resourceType == ResourceType.User || resourceType == ResourceType.Permission || resourceType == ResourceType.Topology || resourceType == ResourceType.DatabaseAccount || resourceType == ResourceType.PartitionKeyRange || resourceType == ResourceType.DocumentCollection && (operationType == OperationType.ReadFeed || operationType == OperationType.Query || operationType == OperationType.SqlQuery);
    }
}

