/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.directconnectivity;

import com.microsoft.azure.documentdb.ConsistencyLevel;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.Error;
import com.microsoft.azure.documentdb.internal.AuthorizationTokenProvider;
import com.microsoft.azure.documentdb.internal.DatabaseAccountConfigurationProvider;
import com.microsoft.azure.documentdb.internal.DocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.RequestChargeTracker;
import com.microsoft.azure.documentdb.internal.SessionContainer;
import com.microsoft.azure.documentdb.internal.directconnectivity.AddressCache;
import com.microsoft.azure.documentdb.internal.directconnectivity.QuorumReader;
import com.microsoft.azure.documentdb.internal.directconnectivity.StoreReadResult;
import com.microsoft.azure.documentdb.internal.directconnectivity.StoreReader;
import com.microsoft.azure.documentdb.internal.directconnectivity.StoreResponse;
import com.microsoft.azure.documentdb.internal.directconnectivity.TransportClient;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.StringUtils;

public class ConsistencyReader {
    private StoreReader storeReader;
    private DatabaseAccountConfigurationProvider databaseAccountConfigurationProvider;
    private QuorumReader quorumReader;
    private AuthorizationTokenProvider authorizationTokenProvider;

    public ConsistencyReader(AddressCache addressCache, SessionContainer sessionContainer, TransportClient transportClient, DatabaseAccountConfigurationProvider databaseAccountConfigurationProvider, AuthorizationTokenProvider authorizationTokenProvider, ExecutorService executorService) {
        this.databaseAccountConfigurationProvider = databaseAccountConfigurationProvider;
        this.authorizationTokenProvider = authorizationTokenProvider;
        this.storeReader = new StoreReader(addressCache, transportClient, sessionContainer, executorService);
        this.quorumReader = new QuorumReader(this.storeReader, this.authorizationTokenProvider);
    }

    public StoreResponse read(DocumentServiceRequest request) throws DocumentClientException {
        if (request.getRequestChargeTracker() == null) {
            request.setRequestChargeTracker(new RequestChargeTracker());
        }
        int maxReplicaCount = this.databaseAccountConfigurationProvider.getMaxReplicaSetSize();
        int readQuorumValue = maxReplicaCount - maxReplicaCount / 2;
        if (request.getDefaultReplicaIndex() != null) {
            return this.storeReader.readPrimary(request, false).toStoreResponse(null);
        }
        switch (this.getRequiredConsistencyLevel(request)) {
            case Session: {
                return this.readSession(request);
            }
            case Eventual: 
            case ConsistentPrefix: {
                return this.readAny(request);
            }
            case BoundedStaleness: {
                return this.quorumReader.readBoundedStaleness(request, readQuorumValue);
            }
            case Strong: {
                return this.quorumReader.readStrong(request, readQuorumValue);
            }
        }
        throw new IllegalStateException("Unsupported consistency level.");
    }

    private ConsistencyLevel getRequiredConsistencyLevel(DocumentServiceRequest request) throws DocumentClientException {
        ConsistencyLevel targetConsistency = this.databaseAccountConfigurationProvider.getStoreConsistencyPolicy();
        String requestedConsistencyLevelStr = request.getHeaders().get("x-ms-consistency-level");
        if (StringUtils.isNotEmpty((CharSequence)requestedConsistencyLevelStr)) {
            ConsistencyLevel requestedConsistency;
            targetConsistency = requestedConsistency = ConsistencyLevel.valueOf(requestedConsistencyLevelStr);
        }
        return targetConsistency;
    }

    private StoreResponse readSession(DocumentServiceRequest request) throws DocumentClientException {
        StoreReadResult response = this.storeReader.readSession(request);
        if (response == null) {
            DocumentClientException e = new DocumentClientException(404, new Error(String.valueOf(404), "The read session is not available for the input session token."), (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("x-ms-substatus", String.valueOf(1002));
                }
            });
            throw e;
        }
        return response.toStoreResponse(request.getRequestChargeTracker());
    }

    private StoreResponse readAny(DocumentServiceRequest request) throws DocumentClientException {
        StoreReadResult response = this.storeReader.readEventual(request);
        if (response == null) {
            throw new DocumentClientException(410, "The requested resource is no longer available at the server.");
        }
        return response.toStoreResponse(request.getRequestChargeTracker());
    }

    String getLastReadAddress() {
        return this.storeReader.getLastReadAddress();
    }

    void setLastReadAddress(String lastReadAddress) {
        this.storeReader.setLastReadAddress(lastReadAddress);
    }
}

