/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.documentdb.ConsistencyLevel;
import com.microsoft.azure.documentdb.DocumentCollection;
import com.microsoft.azure.documentdb.internal.OperationType;
import com.microsoft.azure.documentdb.internal.ResourceId;
import com.microsoft.azure.documentdb.internal.ResourceType;
import com.microsoft.azure.documentdb.internal.RuntimeConstants;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;

public class Utils {
    private static final ObjectMapper simpleObjectMapper = new ObjectMapper();

    public static String encodeBase64String(byte[] binaryData) {
        String encodedString = Base64.encodeBase64String((byte[])binaryData);
        if (encodedString.endsWith("\r\n")) {
            encodedString = encodedString.substring(0, encodedString.length() - 2);
        }
        return encodedString;
    }

    public static boolean isNameBased(String link) {
        String[] parts;
        if (StringUtils.isEmpty((CharSequence)link)) {
            return false;
        }
        if (link.startsWith("/") && link.length() > 1) {
            link = link.substring(1);
        }
        if ((parts = link.split("/")).length == 0 || StringUtils.isEmpty((CharSequence)parts[0]) || !parts[0].equalsIgnoreCase("dbs")) {
            return false;
        }
        if (parts.length < 2 || StringUtils.isEmpty((CharSequence)parts[1])) {
            return false;
        }
        String databaseID = parts[1];
        if (databaseID.length() != 8) {
            return true;
        }
        byte[] buffer = ResourceId.fromBase64String(databaseID);
        return buffer.length != 4;
    }

    public static boolean isDatabaseLink(String link) {
        if (StringUtils.isEmpty((CharSequence)link)) {
            return false;
        }
        String[] parts = (link = Utils.trimBeginingAndEndingSlashes(link)).split("/");
        if (parts.length != 2) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)parts[0]) || !parts[0].equalsIgnoreCase("dbs")) {
            return false;
        }
        return !StringUtils.isEmpty((CharSequence)parts[1]);
    }

    public static boolean IsResourceType(String resourcePathSegment) {
        if (StringUtils.isEmpty((CharSequence)resourcePathSegment)) {
            return false;
        }
        switch (resourcePathSegment.toLowerCase()) {
            case "attachments": 
            case "colls": 
            case "dbs": 
            case "permissions": 
            case "users": 
            case "docs": 
            case "sprocs": 
            case "triggers": 
            case "udfs": 
            case "conflicts": 
            case "pkranges": {
                return true;
            }
        }
        return false;
    }

    public static String joinPath(String path1, String path2) {
        path1 = Utils.trimBeginingAndEndingSlashes(path1);
        String result = "/" + path1 + "/";
        if (!StringUtils.isEmpty((CharSequence)path2)) {
            path2 = Utils.trimBeginingAndEndingSlashes(path2);
            result = result + path2 + "/";
        }
        return result;
    }

    public static String trimBeginingAndEndingSlashes(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static URL setQuery(String urlString, String query) {
        if (urlString == null) {
            throw new IllegalStateException("urlString parameter can't be null.");
        }
        query = Utils.removeLeadingQuestionMark(query);
        try {
            if (query != null && !query.isEmpty()) {
                return new URI(Utils.addTrailingSlash(urlString) + RuntimeConstants.Separators.Query[0] + query).toURL();
            }
            return new URI(Utils.addTrailingSlash(urlString)).toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Uri is invalid: ", e);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Uri is invalid: ", e);
        }
    }

    public static String createQuery(List<NameValuePair> queryParameters) {
        if (queryParameters == null) {
            return "";
        }
        StringBuilder queryString = new StringBuilder();
        for (NameValuePair nameValuePair : queryParameters) {
            String key = nameValuePair.getName();
            String value = nameValuePair.getValue();
            if (key == null || key.isEmpty()) continue;
            if (queryString.length() > 0) {
                queryString.append(RuntimeConstants.Separators.Query[1]);
            }
            queryString.append(key);
            if (value == null) continue;
            queryString.append(RuntimeConstants.Separators.Query[2]);
            queryString.append(value);
        }
        return queryString.toString();
    }

    public static String getCollectionName(String resourceFullName) {
        if (resourceFullName != null) {
            resourceFullName = Utils.trimBeginingAndEndingSlashes(resourceFullName);
            int slashCount = 0;
            for (int i = 0; i < resourceFullName.length(); ++i) {
                if (resourceFullName.charAt(i) != '/' || ++slashCount != 4) continue;
                return resourceFullName.substring(0, i);
            }
        }
        return resourceFullName;
    }

    public static Boolean isCollectionPartitioned(DocumentCollection collection) {
        if (collection == null) {
            throw new IllegalArgumentException("collection");
        }
        return collection.getPartitionKey() != null && collection.getPartitionKey().getPaths() != null && collection.getPartitionKey().getPaths().size() > 0;
    }

    public static boolean isCollectionChild(ResourceType type) {
        return type == ResourceType.Document || type == ResourceType.Attachment || type == ResourceType.Conflict || type == ResourceType.StoredProcedure || type == ResourceType.Trigger || type == ResourceType.UserDefinedFunction;
    }

    public static boolean isWriteOperation(OperationType operationType) {
        return operationType == OperationType.Create || operationType == OperationType.Upsert || operationType == OperationType.Delete || operationType == OperationType.Replace || operationType == OperationType.ExecuteJavaScript;
    }

    public static boolean isFeedRequest(OperationType requestOperationType) {
        return requestOperationType == OperationType.Create || requestOperationType == OperationType.Upsert || requestOperationType == OperationType.ReadFeed || requestOperationType == OperationType.Query || requestOperationType == OperationType.SqlQuery;
    }

    private static String addTrailingSlash(String path) {
        if (path == null || path.isEmpty()) {
            path = new String(RuntimeConstants.Separators.Url);
        } else if (path.charAt(path.length() - 1) != RuntimeConstants.Separators.Url[0]) {
            path = path + RuntimeConstants.Separators.Url[0];
        }
        return path;
    }

    private static String removeLeadingQuestionMark(String path) {
        if (path == null || path.isEmpty()) {
            return path;
        }
        if (path.charAt(0) == RuntimeConstants.Separators.Query[0]) {
            return path.substring(1);
        }
        return path;
    }

    public static boolean isValidConsistency(ConsistencyLevel backendConsistency, ConsistencyLevel desiredConsistency) {
        switch (backendConsistency) {
            case Strong: {
                return desiredConsistency == ConsistencyLevel.Strong || desiredConsistency == ConsistencyLevel.BoundedStaleness || desiredConsistency == ConsistencyLevel.Session || desiredConsistency == ConsistencyLevel.Eventual || desiredConsistency == ConsistencyLevel.ConsistentPrefix;
            }
            case BoundedStaleness: {
                return desiredConsistency == ConsistencyLevel.BoundedStaleness || desiredConsistency == ConsistencyLevel.Session || desiredConsistency == ConsistencyLevel.Eventual || desiredConsistency == ConsistencyLevel.ConsistentPrefix;
            }
            case Session: 
            case Eventual: 
            case ConsistentPrefix: {
                return desiredConsistency == ConsistencyLevel.Session || desiredConsistency == ConsistencyLevel.Eventual || desiredConsistency == ConsistencyLevel.ConsistentPrefix;
            }
        }
        throw new IllegalArgumentException("backendConsistency");
    }

    public static String getUserAgent(String sdkName, String sdkVersion) {
        String osName = System.getProperty("os.name");
        if (osName == null) {
            osName = "Unknown";
        }
        osName = osName.replaceAll("\\s", "");
        String userAgent = String.format("%s/%s JRE/%s %s/%s", osName, System.getProperty("os.version"), System.getProperty("java.version"), sdkName, sdkVersion);
        return userAgent;
    }

    public static ObjectMapper getSimpleObjectMapper() {
        return simpleObjectMapper;
    }

    static {
        simpleObjectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

