/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal;

import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.internal.DocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.SessionContainer;
import org.apache.commons.lang3.StringUtils;

public class SessionTokenHelper {
    public static void setPartitionLocalSessionToken(DocumentServiceRequest request, SessionContainer sessionContainer) throws DocumentClientException {
        String originalSessionToken = request.getHeaders().get("x-ms-session-token");
        String partitionKeyRangeId = request.getResolvedPartitionKeyRangeId();
        if (StringUtils.isNotEmpty((CharSequence)originalSessionToken)) {
            long sessionLsn = SessionTokenHelper.getLocalSessionToken(originalSessionToken, partitionKeyRangeId);
            request.setSessionLsn(sessionLsn);
        } else {
            String sessionToken = sessionContainer.resolveSessionToken(request);
            if (StringUtils.isNotEmpty((CharSequence)sessionToken)) {
                long sessionLsn = SessionTokenHelper.getLocalSessionToken(sessionToken, partitionKeyRangeId);
                request.setSessionLsn(sessionLsn);
            }
        }
        if (request.getSessionLsn() == -1L) {
            request.getHeaders().remove("x-ms-session-token");
        } else {
            request.getHeaders().put("x-ms-session-token", String.format("%1s:%2d", "0", request.getSessionLsn()));
        }
    }

    private static long getLocalSessionToken(String sessionToken, String partitionKeyRangeId) throws DocumentClientException {
        String[] localTokens;
        if (partitionKeyRangeId == null || partitionKeyRangeId.isEmpty()) {
            throw new IllegalStateException("Partition key range Id is absent in the context.");
        }
        for (String localToken : localTokens = sessionToken.split(",")) {
            String[] items = localToken.split(":");
            Long tokenLsn = null;
            if (items.length == 2) {
                try {
                    tokenLsn = Long.parseLong(items[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (tokenLsn == null) {
                throw new DocumentClientException(400, "Invalid session token value.");
            }
            if (!items[0].equals(partitionKeyRangeId)) continue;
            return tokenLsn;
        }
        return -1L;
    }
}

