/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import com.microsoft.azure.documentdb.ConnectionPolicy;
import com.microsoft.azure.documentdb.DatabaseAccount;
import com.microsoft.azure.documentdb.DatabaseAccountLocation;
import com.microsoft.azure.documentdb.DatabaseAccountManagerInternal;
import com.microsoft.azure.documentdb.DocumentClient;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.internal.EndpointManager;
import com.microsoft.azure.documentdb.internal.OperationType;
import com.microsoft.azure.documentdb.internal.Utils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GlobalEndpointManager
implements EndpointManager {
    private final Logger logger = LoggerFactory.getLogger(GlobalEndpointManager.class);
    private final DatabaseAccountManagerInternal client;
    private final Collection<String> preferredLocations;
    private final boolean enableEndpointDiscovery;
    private final URI defaultEndpoint;
    private Map<String, URI> readableLocations;
    private Map<String, URI> writableLocations;
    private URI currentWriteLocation;
    private URI currentReadLocation;
    private boolean initialized;
    private boolean refreshing;

    public GlobalEndpointManager(final DocumentClient client) {
        this(new DatabaseAccountManagerInternal(){

            @Override
            public URI getServiceEndpoint() {
                return client.getServiceEndpoint();
            }

            @Override
            public DatabaseAccount getDatabaseAccountFromEndpoint(URI endpoint) throws DocumentClientException {
                return client.getDatabaseAccountFromEndpoint(endpoint);
            }

            @Override
            public ConnectionPolicy getConnectionPolicy() {
                return client.getConnectionPolicy();
            }
        });
    }

    public GlobalEndpointManager(DatabaseAccountManagerInternal client) {
        this.client = client;
        this.preferredLocations = client.getConnectionPolicy().getPreferredLocations();
        this.enableEndpointDiscovery = client.getConnectionPolicy().getEnableEndpointDiscovery();
        this.defaultEndpoint = client.getServiceEndpoint();
        this.initialized = false;
        this.refreshing = false;
    }

    @Override
    public URI getWriteEndpoint() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.currentWriteLocation;
    }

    @Override
    public URI getReadEndpoint() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.currentReadLocation;
    }

    @Override
    public URI resolveServiceEndpoint(OperationType operationType) {
        URI endpoint = null;
        endpoint = Utils.isWriteOperation(operationType) ? this.getWriteEndpoint() : this.getReadEndpoint();
        if (endpoint == null) {
            endpoint = this.defaultEndpoint;
        }
        return endpoint;
    }

    @Override
    public synchronized void refreshEndpointList() {
        if (this.refreshing) {
            return;
        }
        this.refreshing = true;
        try {
            this.refreshEndpointListInternal();
        }
        finally {
            this.refreshing = false;
        }
    }

    @Override
    public DatabaseAccount getDatabaseAccountFromAnyEndpoint() {
        DatabaseAccount databaseAccount = null;
        try {
            databaseAccount = this.client.getDatabaseAccountFromEndpoint(this.defaultEndpoint);
            if (databaseAccount == null && this.preferredLocations != null && this.preferredLocations.size() > 0) {
                String regionName;
                URI regionalUri;
                Iterator<String> iterator = this.preferredLocations.iterator();
                while (iterator.hasNext() && ((regionalUri = this.getRegionalEndpoint(regionName = iterator.next())) == null || (databaseAccount = this.client.getDatabaseAccountFromEndpoint(regionalUri)) == null)) {
                }
            }
        }
        catch (DocumentClientException e) {
            this.logger.warn("Failed to retrieve database account information. {}", (Object)e.toString());
        }
        return databaseAccount;
    }

    private synchronized void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.refreshEndpointListInternal();
    }

    private void refreshEndpointListInternal() {
        DatabaseAccount databaseAccount;
        HashMap<String, URI> writableLocations = new HashMap<String, URI>();
        HashMap<String, URI> readableLocations = new HashMap<String, URI>();
        if (this.enableEndpointDiscovery && (databaseAccount = this.getDatabaseAccountFromAnyEndpoint()) != null) {
            URI regionUri;
            if (databaseAccount.getWritableLocations() != null) {
                for (DatabaseAccountLocation location : databaseAccount.getWritableLocations()) {
                    if (!StringUtils.isNotEmpty((CharSequence)location.getName())) continue;
                    regionUri = null;
                    try {
                        regionUri = new URI(location.getEndpoint());
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                    if (regionUri == null) continue;
                    writableLocations.put(location.getName(), regionUri);
                }
            }
            if (databaseAccount.getReadableLocations() != null) {
                for (DatabaseAccountLocation location : databaseAccount.getReadableLocations()) {
                    if (!StringUtils.isNotEmpty((CharSequence)location.getName())) continue;
                    regionUri = null;
                    try {
                        regionUri = new URI(location.getEndpoint());
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                    if (regionUri == null) continue;
                    readableLocations.put(location.getName(), regionUri);
                }
            }
        }
        this.updateEndpointsCache(writableLocations, readableLocations);
    }

    private synchronized void updateEndpointsCache(Map<String, URI> writableLocations, Map<String, URI> readableLocations) {
        this.writableLocations = writableLocations;
        this.readableLocations = readableLocations;
        if (!this.enableEndpointDiscovery) {
            this.currentReadLocation = this.defaultEndpoint;
            this.currentWriteLocation = this.defaultEndpoint;
            return;
        }
        if (this.writableLocations.size() == 0) {
            this.currentWriteLocation = this.defaultEndpoint;
        } else {
            Iterator<Map.Entry<String, URI>> iterator = this.writableLocations.entrySet().iterator();
            this.currentWriteLocation = iterator.next().getValue();
        }
        URI newReadRegion = null;
        if (this.readableLocations.size() == 0) {
            newReadRegion = this.currentWriteLocation;
        } else if (this.preferredLocations == null || this.preferredLocations.size() == 0) {
            newReadRegion = this.currentWriteLocation;
        } else {
            for (String regionName : this.preferredLocations) {
                if (StringUtils.isNotEmpty((CharSequence)regionName) && ((newReadRegion = this.readableLocations.get(regionName)) != null || (newReadRegion = this.writableLocations.get(regionName)) != null)) break;
            }
        }
        this.currentReadLocation = newReadRegion != null ? newReadRegion : this.currentWriteLocation;
        this.logger.trace("updateEndpointsCache: current read location {}", (Object)this.currentReadLocation);
    }

    URI getRegionalEndpoint(String regionName) {
        if (StringUtils.isNotEmpty((CharSequence)regionName)) {
            String databaseAccountName = this.defaultEndpoint.getHost();
            int indexOfDot = this.defaultEndpoint.getHost().indexOf(46);
            if (indexOfDot >= 0) {
                databaseAccountName = databaseAccountName.substring(0, indexOfDot);
            }
            String regionalAccountName = databaseAccountName + "-" + regionName.replace(" ", "");
            String regionalUrl = this.defaultEndpoint.toString().replaceFirst(databaseAccountName, regionalAccountName);
            try {
                return new URI(regionalUrl);
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
        return null;
    }
}

