/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import com.microsoft.azure.documentdb.ConsistencyPolicy;
import com.microsoft.azure.documentdb.DatabaseAccountLocation;
import com.microsoft.azure.documentdb.ReplicationPolicy;
import com.microsoft.azure.documentdb.Resource;
import org.json.JSONObject;

public class DatabaseAccount
extends Resource {
    private ConsistencyPolicy consistencyPolicy;
    private long maxMediaStorageUsageInMB;
    private long mediaStorageUsageInMB;
    private ReplicationPolicy replicationPolicy;

    DatabaseAccount() {
        this.setSelfLink("");
    }

    public DatabaseAccount(String jsonString) {
        super(jsonString);
    }

    public DatabaseAccount(JSONObject jsonObject) {
        super(jsonObject);
    }

    public String getDatabasesLink() {
        return super.getString("_dbs");
    }

    void setDatabasesLink(String databasesLink) {
        super.set("_dbs", databasesLink);
    }

    public String getMediaLink() {
        return super.getString("media");
    }

    void setMediaLink(String medialink) {
        super.set("media", medialink);
    }

    public String getAddressesLink() {
        return super.getString("addresses");
    }

    void setAddressesLink(String addresseslink) {
        super.set("addresses", addresseslink);
    }

    public long getMaxMediaStorageUsageInMB() {
        return this.maxMediaStorageUsageInMB;
    }

    void setMaxMediaStorageUsageInMB(long value) {
        this.maxMediaStorageUsageInMB = value;
    }

    public long getMediaStorageUsageInMB() {
        return this.mediaStorageUsageInMB;
    }

    void setMediaStorageUsageInMB(long value) {
        this.mediaStorageUsageInMB = value;
    }

    public ConsistencyPolicy getConsistencyPolicy() {
        if (this.consistencyPolicy == null) {
            this.consistencyPolicy = super.getObject("userConsistencyPolicy", ConsistencyPolicy.class);
            if (this.consistencyPolicy == null) {
                this.consistencyPolicy = new ConsistencyPolicy();
            }
        }
        return this.consistencyPolicy;
    }

    public ReplicationPolicy getReplicationPolicy() {
        if (this.replicationPolicy == null) {
            this.replicationPolicy = super.getObject("replicationPolicy", ReplicationPolicy.class);
            if (this.replicationPolicy == null) {
                this.replicationPolicy = new ReplicationPolicy();
            }
        }
        return this.replicationPolicy;
    }

    public Iterable<DatabaseAccountLocation> getWritableLocations() {
        return super.getCollection("writableLocations", DatabaseAccountLocation.class);
    }

    void setWritableLocations(Iterable<DatabaseAccountLocation> locations) {
        super.set("writableLocations", locations);
    }

    public Iterable<DatabaseAccountLocation> getReadableLocations() {
        return super.getCollection("readableLocations", DatabaseAccountLocation.class);
    }

    void setReadableLocations(Iterable<DatabaseAccountLocation> locations) {
        super.set("readableLocations", locations);
    }

    @Override
    void populatePropertyBag() {
        if (this.consistencyPolicy != null) {
            this.consistencyPolicy.populatePropertyBag();
            super.set("userConsistencyPolicy", this.consistencyPolicy);
        }
    }
}

