/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import com.microsoft.azure.documentdb.ConnectionMode;
import com.microsoft.azure.documentdb.MediaReadMode;
import com.microsoft.azure.documentdb.RetryOptions;
import java.util.Collection;
import org.apache.http.HttpHost;

public final class ConnectionPolicy {
    private static final int DEFAULT_REQUEST_TIMEOUT = 60;
    private static final int DEFAULT_MEDIA_REQUEST_TIMEOUT = 300;
    private static final int DEFAULT_MAX_POOL_SIZE = 100;
    private static final int DEFAULT_IDLE_CONNECTION_TIMEOUT = 60;
    private static ConnectionPolicy default_policy = null;
    private int requestTimeout = 60;
    private int mediaRequestTimeout = 300;
    private ConnectionMode connectionMode = ConnectionMode.Gateway;
    private MediaReadMode mediaReadMode = MediaReadMode.Buffered;
    private int maxPoolSize = 100;
    private int idleConnectionTimeout = 60;
    private String userAgentSuffix = "";
    private RetryOptions retryOptions = new RetryOptions();
    private boolean enableEndpointDiscovery = true;
    private Collection<String> preferredLocations;
    private HttpHost proxy;

    public static ConnectionPolicy GetDefault() {
        if (default_policy == null) {
            default_policy = new ConnectionPolicy();
        }
        return default_policy;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public int getMediaRequestTimeout() {
        return this.mediaRequestTimeout;
    }

    public void setMediaRequestTimeout(int mediaRequestTimeout) {
        this.mediaRequestTimeout = mediaRequestTimeout;
    }

    public ConnectionMode getConnectionMode() {
        return this.connectionMode;
    }

    public void setConnectionMode(ConnectionMode connectionMode) {
        this.connectionMode = connectionMode;
    }

    public MediaReadMode getMediaReadMode() {
        return this.mediaReadMode;
    }

    public void setMediaReadMode(MediaReadMode mediaReadMode) {
        this.mediaReadMode = mediaReadMode;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public int getIdleConnectionTimeout() {
        return this.idleConnectionTimeout;
    }

    public void setIdleConnectionTimeout(int idleConnectionTimeout) {
        this.idleConnectionTimeout = idleConnectionTimeout;
    }

    public String getUserAgentSuffix() {
        return this.userAgentSuffix;
    }

    public void setUserAgentSuffix(String userAgentSuffix) {
        this.userAgentSuffix = userAgentSuffix;
    }

    @Deprecated
    public Integer getMaxRetryOnThrottledAttempts() {
        return this.retryOptions.getMaxRetryAttemptsOnThrottledRequests();
    }

    @Deprecated
    public void setMaxRetryOnThrottledAttempts(Integer maxRetryOnThrottledAttempts) {
        int maxAttempts = 0;
        if (maxRetryOnThrottledAttempts != null) {
            maxAttempts = maxRetryOnThrottledAttempts;
        }
        this.retryOptions.setMaxRetryAttemptsOnThrottledRequests(maxAttempts);
    }

    public RetryOptions getRetryOptions() {
        return this.retryOptions;
    }

    public void setRetryOptions(RetryOptions retryOptions) {
        if (retryOptions == null) {
            throw new IllegalArgumentException("retryOptions value must not be null.");
        }
        this.retryOptions = retryOptions;
    }

    public boolean getEnableEndpointDiscovery() {
        return this.enableEndpointDiscovery;
    }

    public void setEnableEndpointDiscovery(boolean enableEndpointDiscovery) {
        this.enableEndpointDiscovery = enableEndpointDiscovery;
    }

    public Collection<String> getPreferredLocations() {
        return this.preferredLocations;
    }

    public void setPreferredLocations(Collection<String> preferredLocations) {
        this.preferredLocations = preferredLocations;
    }

    public HttpHost getProxy() {
        return this.proxy;
    }

    public void setProxy(HttpHost proxy) {
        this.proxy = proxy;
    }

    public String toString() {
        return "ConnectionPolicy [requestTimeout=" + this.requestTimeout + ", mediaRequestTimeout=" + this.mediaRequestTimeout + ", connectionMode=" + (Object)((Object)this.connectionMode) + ", mediaReadMode=" + (Object)((Object)this.mediaReadMode) + ", maxPoolSize=" + this.maxPoolSize + ", idleConnectionTimeout=" + this.idleConnectionTimeout + ", userAgentSuffix=" + this.userAgentSuffix + ", retryOptions=" + this.retryOptions + ", enableEndpointDiscovery=" + this.enableEndpointDiscovery + ", preferredLocations=" + this.preferredLocations + "]";
    }
}

