/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.internal.httputils;

import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.applicationinsights.common.CommonUtils;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.util.ThreadLocalCleaner;
import com.microsoft.applicationinsights.telemetry.Duration;
import com.microsoft.applicationinsights.telemetry.RequestTelemetry;
import com.microsoft.applicationinsights.web.dependencies.apachecommons.lang3.Validate;
import com.microsoft.applicationinsights.web.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.web.internal.RequestTelemetryContext;
import com.microsoft.applicationinsights.web.internal.ThreadContext;
import com.microsoft.applicationinsights.web.internal.WebModulesContainer;
import com.microsoft.applicationinsights.web.internal.httputils.HttpExtractor;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public final class HttpServerHandler {
    private final HttpExtractor extractor;
    private final WebModulesContainer webModulesContainer;
    private final TelemetryClient telemetryClient;
    private final List<ThreadLocalCleaner> cleaners;

    public HttpServerHandler(HttpExtractor extractor, WebModulesContainer webModulesContainer, List<ThreadLocalCleaner> cleaners, TelemetryClient telemetryClient) {
        Validate.notNull(extractor, "extractor", new Object[0]);
        Validate.notNull(webModulesContainer, "WebModuleContainer", new Object[0]);
        Validate.notNull(cleaners, "ThreadLocalCleaners", new Object[0]);
        this.extractor = extractor;
        this.webModulesContainer = webModulesContainer;
        this.cleaners = cleaners;
        this.telemetryClient = telemetryClient;
    }

    public RequestTelemetryContext handleStart(ServletRequest request, ServletResponse response) throws MalformedURLException {
        RequestTelemetryContext context = new RequestTelemetryContext(new Date().getTime(), null);
        RequestTelemetry requestTelemetry = context.getHttpRequestTelemetry();
        ThreadContext.setRequestTelemetryContext(context);
        String method = this.extractor.getMethod(request);
        String userAgent = this.extractor.getUserAgent(request);
        String uriWithoutSessionId = this.extractor.getUri(request);
        String scheme = this.extractor.getScheme(request);
        String host = this.extractor.getHost(request);
        String query = this.extractor.getQuery(request);
        if (!CommonUtils.isNullOrEmpty(query)) {
            requestTelemetry.setUrl(scheme + "://" + host + uriWithoutSessionId + "?" + query);
        } else {
            requestTelemetry.setUrl(scheme + "://" + host + uriWithoutSessionId);
        }
        requestTelemetry.setHttpMethod(method);
        requestTelemetry.setName(method + " " + uriWithoutSessionId);
        requestTelemetry.setAllowAgentToOverrideName(true);
        requestTelemetry.getContext().getUser().setUserAgent(userAgent);
        requestTelemetry.setTimestamp(new Date(context.getRequestStartTimeTicks()));
        this.webModulesContainer.invokeOnBeginRequest(request, response);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEnd(ServletRequest request, ServletResponse response, RequestTelemetryContext context) {
        RequestTelemetry requestTelemetry = context.getHttpRequestTelemetry();
        long endTime = new Date().getTime();
        requestTelemetry.setDuration(new Duration(endTime - context.getRequestStartTimeTicks()));
        if (request.getAttribute("AI_CAUGHT_EXCEPTION") != null) {
            requestTelemetry.setSuccess(false);
            requestTelemetry.setResponseCode("500");
        } else {
            int resultCode = this.extractor.getStatusCode(response);
            requestTelemetry.setSuccess(resultCode < 400);
            requestTelemetry.setResponseCode(Integer.toString(resultCode));
        }
        if (ThreadContext.getRequestTelemetryContext() == null) {
            ThreadContext.setRequestTelemetryContext(context);
            try {
                this.webModulesContainer.invokeOnEndRequest(request, response);
            }
            finally {
                ThreadContext.remove();
            }
        } else {
            this.webModulesContainer.invokeOnEndRequest(request, response);
        }
        this.cleanup();
    }

    public void handleException(Exception e) {
        block4: {
            try {
                if (InternalLogger.INSTANCE.isTraceEnabled()) {
                    InternalLogger.INSTANCE.trace("Unhandled exception while processing request: %s", ExceptionUtils.getStackTrace(e));
                }
                if (this.telemetryClient != null) {
                    this.telemetryClient.trackException(e);
                }
            }
            catch (Exception ex) {
                if (!InternalLogger.INSTANCE.isErrorEnabled()) break block4;
                InternalLogger.INSTANCE.error("Error occurred tracking exception: " + ExceptionUtils.getStackTrace(ex), new Object[0]);
            }
        }
    }

    private void cleanup() {
        try {
            for (ThreadLocalCleaner cleaner : this.cleaners) {
                cleaner.clean();
            }
        }
        catch (Exception t) {
            InternalLogger.INSTANCE.warn(String.format("unable to perform TLS Cleaning: %s", ExceptionUtils.getStackTrace(t)), new Object[0]);
        }
    }
}

