/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.dependencies.http.impl.cookie;

import com.microsoft.applicationinsights.web.dependencies.http.annotation.Contract;
import com.microsoft.applicationinsights.web.dependencies.http.annotation.ThreadingBehavior;
import com.microsoft.applicationinsights.web.dependencies.http.cookie.ClientCookie;
import com.microsoft.applicationinsights.web.dependencies.http.cookie.CommonCookieAttributeHandler;
import com.microsoft.applicationinsights.web.dependencies.http.cookie.Cookie;
import com.microsoft.applicationinsights.web.dependencies.http.cookie.CookieOrigin;
import com.microsoft.applicationinsights.web.dependencies.http.cookie.CookieRestrictionViolationException;
import com.microsoft.applicationinsights.web.dependencies.http.cookie.MalformedCookieException;
import com.microsoft.applicationinsights.web.dependencies.http.cookie.SetCookie;
import com.microsoft.applicationinsights.web.dependencies.http.cookie.SetCookie2;
import com.microsoft.applicationinsights.web.dependencies.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RFC2965VersionAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        int version = -1;
        try {
            version = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            version = -1;
        }
        if (version < 0) {
            throw new MalformedCookieException("Invalid cookie version.");
        }
        cookie.setVersion(version);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie instanceof SetCookie2 && cookie instanceof ClientCookie && !((ClientCookie)cookie).containsAttribute("version")) {
            throw new CookieRestrictionViolationException("Violates RFC 2965. Version attribute is required.");
        }
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        return true;
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

