/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.telemetry;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.core.dependencies.google.common.base.Strings;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.schemav2.DependencyKind;
import com.microsoft.applicationinsights.internal.schemav2.DependencySourceType;
import com.microsoft.applicationinsights.internal.schemav2.RemoteDependencyData;
import com.microsoft.applicationinsights.internal.util.LocalStringsUtils;
import com.microsoft.applicationinsights.internal.util.Sanitizer;
import com.microsoft.applicationinsights.telemetry.BaseSampleSourceTelemetry;
import com.microsoft.applicationinsights.telemetry.Duration;
import java.util.Map;

public final class RemoteDependencyTelemetry
extends BaseSampleSourceTelemetry<RemoteDependencyData> {
    private Double samplingPercentage;
    private final RemoteDependencyData data = new RemoteDependencyData();
    public static final String ENVELOPE_NAME = "RemoteDependency";
    public static final String BASE_TYPE = "RemoteDependencyData";

    public RemoteDependencyTelemetry() {
        this.initialize(this.data.getProperties());
    }

    public RemoteDependencyTelemetry(String name) {
        this();
        this.setName(name);
    }

    public RemoteDependencyTelemetry(String dependencyName, String commandName, Duration duration, boolean success) {
        this(dependencyName);
        this.data.setData(commandName);
        this.data.setDuration(duration);
        this.data.setSuccess(success);
    }

    @Override
    public int getVer() {
        return this.getData().getVer();
    }

    public String getId() {
        return this.data.getId();
    }

    public void setId(String value) {
        this.data.setId(value);
    }

    public String getName() {
        return this.data.getName();
    }

    public void setName(String name) {
        if (Strings.isNullOrEmpty(name)) {
            throw new IllegalArgumentException("The event name cannot be null or empty");
        }
        this.data.setName(name);
    }

    public String getCommandName() {
        return this.data.getData();
    }

    public void setCommandName(String commandName) {
        this.data.setData(commandName);
    }

    @Deprecated
    public Integer getCount() {
        return null;
    }

    @Deprecated
    public void setCount(Integer value) {
    }

    @Deprecated
    public Double getMin() {
        return null;
    }

    @Deprecated
    public void setMin(Double value) {
    }

    @Deprecated
    public Double getMax() {
        return null;
    }

    @Deprecated
    public void setMax(Double value) {
    }

    @Deprecated
    public Double getStdDev() {
        return null;
    }

    @Deprecated
    public void setStdDev(Double value) {
    }

    @Deprecated
    public DependencyKind getDependencyKind() {
        DependencyKind result = DependencyKind.Other;
        String type = this.data.getType();
        if (!LocalStringsUtils.isNullOrEmpty(type)) {
            try {
                result = Enum.valueOf(DependencyKind.class, type);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    InternalLogger.INSTANCE.error("Exception while getting dependency kind: Type is empty", new Object[0]);
                    InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(t));
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    @Deprecated
    public void setDependencyKind(DependencyKind value) {
        this.data.setType(value.toString());
    }

    public String getType() {
        return this.data.getType();
    }

    public void setType(String value) {
        this.data.setType(value);
    }

    public String getTarget() {
        return this.data.getTarget();
    }

    public void setTarget(String value) {
        this.data.setTarget(value);
    }

    public void setResultCode(String value) {
        this.data.setResultCode(value);
    }

    public boolean getSuccess() {
        return this.data.getSuccess();
    }

    public void setSuccess(boolean value) {
        this.data.setSuccess(value);
    }

    @Deprecated
    public Boolean getAsync() {
        return false;
    }

    @Deprecated
    public void setAsync(Boolean value) {
    }

    @Deprecated
    public DependencySourceType getDependencySource() {
        return DependencySourceType.Undefined;
    }

    @Deprecated
    public void setDependencySource(DependencySourceType value) {
    }

    public Duration getDuration() {
        return this.data.getDuration();
    }

    public void setDuration(Duration duration) {
        this.data.setDuration(duration);
    }

    @Override
    public Double getSamplingPercentage() {
        return this.samplingPercentage;
    }

    @Override
    public void setSamplingPercentage(Double samplingPercentage) {
        this.samplingPercentage = samplingPercentage;
    }

    @Override
    @Deprecated
    protected void additionalSanitize() {
        this.data.setName(Sanitizer.sanitizeName(this.data.getName()));
    }

    @Override
    protected RemoteDependencyData getData() {
        return this.data;
    }

    @Override
    public String getEnvelopName() {
        return ENVELOPE_NAME;
    }

    @Override
    public String getBaseTypeName() {
        return BASE_TYPE;
    }

    public String getResultCode() {
        return this.getData().getResultCode();
    }

    public Map<String, Double> getMetrics() {
        return this.getData().getMeasurements();
    }
}

