/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.telemetry;

import com.microsoft.applicationinsights.core.dependencies.google.common.base.Preconditions;

public final class Duration {
    private static final String DAYS_FORMAT = "%02d.";
    private static final String HH_MM_SS_FORMAT = "%02d:%02d:%02d";
    private static final String MILLISECONDS_FORMAT = ".%03d0000";
    private static final long SECONDS_IN_ONE_MINUTE = 60L;
    private static final long SECONDS_IN_ONE_HOUR = 3600L;
    private static final long SECONDS_IN_ONE_DAY = 86400L;
    private static final long MINUTES_IN_ONE_HOUR = 60L;
    private static final long HOURS_IN_ONE_DAY = 24L;
    private final long days;
    private final int hours;
    private final int minutes;
    private final int seconds;
    private final int milliseconds;

    public Duration(long days, int hours, int minutes, int seconds, int milliseconds) {
        Preconditions.checkArgument(hours >= -23 && hours <= 23, "hours argument should be in the [-23, 23] range");
        Preconditions.checkArgument(minutes >= -59 && minutes <= 59, "minutes argument should be in the [-59, 59] range");
        Preconditions.checkArgument(seconds >= -59 && seconds <= 59, "seconds argument should be in the [-59, 59] range");
        Preconditions.checkArgument(milliseconds >= 0 && milliseconds <= 999, "milliseconds argument should be in the [0, 999] range");
        this.days = days;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
        this.milliseconds = milliseconds;
    }

    public Duration(long duration) {
        this.milliseconds = (int)(duration % 1000L);
        long durationInSeconds = duration / 1000L;
        this.seconds = (int)(durationInSeconds % 60L);
        this.minutes = (int)(durationInSeconds / 60L % 60L);
        this.hours = (int)(durationInSeconds / 3600L % 24L);
        this.days = durationInSeconds / 86400L;
    }

    public long getDays() {
        return this.days;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getMilliseconds() {
        return this.milliseconds;
    }

    public long getTotalMilliseconds() {
        return this.days * 86400L * 1000L + (long)this.hours * 3600L * 1000L + (long)this.minutes * 60L * 1000L + (long)this.seconds * 1000L + (long)this.milliseconds;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.days != 0L) {
            sb.append(String.format(DAYS_FORMAT, this.days));
        }
        sb.append(String.format(HH_MM_SS_FORMAT, this.hours, this.minutes, this.seconds));
        if (this.milliseconds > 0) {
            sb.append(String.format(MILLISECONDS_FORMAT, this.milliseconds));
        }
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Duration)) {
            return false;
        }
        Duration that = (Duration)other;
        return this.days == that.getDays() && this.hours == that.getHours() && this.minutes == that.getMinutes() && this.seconds == that.getSeconds() && this.milliseconds == that.getMilliseconds();
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (int)(this.days ^ this.days >>> 32);
        hash = 89 * hash + this.hours;
        hash = 89 * hash + this.minutes;
        hash = 89 * hash + this.seconds;
        hash = 89 * hash + this.milliseconds;
        return hash;
    }
}

