/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.util;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class PropertyHelper {
    public static final String SDK_VERSION_FILE_NAME = "sdk-version.properties";
    static final String STARTER_VERSION_FILE_NAME = "starter-version.properties";
    public static final String VERSION_STRING_PREFIX = "java:";
    public static final String VERSION_PROPERTY_NAME = "version";
    public static final String UNKNOWN_VERSION_VALUE = "unknown";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(String name) throws IOException {
        InputStream inputStream;
        Properties props = new Properties();
        ClassLoader classLoader = PropertyHelper.class.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if ((inputStream = classLoader.getResourceAsStream(name)) != null) {
            try {
                props.load(inputStream);
            }
            finally {
                inputStream.close();
            }
        }
        return props;
    }

    @Deprecated
    public static Properties getSdkVersionProperties() {
        try {
            return PropertyHelper.getProperties(SDK_VERSION_FILE_NAME);
        }
        catch (IOException e) {
            InternalLogger.INSTANCE.error("Could not find sdk version file '%s': %s", SDK_VERSION_FILE_NAME, ExceptionUtils.getStackTrace(e));
            return null;
        }
    }

    @Deprecated
    public static Properties getStarterVersionProperties() {
        try {
            return PropertyHelper.getProperties(STARTER_VERSION_FILE_NAME);
        }
        catch (IOException e) {
            InternalLogger.INSTANCE.error("Could not find starter version file '%s': %s", SDK_VERSION_FILE_NAME, ExceptionUtils.getStackTrace(e));
            return null;
        }
    }

    public static String getQualifiedSdkVersionString() {
        return SdkPropertyValues.SDK_VERSION_STRING;
    }

    public static String getSdkVersionNumber() {
        return SdkPropertyValues.SDK_VERSION_NUMBER;
    }

    public static String getStarterVersionString() {
        return StarterPropertyValues.STARTER_VERSION_STRING;
    }

    private PropertyHelper() {
    }

    private static class StarterPropertyValues {
        private static final String STARTER_VERSION_NUMBER;
        private static final String STARTER_VERSION_STRING;

        private StarterPropertyValues() {
        }

        static {
            Properties properties = PropertyHelper.getStarterVersionProperties();
            STARTER_VERSION_NUMBER = properties == null ? PropertyHelper.UNKNOWN_VERSION_VALUE : properties.getProperty(PropertyHelper.VERSION_PROPERTY_NAME, PropertyHelper.UNKNOWN_VERSION_VALUE);
            STARTER_VERSION_STRING = PropertyHelper.VERSION_STRING_PREFIX + STARTER_VERSION_NUMBER;
        }
    }

    private static class SdkPropertyValues {
        private static final String SDK_VERSION_STRING;
        private static final String SDK_VERSION_NUMBER;

        private SdkPropertyValues() {
        }

        static {
            Properties properties = PropertyHelper.getSdkVersionProperties();
            SDK_VERSION_NUMBER = properties == null ? PropertyHelper.UNKNOWN_VERSION_VALUE : properties.getProperty(PropertyHelper.VERSION_PROPERTY_NAME, PropertyHelper.UNKNOWN_VERSION_VALUE);
            SDK_VERSION_STRING = PropertyHelper.VERSION_STRING_PREFIX + SDK_VERSION_NUMBER;
        }
    }
}

