/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.util;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.StringUtils;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.shutdown.Stoppable;
import com.microsoft.applicationinsights.internal.util.ThreadPoolUtils;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class PeriodicTaskPool
implements Stoppable {
    private final Map<PeriodicRunnableTask, ScheduledFuture<?>> periodicTaskMap;
    private final ScheduledExecutorService periodicTaskService;
    private final int poolSize;

    public PeriodicTaskPool(int poolSize, String poolName) {
        if (poolSize < 1) {
            throw new IllegalArgumentException("ThreadPool size should be at least 1.");
        }
        if (StringUtils.isBlank(poolName)) {
            throw new IllegalArgumentException("poolName must be non-empty");
        }
        this.poolSize = poolSize;
        this.periodicTaskService = new ScheduledThreadPoolExecutor(this.poolSize, ThreadPoolUtils.createNamedDaemonThreadFactory(poolName));
        this.periodicTaskMap = new ConcurrentHashMap();
    }

    public ScheduledFuture<?> executePeriodicRunnableTask(PeriodicRunnableTask task) {
        if (task == null) {
            throw new NullPointerException(" Task cannot be null");
        }
        if (this.periodicTaskMap.containsKey(task)) {
            throw new IllegalStateException("Cannot have duplicate tasks");
        }
        ScheduledFuture<?> scheduledFuture = this.periodicTaskService.scheduleAtFixedRate(task.getCommand(), task.getInitialDelay(), task.getPeriod(), task.getUnit());
        this.periodicTaskMap.put(task, scheduledFuture);
        return scheduledFuture;
    }

    public boolean cancelPeriodicTask(PeriodicRunnableTask task) {
        if (task == null) {
            throw new NullPointerException("Task cannot be null");
        }
        if (!this.periodicTaskMap.containsKey(task)) {
            InternalLogger.INSTANCE.error(String.format("No such Task %s running", task), new Object[0]);
            return false;
        }
        ScheduledFuture<?> futureToCancel = this.periodicTaskMap.get(task);
        if (futureToCancel.isCancelled() || futureToCancel.isDone()) {
            InternalLogger.INSTANCE.info("Cannot cancel task %s, It is either completed or already cancelled", task);
            return false;
        }
        this.periodicTaskMap.remove(task);
        return futureToCancel.cancel(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(long timeout, TimeUnit timeUnit) {
        this.periodicTaskService.shutdown();
        try {
            if (!this.periodicTaskService.awaitTermination(timeout, timeUnit)) {
                this.periodicTaskService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.periodicTaskService.shutdownNow();
            Thread.currentThread().interrupt();
        }
        finally {
            this.stopAndClear();
        }
    }

    public void stopAndClear() {
        for (Map.Entry<PeriodicRunnableTask, ScheduledFuture<?>> entry : this.periodicTaskMap.entrySet()) {
            ScheduledFuture<?> futureToRemove = entry.getValue();
            if (!futureToRemove.isDone() && !futureToRemove.isCancelled()) {
                futureToRemove.cancel(true);
            }
            this.periodicTaskMap.remove(entry.getKey());
        }
    }

    ScheduledFuture<?> getTask(PeriodicRunnableTask task) {
        return this.periodicTaskMap.get(task);
    }

    public static final class PeriodicRunnableTask {
        private final Runnable command;
        private final long initialDelay;
        private final long period;
        private final TimeUnit unit;
        private final String taskId;

        private PeriodicRunnableTask(Runnable command, long initialDelay, long period, TimeUnit unit, String taskId) {
            PeriodicRunnableTask.validate(command, initialDelay, period, unit, taskId);
            this.command = command;
            this.initialDelay = initialDelay;
            this.period = period;
            this.unit = unit;
            this.taskId = taskId;
        }

        public static PeriodicRunnableTask createTask(Runnable command, long initialDelay, long period, TimeUnit unit, String taskId) {
            return new PeriodicRunnableTask(command, initialDelay, period, unit, taskId);
        }

        private static void validate(Runnable command, long initialDelay, long period, TimeUnit unit, String taskId) {
            if (command == null) {
                throw new IllegalArgumentException("Task cannot be null");
            }
            if (taskId == null || taskId.length() == 0) {
                throw new IllegalArgumentException("UniqueId of a task cannot be null or empty");
            }
            if (initialDelay < 0L) {
                throw new IllegalArgumentException("illegal value of initial delay of task execution");
            }
            if (period <= 0L) {
                throw new IllegalArgumentException("Illegal value of execution period. It cannot be 0 or less");
            }
            if (unit == null) {
                throw new IllegalArgumentException("Cannot have null TimeUnit");
            }
        }

        public Runnable getCommand() {
            return this.command;
        }

        public long getInitialDelay() {
            return this.initialDelay;
        }

        public long getPeriod() {
            return this.period;
        }

        public TimeUnit getUnit() {
            return this.unit;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PeriodicRunnableTask that = (PeriodicRunnableTask)o;
            return this.taskId.equals(that.taskId);
        }

        public int hashCode() {
            return Objects.hash(this.taskId);
        }

        public String toString() {
            return "PeriodicRunnableTask{command=" + this.command + ", initialDelay=" + this.initialDelay + ", period=" + this.period + ", unit=" + (Object)((Object)this.unit) + ", taskId='" + this.taskId + '\'' + '}';
        }
    }
}

