/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.quickpulse;

import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.quickpulse.QuickPulseCoordinator;
import com.microsoft.applicationinsights.internal.quickpulse.QuickPulseCoordinatorInitData;
import com.microsoft.applicationinsights.internal.quickpulse.QuickPulseDataCollector;
import com.microsoft.applicationinsights.internal.quickpulse.QuickPulseDataFetcher;
import com.microsoft.applicationinsights.internal.quickpulse.QuickPulseDataSender;
import com.microsoft.applicationinsights.internal.quickpulse.QuickPulsePingSender;
import com.microsoft.applicationinsights.internal.quickpulse.QuickPulseStatus;

final class DefaultQuickPulseCoordinator
implements QuickPulseCoordinator,
Runnable {
    private volatile boolean stopped = false;
    private volatile boolean pingMode = true;
    private final QuickPulsePingSender pingSender;
    private final QuickPulseDataFetcher dataFetcher;
    private final QuickPulseDataSender dataSender;
    private final long waitBetweenPingsInMS;
    private final long waitBetweenPostsInMS;
    private final long waitOnErrorInMS;

    public DefaultQuickPulseCoordinator(QuickPulseCoordinatorInitData initData) {
        this.dataSender = initData.dataSender;
        this.pingSender = initData.pingSender;
        this.dataFetcher = initData.dataFetcher;
        this.waitBetweenPingsInMS = initData.waitBetweenPingsInMS;
        this.waitBetweenPostsInMS = initData.waitBetweenPostsInMS;
        this.waitOnErrorInMS = initData.waitBetweenPingsInMS;
    }

    @Override
    public void run() {
        try {
            while (!this.stopped) {
                long sleepInMS = this.pingMode ? this.ping() : this.sendData();
                Thread.sleep(sleepInMS);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private long sendData() {
        this.dataFetcher.prepareQuickPulseDataForSend();
        QuickPulseStatus currentQPStatus = this.dataSender.getQuickPulseStatus();
        switch (currentQPStatus) {
            case ERROR: {
                this.pingMode = true;
                return this.waitOnErrorInMS;
            }
            case QP_IS_OFF: {
                this.pingMode = true;
                return this.waitBetweenPingsInMS;
            }
            case QP_IS_ON: {
                return this.waitBetweenPostsInMS;
            }
        }
        InternalLogger.INSTANCE.error("Critical error while sending QP data: unknown status, aborting", new Object[0]);
        QuickPulseDataCollector.INSTANCE.disable();
        this.stopped = true;
        return 0L;
    }

    private long ping() {
        QuickPulseStatus pingResult = this.pingSender.ping();
        switch (pingResult) {
            case ERROR: {
                return this.waitOnErrorInMS;
            }
            case QP_IS_ON: {
                this.pingMode = false;
                this.dataSender.startSending();
                return this.waitBetweenPostsInMS;
            }
            case QP_IS_OFF: {
                return this.waitBetweenPingsInMS;
            }
        }
        InternalLogger.INSTANCE.error("Critical error while ping QP: unknown status, aborting", new Object[0]);
        QuickPulseDataCollector.INSTANCE.disable();
        this.stopped = true;
        return 0L;
    }

    public void stop() {
        this.stopped = true;
    }
}

