/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.perfcounter;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.perfcounter.UnixParsingState;

final class UnixProcessIOtParser {
    private static final String READ_BYTES_PART = "read_bytes:";
    private static final String WRITE_BYTES_PART = "write_bytes:";
    private UnixParsingState state = new UnixParsingState(2);
    private boolean readBytesDone = false;
    private boolean writeBytesDone = false;

    UnixProcessIOtParser() {
    }

    boolean done() {
        return this.state.getDoneCounter() == 0;
    }

    double getValue() {
        return this.state.getReturnValue();
    }

    void process(String line) {
        if (!this.readBytesDone && this.parseValue(line, READ_BYTES_PART)) {
            this.readBytesDone = true;
            return;
        }
        if (!this.writeBytesDone && this.parseValue(line, WRITE_BYTES_PART)) {
            this.writeBytesDone = true;
        }
    }

    private boolean parseValue(String line, String part) {
        int index = line.indexOf(part);
        if (index != -1) {
            String doubleValueAsString = line.substring(index + part.length());
            try {
                this.state.addToReturnValue(Double.parseDouble(doubleValueAsString.trim()));
                this.state.decrementDoneCounter();
                return true;
            }
            catch (Exception e) {
                InternalLogger.INSTANCE.error("Error in parsing value of UnixProcess counter", new Object[0]);
                InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(e));
            }
        }
        return false;
    }
}

