/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.core.dependencies.annotation;

import com.microsoft.applicationinsights.core.dependencies.annotation.FileIterator;
import com.microsoft.applicationinsights.core.dependencies.annotation.ResourceIterator;
import com.microsoft.applicationinsights.core.dependencies.annotation.ZipFileIterator;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipFile;

final class ClassFileIterator
implements ResourceIterator {
    private final FileIterator fileIterator;
    private final String[] pkgNameFilter;
    private ZipFileIterator zipIterator;

    ClassFileIterator() throws IOException {
        this(ClassFileIterator.classPath(), null);
    }

    ClassFileIterator(File[] fileArray, String[] stringArray) throws IOException {
        this.fileIterator = new FileIterator(fileArray);
        this.pkgNameFilter = stringArray;
    }

    public String getName() {
        return this.zipIterator == null ? this.fileIterator.getFile().getPath() : this.zipIterator.getEntry().getName();
    }

    @Override
    public InputStream next() throws IOException {
        Object object;
        while (true) {
            if (this.zipIterator == null) {
                object = this.fileIterator.next();
                if (object == null || !((File)object).isFile()) {
                    return null;
                }
                String string = ((File)object).getName();
                if (string.endsWith(".class")) {
                    return new FileInputStream((File)object);
                }
                if (!this.fileIterator.isRootFile() || !ClassFileIterator.endsWithIgnoreCase(string, ".jar") && !this.isZipFile((File)object)) continue;
                this.zipIterator = new ZipFileIterator(new ZipFile((File)object), this.pkgNameFilter);
                continue;
            }
            object = this.zipIterator.next();
            if (object != null) break;
            this.zipIterator = null;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isZipFile(File file) {
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = new DataInputStream(new FileInputStream(file));
            int n = ((DataInputStream)filterInputStream).readInt();
            boolean bl = n == 1347093252;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static File[] classPath() {
        String[] stringArray = System.getProperty("java.class.path").split(File.pathSeparator);
        File[] fileArray = new File[stringArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i] = new File(stringArray[i]);
        }
        return fileArray;
    }

    private static boolean endsWithIgnoreCase(String string, String string2) {
        int n = string2.length();
        return string.regionMatches(true, string.length() - n, string2, 0, n);
    }
}

