/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sdk.sms.phonenumbers;

import com.mailersend.sdk.MailerSend;
import com.mailersend.sdk.MailerSendApi;
import com.mailersend.sdk.MailerSendResponse;
import com.mailersend.sdk.exceptions.MailerSendException;
import com.mailersend.sdk.sms.phonenumbers.PhoneNumber;
import com.mailersend.sdk.sms.phonenumbers.PhoneNumberList;
import com.mailersend.sdk.sms.phonenumbers.SinglePhoneNumberResponse;
import java.util.ArrayList;
import java.util.stream.IntStream;

public class PhoneNumbers {
    private MailerSend apiObjectReference;
    private int pageFilter = 1;
    private int limitFilter = 25;
    private Boolean pausedFilter;

    public PhoneNumbers(MailerSend ref) {
        this.apiObjectReference = ref;
    }

    public PhoneNumbers page(int page) {
        this.pageFilter = page;
        return this;
    }

    public PhoneNumbers limit(int limit) {
        this.limitFilter = limit;
        return this;
    }

    public PhoneNumbers paused(boolean paused) {
        this.pausedFilter = paused;
        return this;
    }

    public PhoneNumberList getPhoneNumbers() throws MailerSendException {
        String endpoint = "/sms-numbers".concat(this.prepareParamsUrl());
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        PhoneNumberList response = api.getRequest(endpoint, PhoneNumberList.class);
        response.postDeserialize();
        return response;
    }

    public PhoneNumber getPhoneNumber(String phoneNumberId) throws MailerSendException {
        String endpoint = "/sms-numbers/".concat(phoneNumberId);
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        SinglePhoneNumberResponse response = api.getRequest(endpoint, SinglePhoneNumberResponse.class);
        response.phoneNumber.postDeserialize();
        return response.phoneNumber;
    }

    public PhoneNumber updatePhoneNumber(String phoneNumberId, boolean paused) throws MailerSendException {
        String endpoint = "/sms-numbers/".concat(phoneNumberId).concat("?paused=").concat(String.valueOf(paused));
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        SinglePhoneNumberResponse response = api.putRequest(endpoint, null, SinglePhoneNumberResponse.class);
        response.phoneNumber.postDeserialize();
        return response.phoneNumber;
    }

    public boolean deletePhoneNumber(String phoneNumberId) throws MailerSendException {
        String endpoint = "/sms-numbers/".concat(phoneNumberId);
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        MailerSendResponse response = api.deleteRequest(endpoint, MailerSendResponse.class);
        return IntStream.of(200, 204, 202).anyMatch(x -> x == response.responseStatusCode);
    }

    private String prepareParamsUrl() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("page=".concat(String.valueOf(this.pageFilter)));
        params.add("limit=".concat(String.valueOf(this.limitFilter)));
        if (this.pausedFilter != null) {
            params.add("paused=".concat(this.pausedFilter.toString()));
        }
        String requestParams = "";
        for (int i = 0; i < params.size(); ++i) {
            String attrSep = "&";
            if (i == 0) {
                attrSep = "?";
            }
            requestParams = requestParams.concat(attrSep).concat((String)params.get(i));
        }
        return requestParams;
    }
}

