/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sdk.messages;

import com.mailersend.sdk.MailerSend;
import com.mailersend.sdk.MailerSendApi;
import com.mailersend.sdk.exceptions.MailerSendException;
import com.mailersend.sdk.messages.Message;
import com.mailersend.sdk.messages.MessagesList;
import com.mailersend.sdk.messages.SingleMessageResponse;
import java.util.ArrayList;

public class Messages {
    private MailerSend apiObjectReference;
    private int pageFilter = 1;
    private int limitFilter = 25;

    public Messages(MailerSend ref) {
        this.apiObjectReference = ref;
    }

    public Messages page(int page) {
        this.pageFilter = page;
        return this;
    }

    public Messages limit(int limit) {
        this.limitFilter = limit;
        return this;
    }

    public MessagesList getMessages() throws MailerSendException {
        String endpoint = "/messages".concat(this.prepareParamsUrl());
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        MessagesList response = api.getRequest(endpoint, MessagesList.class);
        response.postProcessing();
        return response;
    }

    public Message getMessage(String messageId) throws MailerSendException {
        String endpoint = "/messages/".concat(messageId);
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        SingleMessageResponse response = api.getRequest(endpoint, SingleMessageResponse.class);
        if (response.message != null) {
            response.message.parseDates();
        }
        return response.message;
    }

    private String prepareParamsUrl() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("page=".concat(String.valueOf(this.pageFilter)));
        params.add("limit=".concat(String.valueOf(this.limitFilter)));
        String requestParams = "";
        for (int i = 0; i < params.size(); ++i) {
            String attrSep = "&";
            if (i == 0) {
                attrSep = "?";
            }
            requestParams = requestParams.concat(attrSep).concat((String)params.get(i));
        }
        return requestParams;
    }
}

