/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sdk.inboundroutes;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mailersend.sdk.MailerSend;
import com.mailersend.sdk.MailerSendApi;
import com.mailersend.sdk.exceptions.MailerSendException;
import com.mailersend.sdk.inboundroutes.CatchFilter;
import com.mailersend.sdk.inboundroutes.Forward;
import com.mailersend.sdk.inboundroutes.InboundRoute;
import com.mailersend.sdk.inboundroutes.InboundRouteBuilderBody;
import com.mailersend.sdk.inboundroutes.MatchFilter;
import com.mailersend.sdk.inboundroutes.SingleInboundRouteResponse;
import com.mailersend.sdk.util.JsonSerializationDeserializationStrategy;

public class InboundRouteBuilder {
    private MailerSend apiObjectReference;
    private InboundRouteBuilderBody builderBody;

    public InboundRouteBuilder(MailerSend ref) {
        this.apiObjectReference = ref;
        this.builderBody = new InboundRouteBuilderBody();
    }

    public InboundRouteBuilder domainId(String domainId) {
        this.builderBody.domainId = domainId;
        return this;
    }

    public InboundRouteBuilder name(String name) {
        this.builderBody.name = name;
        return this;
    }

    public InboundRouteBuilder domainEnabled(boolean enabled) {
        this.builderBody.domainEnabled = enabled;
        return this;
    }

    public InboundRouteBuilder inboundDomain(String domain) {
        this.builderBody.inboundDomain = domain;
        return this;
    }

    public InboundRouteBuilder inboundAddress(String address) {
        this.builderBody.inboundAddress = address;
        return this;
    }

    public InboundRouteBuilder inboundSubdomain(String subdomain) {
        this.builderBody.inboundSubdomain = subdomain;
        return this;
    }

    public InboundRouteBuilder matchFilter(String type) {
        MatchFilter filter = new MatchFilter();
        filter.type = type;
        this.builderBody.matchFilter = filter;
        return this;
    }

    public InboundRouteBuilder catchFilter(CatchFilter filter) {
        this.builderBody.catchFilter = filter;
        return this;
    }

    public InboundRouteBuilder forwards(Forward[] forwards) {
        this.builderBody.forwards = forwards;
        return this;
    }

    public InboundRoute addRoute() throws MailerSendException {
        String endpoint = "/inbound";
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        Gson gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new JsonSerializationDeserializationStrategy(false)).addDeserializationExclusionStrategy((ExclusionStrategy)new JsonSerializationDeserializationStrategy(true)).create();
        String json = gson.toJson((Object)this.builderBody);
        this.builderBody.reset();
        SingleInboundRouteResponse response = api.postRequest(endpoint, json, SingleInboundRouteResponse.class);
        return response.route;
    }

    public InboundRoute updateRoute(String inboundRouteId) throws MailerSendException {
        String endpoint = "/inbound/" + inboundRouteId;
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        Gson gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new JsonSerializationDeserializationStrategy(false)).addDeserializationExclusionStrategy((ExclusionStrategy)new JsonSerializationDeserializationStrategy(true)).create();
        String json = gson.toJson((Object)this.builderBody);
        this.builderBody.reset();
        SingleInboundRouteResponse response = api.putRequest(endpoint, json, SingleInboundRouteResponse.class);
        return response.route;
    }
}

