/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sdk.activities;

import com.google.gson.annotations.SerializedName;
import com.mailersend.sdk.MailerSend;
import com.mailersend.sdk.MailerSendResponse;
import com.mailersend.sdk.activities.Activity;
import com.mailersend.sdk.exceptions.MailerSendException;
import com.mailersend.sdk.util.ResponseLinks;
import com.mailersend.sdk.util.ResponseMeta;
import java.util.Date;

public class ActivitiesList
extends MailerSendResponse {
    @SerializedName(value="data")
    public Activity[] activities;
    @SerializedName(value="meta")
    private ResponseMeta meta;
    @SerializedName(value="links")
    private ResponseLinks links;
    protected transient MailerSend mailersendObj;
    protected transient Date dateFrom;
    protected transient Date dateTo;
    protected transient String[] events;
    protected transient String domainId;

    public int getCurrentPage() {
        if (this.meta != null) {
            return this.meta.currentPage;
        }
        return 0;
    }

    public ActivitiesList nextPage() throws MailerSendException {
        if (this.mailersendObj != null) {
            int page = 1;
            int limit = 25;
            if (this.meta != null) {
                page = this.meta.currentPage + 1;
                limit = this.meta.limit;
            }
            return this.mailersendObj.activities().getActivities(this.domainId, page, limit, this.dateFrom, this.dateTo, this.events);
        }
        return null;
    }

    public ActivitiesList previousPage() throws MailerSendException {
        if (this.mailersendObj != null) {
            int page = 1;
            int limit = 25;
            if (this.meta != null) {
                page = this.meta.currentPage - 1;
                limit = this.meta.limit;
            }
            if (page == 0) {
                page = 1;
            }
            return this.mailersendObj.activities().getActivities(this.domainId, page, limit, this.dateFrom, this.dateTo, this.events);
        }
        return null;
    }

    protected ActivitiesList() {
    }

    public void postDeserialize() {
        for (Activity activity : this.activities) {
            activity.postDeserialize();
        }
    }
}

