/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.view.adapter.viewholder;

import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.model.Message;
import com.liveperson.infra.ui.view.adapter.viewholder.MiddleViewHolder;
import com.liveperson.infra.ui.view.resources.ResourceHelper;

public class UiUnreadIndicatorViewHolder
extends MiddleViewHolder {
    public UiUnreadIndicatorViewHolder(View itemView) {
        super(itemView);
        this.applyColors();
    }

    public void applyChanges(Bundle changes, Message message) {
        super.applyChanges(changes, message);
        String messageText = changes.getString("EXTRA_MESSAGE_TEXT", null);
        if (!TextUtils.isEmpty((CharSequence)messageText)) {
            this.setMessageTextView(messageText);
        }
        this.updateContentDescription();
    }

    public void applyColors() {
        ResourceHelper.updateTextColor((TextView)this.mMessageTextView, (int)R.color.unread_indicator_bubble_text_color);
        ResourceHelper.updateBackgroundSolidColor((View)this.mMessageTextView, (int)R.color.unread_indicator_bubble_background_color);
    }

    public void updateContentDescription() {
        this.setContentDescription(this.mMessageTextView.getText().toString());
    }
}

