/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.view.adapter.viewholder;

import android.content.Context;
import android.text.SpannableStringBuilder;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.view.View;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.utils.markdownlink.HyperLinkUtils;
import com.liveperson.infra.messaging_ui.utils.markdownlink.MarkdownHyperlinkItem;
import com.liveperson.infra.messaging_ui.view.adapter.ContextualMovementMethod;
import com.liveperson.infra.ui.view.adapter.viewholder.MiddleViewHolder;
import com.liveperson.infra.ui.view.resources.ResourceHelper;
import com.liveperson.infra.ui.view.utils.UIUtils;
import com.liveperson.infra.utils.LinkUtils;
import java.util.List;

public class AmsControllerSystemViewHolder
extends MiddleViewHolder {
    public AmsControllerSystemViewHolder(View itemView) {
        super(itemView);
        this.applyColors();
    }

    public void applyColors() {
        ResourceHelper.updateTextColor((TextView)this.mMessageTextView, (int)R.color.conversation_controller_message_text_color);
    }

    public void updateContentDescription() {
        this.setContentDescription(this.mMessageTextView.getText().toString());
    }

    public void setMessageTextView(String message) {
        if (LinkUtils.containsMarkdownHyperlink((String)message)) {
            List<MarkdownHyperlinkItem> hyperlinkItemList = HyperLinkUtils.INSTANCE.buildHyperlinkList(message);
            SpannableStringBuilder formattedMsg = HyperLinkUtils.INSTANCE.buildFormattedMessage(message, hyperlinkItemList, ContextCompat.getColor((Context)this.getContext(), (int)R.color.controller_message_markdown_hyperlink_text_color));
            this.mMessageTextView.setText((CharSequence)formattedMsg);
            this.mMessageTextView.setMovementMethod(LinkMovementMethod.getInstance());
            ViewCompat.enableAccessibleClickableSpanSupport((View)this.mMessageTextView);
        } else {
            super.setMessageTextView(message);
            if (UIUtils.containsHtmlTag((String)message)) {
                this.mMessageTextView.setMovementMethod((MovementMethod)new ContextualMovementMethod(null));
            }
        }
    }
}

