/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.view.adapter.viewholder;

import android.content.Context;
import android.graphics.PorterDuff;
import android.os.Bundle;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.view.adapter.ContextualMovementMethod;
import com.liveperson.infra.messaging_ui.view.adapter.copybehavior.ContextualActionBehavior;
import com.liveperson.infra.model.Message;
import com.liveperson.infra.ui.view.adapter.viewholder.BaseViewHolder;
import com.liveperson.infra.ui.view.adapter.viewholder.StartViewHolder;
import com.liveperson.infra.ui.view.resources.ResourceHelper;
import com.liveperson.infra.ui.view.utils.UIUtils;
import com.liveperson.infra.ui.view.utils.picasso.CircleTransform;
import com.liveperson.infra.utils.PicassoUtils;
import com.squareup.picasso.Transformation;

public class AmsAgentViewHolder
extends StartViewHolder {
    protected ImageView mAgentAvatar;
    protected String mAgentNickName;
    protected ContextualActionBehavior mContextualActionBehavior;
    protected boolean isCustomisedLink;

    public AmsAgentViewHolder(View itemView) {
        super(itemView);
        this.mAgentAvatar = (ImageView)itemView.findViewById(R.id.lpui_agent_bubbleAvatar);
        this.mAgentAvatar.setImageResource(R.drawable.lp_messaging_ui_ic_agent_avatar);
        this.setMessageTextListeners();
    }

    public void applyChanges(Bundle changes, Message message) {
        super.applyChanges(changes, message);
        String newAvatar = changes.getString("EXTRA_AGENT_AVATAR", null);
        if (newAvatar != null) {
            this.setAgentAvatar(newAvatar);
        }
    }

    public void onBind() {
        super.onBind();
        this.applyColors();
    }

    public void applyColors() {
        ResourceHelper.updateBackgroundStrokeColor((View)this.mMessageTextView, (int)R.color.agent_bubble_stroke_color, (int)R.dimen.agent_bubble_stroke_width);
        ResourceHelper.updateBackgroundSolidColor((View)this.mMessageTextView, (int)R.color.agent_bubble_background_color);
        ResourceHelper.updateTextColor((TextView)this.mMessageTextView, (int)R.color.agent_bubble_message_text_color);
        ResourceHelper.updateTextColor((TextView)this.mTimestampTextView, (int)R.color.agent_bubble_timestamp_text_color);
        ResourceHelper.updateTextColorLink((TextView)this.mMessageTextView, (int)R.color.agent_bubble_message_link_text_color);
    }

    public void updateContentDescription() {
        Context context = this.getContext();
        if (context != null) {
            String agentWord = context.getResources().getString(R.string.lp_accessibility_agent);
            String receivedWord = this.getStatusText();
            String linkWord = "";
            if (this.isCustomisedLink) {
                linkWord = context.getResources().getString(R.string.lp_accessibility_link);
                this.mMessageTextView.setContentDescription((CharSequence)(this.getTextToCopy() + ", " + linkWord + ", " + receivedWord + " " + this.mTimestampAccessibilityString));
            }
            this.setContentDescription(agentWord + " " + (!TextUtils.isEmpty((CharSequence)this.mAgentNickName) ? this.mAgentNickName : "") + ": " + this.mMessageTextView.getText().toString() + ", " + linkWord + ", " + receivedWord + " " + this.mTimestampAccessibilityString);
        }
    }

    public void setAgentAvatar(String avatarUrl) {
        this.setImage(avatarUrl);
    }

    public void setAgentAvatarAsBrand() {
        this.mAgentAvatar.setImageResource(R.drawable.lp_messaging_ui_brand_logo);
    }

    public void setAgentNickName(String agentNickName) {
        this.mAgentNickName = agentNickName;
    }

    private void setImage(String uriStr) {
        if (TextUtils.isEmpty((CharSequence)uriStr)) {
            this.mAgentAvatar.setImageResource(R.drawable.lp_messaging_ui_ic_agent_avatar);
            this.mAgentAvatar.setColorFilter(ContextCompat.getColor((Context)this.itemView.getContext(), (int)R.color.agent_avatar_icon_color), PorterDuff.Mode.MULTIPLY);
        } else {
            this.mAgentAvatar.setColorFilter(null);
            this.mAgentAvatar.setImageResource(R.drawable.lp_messaging_ui_ic_agent_avatar);
            PicassoUtils.get((Context)this.mAgentAvatar.getContext()).load(uriStr).noPlaceholder().transform((Transformation)new CircleTransform()).into(this.mAgentAvatar);
        }
    }

    public void setMessageText(String text, boolean enabled) {
        this.mMessageTextView.setAutoLinkMask(0);
        this.mMessageTextView.setLinksClickable(enabled);
        if (enabled) {
            int importantForAccessibility;
            this.mMessageTextView.setMovementMethod((MovementMethod)new ContextualMovementMethod(this.mContextualActionBehavior));
            this.setMessageTextView(text);
            this.removeUrlSpans();
            if (this.linkifyText(this.mMessageTextView)) {
                ViewCompat.enableAccessibleClickableSpanSupport((View)this.mMessageTextView);
                this.isCustomisedLink = true;
                importantForAccessibility = 1;
            } else {
                this.isCustomisedLink = false;
                importantForAccessibility = 2;
            }
            this.mMessageTextView.setImportantForAccessibility(importantForAccessibility);
        } else {
            this.setMessageTextView(text);
        }
        if (Configuration.getBoolean((int)R.bool.is_enable_enlarge_emojis)) {
            int textSizeInSp;
            int emojiHelper = UIUtils.detectEmojis((String)text);
            switch (emojiHelper) {
                case 1: {
                    textSizeInSp = (int)this.mMessageTextView.getContext().getResources().getDimension(R.dimen.xxxxlarge_text_size);
                    break;
                }
                case 2: {
                    textSizeInSp = (int)this.mMessageTextView.getContext().getResources().getDimension(R.dimen.xxxlarge_text_size);
                    break;
                }
                default: {
                    textSizeInSp = (int)this.mMessageTextView.getContext().getResources().getDimension(R.dimen.regular_text_size);
                }
            }
            this.mMessageTextView.setTextSize(0, (float)textSizeInSp);
        }
    }

    public void setContextualActionBehavior(ContextualActionBehavior contextualActionBehavior) {
        this.mContextualActionBehavior = contextualActionBehavior;
    }

    public boolean onLinkLongClick() {
        ContextualActionBehavior behavior = this.mContextualActionBehavior;
        if (behavior == null) {
            return false;
        }
        View.OnLongClickListener listener = behavior.getOnLongClickListener(this.getTimestampAsInteger(), (BaseViewHolder)this, null);
        return this.setContextualBehaviorOnLongClick(listener);
    }

    protected void setMessageTextListeners() {
        if (this.mMessageTextView == null) {
            return;
        }
        this.setMessageTextOnClickListener(view -> this.onTextClick());
        this.setMessageTextOnLongClickListener(view -> {
            this.clearSelection();
            return this.onLinkLongClick();
        });
    }

    protected String getStatusText() {
        Context context = this.getContext();
        if (context == null) {
            return "";
        }
        return this.isReadReceiptDisabled() ? "" : context.getResources().getString(R.string.lp_accessibility_received);
    }

    protected void onTextClick() {
        ContextualActionBehavior behavior = this.mContextualActionBehavior;
        if (behavior != null && behavior.isSelectable()) {
            this.setContextualBehaviorOnClick(behavior.getOnClickListener(this.getTimestampAsInteger(), (BaseViewHolder)this, null));
        }
    }
}

