/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.view.adapter.viewholder;

import android.content.Context;
import android.content.res.Resources;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.core.content.ContextCompat;
import androidx.core.content.res.ResourcesCompat;
import androidx.core.util.Pair;
import com.liveperson.api.response.types.DeliveryStatus;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.AmsAgentViewHolder;
import com.liveperson.infra.model.Message;
import com.liveperson.infra.ui.view.resources.ResourceHelper;
import com.liveperson.infra.ui.view.utils.UIUtils;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.model.Form;
import com.liveperson.messaging.model.MessagingChatMessage;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class AmsAgentFormInvitationViewHolder
extends AmsAgentViewHolder {
    private static final String TAG = AmsAgentFormInvitationViewHolder.class.getSimpleName();
    public static final String EXTRA_MESSAGE_STATE = "EXTRA_MESSAGE_STATE";
    private static final String EMPTY_STRING = "";
    private static final String TEXT_SEPARATOR = ". ";
    private MessagingChatMessage.MessageState mMessageState;
    private ImageView mFormStatusIcon;
    private ImageView mFormIcon;
    private Button mFillFormButton;
    private RelativeLayout mFormWrapper;
    private ImageView mFormProgressbar;
    private TextView mFormTitle;
    private String mTitle;
    private String mInvitationId;
    private String mFormId;
    private HashMap<String, Pair> mStateMap;

    public AmsAgentFormInvitationViewHolder(View itemView, String brandId) {
        super(itemView);
        this.mFormStatusIcon = (ImageView)itemView.findViewById(R.id.lpui_message_form_icon);
        this.mFormIcon = (ImageView)itemView.findViewById(R.id.lpui_message_form_image);
        this.mFormWrapper = (RelativeLayout)itemView.findViewById(R.id.lpui_message_form_wrapper);
        this.mFormProgressbar = (ImageView)itemView.findViewById(R.id.lpui_message_form_progressbar);
        this.mFormTitle = (TextView)itemView.findViewById(R.id.lpui_message_text_title);
        this.mFillFormButton = (Button)itemView.findViewById(R.id.lpui_message_form_btn);
        this.mFillFormButton.setOnClickListener(v -> this.onFillFormClicked(v.getContext(), brandId));
        this.mStateMap = new HashMap();
        this.mStateMap.put(Form.FormStatus.READY.name(), new Pair((Object)this.mFillFormButton.getResources().getString(R.string.lpmessaging_ui_secure_form_to_fill_in_message), (Object)-1));
        this.mStateMap.put(Form.FormStatus.ABORTED.name(), new Pair((Object)this.mFillFormButton.getResources().getString(R.string.lpmessaging_ui_secure_form_error_message), (Object)R.drawable.lpmessaging_ui_ic_pci_form_error));
        this.mStateMap.put(Form.FormStatus.ERROR.name(), new Pair((Object)this.mFillFormButton.getResources().getString(R.string.lpmessaging_ui_secure_form_error_message), (Object)R.drawable.lpmessaging_ui_ic_pci_form_error));
        this.mStateMap.put(Form.FormStatus.VIEWED.name(), new Pair((Object)this.mFillFormButton.getResources().getString(R.string.lpmessaging_ui_secure_form_viewed_message), (Object)R.drawable.lpmessaging_ui_ic_pci_form_no_access));
        this.mStateMap.put(Form.FormStatus.EXPIRED.name(), new Pair((Object)this.mFillFormButton.getResources().getString(R.string.lpmessaging_ui_secure_form_expired_message), (Object)R.drawable.lpmessaging_ui_ic_pci_form_no_access));
        this.mStateMap.put(Form.FormStatus.SUBMITTED.name(), new Pair((Object)this.mFillFormButton.getResources().getString(R.string.lpmessaging_ui_secure_form_submitted_message), (Object)R.drawable.lpmessaging_ui_ic_pci_form_submitted));
        this.restoreFormState();
    }

    private void onFillFormClicked(Context context, String brandId) {
        Messaging controller = MessagingFactory.getInstance().getController();
        if (!controller.mConnectionController.isSocketReady(brandId) || !controller.mConnectionController.isUpdated(brandId)) {
            Toast.makeText((Context)context, (int)R.string.lp_no_network_toast_message, (int)1).show();
            return;
        }
        this.toggleFormButton(false);
        Form form = controller.amsMessages.mFormsManager.getForm(this.mInvitationId);
        if (form == null) {
            LPLog.INSTANCE.w(TAG, "form not found");
            Toast.makeText((Context)context, (int)R.string.lp_resend_failed_conversation_closed, (int)1).show();
            this.abortForm(form);
        } else if (controller.isDialogClosed(form.getDialogId())) {
            Toast.makeText((Context)context, (int)R.string.lp_resend_failed_conversation_closed, (int)1).show();
            this.abortForm(form);
        } else {
            controller.generateUploadToken(this.mFormId, brandId, this.mInvitationId);
        }
    }

    private void abortForm(Form form) {
        this.setFormState(Form.FormStatus.ABORTED);
        MessagingFactory.getInstance().getController().amsMessages.setDeliveryStatusUpdateCommand(form, DeliveryStatus.ABORTED);
    }

    private void convertState(int state) {
        Form.FormStatus formState;
        MessagingChatMessage.MessageState messageState = MessagingChatMessage.MessageState.values()[state];
        switch (messageState) {
            case VIEWED: {
                formState = Form.FormStatus.VIEWED;
                break;
            }
            case SUBMITTED: {
                formState = Form.FormStatus.SUBMITTED;
                break;
            }
            case EXPIRED: {
                formState = Form.FormStatus.EXPIRED;
                break;
            }
            case ERROR: {
                formState = Form.FormStatus.ERROR;
                break;
            }
            case PENDING: {
                formState = Form.FormStatus.READY;
                break;
            }
            default: {
                formState = Form.FormStatus.ABORTED;
            }
        }
        LPLog.INSTANCE.d(TAG, "convertState state: " + state + " formState: " + formState.name());
        this.setFormState(formState);
    }

    private void toggleFormButton(boolean isEnabled) {
        this.mFormWrapper.setVisibility(0);
        this.mFillFormButton.setVisibility(isEnabled ? 0 : 4);
        this.mFormProgressbar.setVisibility(isEnabled ? 4 : 0);
        if (!isEnabled) {
            UIUtils.startProgressBarAnimation((ImageView)this.mFormProgressbar, (int)R.drawable.lpmessaging_ui_secure_form_progress_bar);
        }
    }

    @Override
    public void applyColors() {
        ResourceHelper.updateBackgroundStrokeColor((View)this.mMessageTextView, (int)R.color.agent_bubble_pci_form_invitation_stroke_color, (int)R.dimen.agent_bubble_stroke_width);
        ResourceHelper.updateBackgroundSolidColor((View)this.mMessageTextView, (int)R.color.agent_bubble_pci_form_invitation_background_color);
        ResourceHelper.updateBackgroundSolidColor((View)this.mFormIcon, (int)R.color.agent_bubble_pci_form_invitation_icon_tint_color);
        ResourceHelper.updateTextColor((TextView)this.mFormTitle, (int)R.color.agent_bubble_pci_form_invitation_title_text_color);
        ResourceHelper.updateTextColorLink((TextView)this.mMessageTextView, (int)R.color.agent_bubble_pci_form_invitation_description_text_color);
        ResourceHelper.updateTextColor((TextView)this.mTimestampTextView, (int)R.color.agent_bubble_timestamp_text_color);
        ResourceHelper.updateTextColor((TextView)this.mFillFormButton, (int)R.color.agent_bubble_pci_form_invitation_button_text_color);
        ResourceHelper.updateBackgroundSolidColor((View)this.mFillFormButton, (int)R.color.agent_bubble_pci_form_invitation_background_btn_color);
    }

    @Override
    public void updateContentDescription() {
        StringBuilder contentDescriptionBuilder = new StringBuilder();
        String agentWord = this.itemView.getContext().getString(R.string.lp_accessibility_agent);
        String receivedWord = this.getStatusText();
        contentDescriptionBuilder.append(agentWord).append(TEXT_SEPARATOR).append(!TextUtils.isEmpty((CharSequence)this.mAgentNickName) ? this.mAgentNickName : EMPTY_STRING).append(TEXT_SEPARATOR).append(this.mTitle).append(TEXT_SEPARATOR).append(this.mMessageTextView.getText()).append(TEXT_SEPARATOR);
        if (this.mMessageState == MessagingChatMessage.MessageState.READ || this.mMessageState == MessagingChatMessage.MessageState.RECEIVED) {
            String fillInFormButton = this.itemView.getContext().getString(R.string.lpmessaging_ui_fill_in_form_text_button);
            String buttonAccessibilityText = this.itemView.getContext().getString(R.string.lp_accessibility_sc_button);
            contentDescriptionBuilder.append(fillInFormButton).append(TEXT_SEPARATOR).append(buttonAccessibilityText).append(TEXT_SEPARATOR);
        }
        contentDescriptionBuilder.append(receivedWord).append(TEXT_SEPARATOR).append(this.mTimestampAccessibilityString);
        this.setContentDescription(contentDescriptionBuilder.toString());
    }

    private void parseDataFromJson(String text) throws JSONException {
        JSONObject jsonObject = new JSONObject(text);
        this.mFormId = jsonObject.optString("formId");
        this.mInvitationId = jsonObject.getString("invitationId");
        this.mTitle = jsonObject.getString("title");
        this.restoreFormState();
    }

    private void restoreFormState() {
        Form form = MessagingFactory.getInstance().getController().amsMessages.mFormsManager.getForm(this.mInvitationId);
        if (form != null) {
            Form.FormStatus status = form.getFormStatus();
            this.setFormState(status);
        }
        this.mFormTitle.setText((CharSequence)this.mTitle);
        this.setAccessibilityFocus((View)this.mFormTitle);
        this.mFormTitle.setOnClickListener(null);
    }

    private void setAccessibilityFocus(View view) {
        view.setAccessibilityDelegate(new View.AccessibilityDelegate(){

            public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfo info) {
                super.onInitializeAccessibilityNodeInfo(host, info);
                info.setAccessibilityFocused(false);
            }
        });
    }

    @Override
    public void setMessageText(String text, boolean enabled) {
        try {
            this.parseDataFromJson(text);
        }
        catch (JSONException e) {
            LPLog.INSTANCE.w(TAG, "cannot parse form data", (Throwable)e);
        }
    }

    public String getTextToCopy() {
        return this.mTitle;
    }

    private void setFormState(Form.FormStatus formState) {
        if (formState == null) {
            return;
        }
        String currentState = formState.name();
        if (!this.mStateMap.containsKey(currentState)) {
            LPLog.INSTANCE.w(TAG, "No such state!");
            this.mFormWrapper.setVisibility(8);
        } else if (formState.equals((Object)Form.FormStatus.READY)) {
            this.setInitialState();
        } else {
            this.setFormUIState(currentState);
        }
    }

    public void setMessageState(MessagingChatMessage.MessageState mMessageState) {
        this.mMessageState = mMessageState;
    }

    @Override
    public void applyChanges(Bundle changes, Message message) {
        super.applyChanges(changes, message);
        if (changes == null || changes.getSerializable(EXTRA_MESSAGE_STATE) == null) {
            return;
        }
        int state = (Integer)changes.getSerializable(EXTRA_MESSAGE_STATE);
        if (state == MessagingChatMessage.MessageState.READ.ordinal()) {
            return;
        }
        this.convertState(state);
        this.mMessageState = MessagingChatMessage.MessageState.values()[state];
        this.updateContentDescription();
    }

    public void setViewAppearanceByState(MessagingChatMessage.MessageState state) {
        if (state == MessagingChatMessage.MessageState.READ || state == MessagingChatMessage.MessageState.RECEIVED) {
            this.setInitialState();
            return;
        }
        this.convertState(state.ordinal());
    }

    private void setInitialState() {
        this.mMessageTextView.setText((CharSequence)((String)this.mStateMap.get((Object)Form.FormStatus.READY.name()).first));
        this.setAccessibilityFocus((View)this.mMessageTextView);
        this.mFormIcon.setImageDrawable(this.mFormStatusIcon.getResources().getDrawable(R.drawable.lpmessaging_ui_ic_pci_form_form));
        this.mFormIcon.setColorFilter(ContextCompat.getColor((Context)this.itemView.getContext(), (int)R.color.agent_bubble_pci_form_invitation_icon_tint_color));
        this.mFormStatusIcon.setVisibility(8);
        this.toggleFormButton(true);
    }

    private void setFormUIState(String currentState) {
        this.mMessageTextView.setText((CharSequence)((String)this.mStateMap.get((Object)currentState).first));
        this.mFormIcon.setImageDrawable(ResourcesCompat.getDrawable((Resources)this.mFormStatusIcon.getResources(), (int)R.drawable.lpmessaging_ui_ic_pci_form_form_without_status, (Resources.Theme)this.mFormStatusIcon.getContext().getTheme()));
        this.mFormIcon.setColorFilter(ContextCompat.getColor((Context)this.itemView.getContext(), (int)R.color.agent_bubble_pci_form_invitation_icon_tint_color));
        this.mFormStatusIcon.setImageDrawable(ResourcesCompat.getDrawable((Resources)this.mFormStatusIcon.getResources(), (int)((Integer)this.mStateMap.get((Object)currentState).second), (Resources.Theme)this.mFormStatusIcon.getContext().getTheme()));
        this.mFormStatusIcon.setVisibility(0);
        this.mFormWrapper.setVisibility(8);
    }
}

