/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.utils;

import android.content.Context;
import android.text.TextUtils;
import android.widget.ImageView;
import android.widget.Toast;
import com.liveperson.api.response.model.DeliveryStatusUpdateInfo;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.fragment.ConversationViewCallback;
import com.liveperson.infra.messaging_ui.utils.LPAppointmentSchedulerHandler$WhenMappings;
import com.liveperson.infra.messaging_ui.utils.StringUtils;
import com.liveperson.infra.ui.view.utils.picasso.CircleTransform;
import com.liveperson.infra.utils.LocaleUtils;
import com.liveperson.infra.utils.PicassoUtils;
import com.liveperson.lpappointmentscheduler.AppointmentSchedulerOperations;
import com.liveperson.lpappointmentscheduler.LPAppointmentScheduler;
import com.liveperson.lpappointmentscheduler.logger.AppointmentSchedulerLog;
import com.liveperson.lpappointmentscheduler.logger.LogLevel;
import com.liveperson.lpappointmentscheduler.models.AppointmentSlot;
import com.liveperson.lpappointmentscheduler.models.LPAppointmentInfo;
import com.liveperson.messaging.MessagingFactory;
import com.squareup.picasso.Callback;
import com.squareup.picasso.Transformation;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\rH\u0016J\u001a\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010\u0018\u001a\u00020\rH\u0002J\u0006\u0010\u0019\u001a\u00020\rR\u000e\u0010\t\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/liveperson/infra/messaging_ui/utils/LPAppointmentSchedulerHandler;", "Lcom/liveperson/lpappointmentscheduler/AppointmentSchedulerOperations;", "context", "Landroid/content/Context;", "brandId", "", "conversationViewCallback", "Lcom/liveperson/infra/messaging_ui/fragment/ConversationViewCallback;", "(Landroid/content/Context;Ljava/lang/String;Lcom/liveperson/infra/messaging_ui/fragment/ConversationViewCallback;)V", "TAG", "appointmentSchedulerLog", "Lcom/liveperson/lpappointmentscheduler/logger/AppointmentSchedulerLog;", "initializeAppointmentScheduler", "", "data", "Lorg/json/JSONObject;", "onAppointmentConfirmed", "appointment", "Lcom/liveperson/lpappointmentscheduler/models/AppointmentSlot;", "onAppointmentSchedulerClosed", "startImageLoading", "imageView", "Landroid/widget/ImageView;", "imageUrl", "subscribeToAppointmentLogs", "unSubscribeToAppointmentLogs", "messaging_ui_release"})
public final class LPAppointmentSchedulerHandler
implements AppointmentSchedulerOperations {
    private final String TAG = "LPAppointmentSchedulerHandler";
    private final AppointmentSchedulerLog appointmentSchedulerLog;
    private final Context context;
    private final String brandId;
    private ConversationViewCallback conversationViewCallback;

    private final void subscribeToAppointmentLogs() {
        LPAppointmentScheduler.Companion.subscribeToLogs(this.appointmentSchedulerLog);
    }

    public final void unSubscribeToAppointmentLogs() {
        LPLog.INSTANCE.i(this.TAG, "unSubscribeToAppointmentLogs");
        LPAppointmentScheduler.Companion.unSubscribeToLogs(this.appointmentSchedulerLog);
    }

    public final void initializeAppointmentScheduler(@NotNull JSONObject data) {
        block9: {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            try {
                Object object;
                LPAppointmentInfo info = LPAppointmentScheduler.Companion.initialize(this.context, data, (AppointmentSchedulerOperations)this);
                if (info != null) {
                    Map map = info.getAppointmentSlots();
                    boolean bl = false;
                    if (!map.isEmpty()) {
                        if (this.conversationViewCallback != null) {
                            ConversationViewCallback conversationViewCallback = this.conversationViewCallback;
                            if (conversationViewCallback != null) {
                                conversationViewCallback.onAppointmentSchedulerRequested(info);
                            }
                        } else {
                            LPLog.INSTANCE.e(this.TAG, ErrorCode.ERR_00000155, "Failed to load AppointmentScheduler. conversationViewCallback is null");
                        }
                        break block9;
                    }
                }
                if ((object = info) != null && (object = object.getAppointmentSlots()) != null) {
                    if (object.isEmpty()) {
                        Toast.makeText((Context)this.context, (int)R.string.lpmessaging_appointment_no_slots_error_message, (int)0).show();
                        LPLog.INSTANCE.e(this.TAG, ErrorCode.ERR_00000155, "Failed to load AppointmentScheduler. No appointments available");
                        break block9;
                    }
                }
                Toast.makeText((Context)this.context, (int)R.string.lpmessaging_general_error_message, (int)0).show();
                LPLog.INSTANCE.e(this.TAG, ErrorCode.ERR_00000155, "Failed to load AppointmentScheduler. LPAppointmentInfo is null");
            }
            catch (Exception error) {
                Toast.makeText((Context)this.context, (int)R.string.lpmessaging_general_error_message, (int)0).show();
                LPLog.INSTANCE.e(this.TAG, ErrorCode.ERR_00000155, "Failed to initialize AppointmentScheduler. " + error);
            }
        }
    }

    public void onAppointmentConfirmed(@NotNull AppointmentSlot appointment) {
        Intrinsics.checkParameterIsNotNull((Object)appointment, (String)"appointment");
        LPLog.INSTANCE.i(this.TAG, "User confirmed appointment: " + appointment);
        JSONObject metadata = new JSONObject();
        try {
            metadata.put("type", (Object)"scheduleSlot");
            metadata.put("id", (Object)appointment.getId());
            metadata.put("start", appointment.getStartTime() / (long)1000);
            if (appointment.getEndTime() > 0L) {
                metadata.put("end", appointment.getEndTime() / (long)1000);
            }
            CharSequence charSequence = appointment.getTitle();
            boolean bl = false;
            boolean bl2 = false;
            if (!(charSequence == null || charSequence.length() == 0)) {
                metadata.put("title", (Object)appointment.getTitle());
            }
            charSequence = appointment.getDescription();
            bl = false;
            bl2 = false;
            if (!(charSequence == null || charSequence.length() == 0)) {
                metadata.put("description", (Object)appointment.getDescription());
            }
            charSequence = appointment.getImageURL();
            bl = false;
            bl2 = false;
            if (!(charSequence == null || charSequence.length() == 0)) {
                metadata.put("imageUrl", (Object)appointment.getImageURL());
            }
        }
        catch (JSONException e) {
            LPLog.INSTANCE.e(this.TAG, ErrorCode.ERR_00000156, "Failed to generate appointment response metadata. " + (Object)((Object)e));
        }
        StringBuilder message = new StringBuilder();
        message.append(appointment.getTitle());
        if (!TextUtils.isEmpty((CharSequence)appointment.getTitle())) {
            message.append("\n");
        }
        message.append(appointment.getDescription());
        if (!TextUtils.isEmpty((CharSequence)appointment.getDescription())) {
            message.append("\n");
        }
        long l = appointment.getStartTime();
        long l2 = appointment.getEndTime();
        String string2 = this.context.getString(R.string.lp_appointment_date_format);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.getString(R.stri\u2026_appointment_date_format)");
        String string3 = this.context.getString(R.string.lp_appointment_time_format);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"context.getString(R.stri\u2026_appointment_time_format)");
        LocaleUtils localeUtils = LocaleUtils.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)localeUtils, (String)"LocaleUtils.getInstance()");
        Locale locale = localeUtils.getLocale();
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"LocaleUtils.getInstance().locale");
        String dateTime = StringUtils.INSTANCE.createAppointmentSelectionMessage(l, l2, string2, string3, locale);
        message.append(dateTime);
        MessagingFactory messagingFactory = MessagingFactory.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)messagingFactory, (String)"MessagingFactory.getInstance()");
        messagingFactory.getController().sendMessage(this.brandId, this.brandId, message.toString(), new DeliveryStatusUpdateInfo(new JSONArray().put((Object)metadata)));
    }

    public void onAppointmentSchedulerClosed() {
        block0: {
            ConversationViewCallback conversationViewCallback = this.conversationViewCallback;
            if (conversationViewCallback == null) break block0;
            conversationViewCallback.onAppointmentSchedulerClosed();
        }
    }

    public void startImageLoading(@NotNull ImageView imageView, @Nullable String imageUrl) {
        Intrinsics.checkParameterIsNotNull((Object)imageView, (String)"imageView");
        CharSequence charSequence = imageUrl;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            PicassoUtils.get((Context)this.context).load(R.drawable.lp_default_appointment_avatar).transform((Transformation)new CircleTransform()).error(R.drawable.lp_default_appointment_avatar).into(imageView);
        } else {
            PicassoUtils.get((Context)this.context).load(imageUrl).transform((Transformation)new CircleTransform()).error(R.drawable.lp_default_appointment_avatar).into(imageView, new Callback(){

                public void onSuccess() {
                }

                public void onError(@NotNull Exception e) {
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                }
            });
        }
    }

    public LPAppointmentSchedulerHandler(@NotNull Context context, @NotNull String brandId, @Nullable ConversationViewCallback conversationViewCallback) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)brandId, (String)"brandId");
        this.context = context;
        this.brandId = brandId;
        this.conversationViewCallback = conversationViewCallback;
        this.TAG = "LPAppointmentSchedulerHandler";
        this.appointmentSchedulerLog = new AppointmentSchedulerLog(){

            public void log(@NotNull LogLevel level, @NotNull String message) {
                Intrinsics.checkParameterIsNotNull((Object)level, (String)"level");
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                switch (LPAppointmentSchedulerHandler$WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                    case 1: {
                        LPLog.INSTANCE.v(TAG, message);
                        break;
                    }
                    case 2: {
                        LPLog.INSTANCE.i(TAG, message);
                        break;
                    }
                    case 3: {
                        LPLog.INSTANCE.w(TAG, message);
                        break;
                    }
                    case 4: {
                        LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000155, message);
                        break;
                    }
                    case 5: {
                        LPLog.INSTANCE.d(TAG, message);
                        break;
                    }
                    default: {
                        LPLog.INSTANCE.d(TAG, message);
                    }
                }
            }
        };
        this.subscribeToAppointmentLogs();
    }

    public /* synthetic */ LPAppointmentSchedulerHandler(Context context, String string2, ConversationViewCallback conversationViewCallback, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            conversationViewCallback = null;
        }
        this(context, string2, conversationViewCallback);
    }
}

