/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.uicomponents.list;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Vibrator;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.RecyclerViewAccessibilityDelegate;
import com.liveperson.api.response.model.DeliveryStatusUpdateInfo;
import com.liveperson.api.response.types.DeliveryStatus;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.analytics.LPAnalytics;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.database.tables.FilesTable;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.fragment.ConversationViewCallback;
import com.liveperson.infra.messaging_ui.uicomponents.IScrollDownIndicator;
import com.liveperson.infra.messaging_ui.uicomponents.list.ChatMessageBgFgListener;
import com.liveperson.infra.messaging_ui.uicomponents.list.ChatMessageListRecyclerView;
import com.liveperson.infra.messaging_ui.uicomponents.list.MessagesAsListLoader;
import com.liveperson.infra.messaging_ui.utils.AccessbilityUtilsKt;
import com.liveperson.infra.messaging_ui.utils.LPAppointmentSchedulerHandler;
import com.liveperson.infra.messaging_ui.utils.markdownlink.HyperLinkUtils;
import com.liveperson.infra.messaging_ui.utils.markdownlink.MarkdownHyperlinkItem;
import com.liveperson.infra.messaging_ui.view.adapter.copybehavior.ContextualActionBehavior;
import com.liveperson.infra.messaging_ui.view.adapter.copybehavior.IMenuCallback;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.AmsAgentFileViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.AmsAgentFormInvitationViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.AmsAgentMarkdownHyperlinkViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.AmsAgentStructuredContentViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.AmsAgentTypingViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.AmsAgentURLViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.AmsAgentViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.AmsBrandMsgViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.AmsCoBrowseViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.AmsConsumerFileViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.AmsConsumerFormSubmissionViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.AmsConsumerURLViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.AmsConsumerViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.AmsConsumerVoiceViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.AmsControllerSystemViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.AmsLoadMoreViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.AmsSystemDialogResolvedViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.AmsSystemMaskedViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.AmsSystemResolvedViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.DateHeaderViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.UiUnreadIndicatorViewHolder;
import com.liveperson.infra.model.Message;
import com.liveperson.infra.preferences.PushMessagePreferences;
import com.liveperson.infra.ui.view.adapter.viewholder.BaseViewHolder;
import com.liveperson.infra.ui.view.sticky.StickyHeaderHolder;
import com.liveperson.infra.ui.view.sticky.StickyHeadersLinearLayoutManager;
import com.liveperson.infra.utils.LPAudioUtils;
import com.liveperson.infra.utils.LocaleUtils;
import com.liveperson.lp_structured_content.R;
import com.liveperson.lp_structured_content.data.model.elements.complex.QuickRepliesElement;
import com.liveperson.lp_structured_content.ui.OnSCActionClickListener;
import com.liveperson.lp_structured_content.ui.QRActionClickListener;
import com.liveperson.lp_structured_content.utils.SCUtils;
import com.liveperson.lpdatepicker.CalendarInitInfo;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.background.CoBrowseManager;
import com.liveperson.messaging.background.filesharing.FileSharingType;
import com.liveperson.messaging.model.CoBrowseMetadata;
import com.liveperson.messaging.model.Conversation;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.model.FileMessage;
import com.liveperson.messaging.model.FullMessageRow;
import com.liveperson.messaging.model.MessagingChatMessage;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MessagesAsListAdapter
extends RecyclerView.Adapter<BaseViewHolder>
implements MessagesAsListLoader.OnListUpdated,
StickyHeaderHolder,
StickyHeaderHolder.ViewDecorator,
ChatMessageBgFgListener,
BaseViewHolder.OnRequestTimestampUpdateListener {
    private static final String PAYLOAD_UPDATE_TIMESTAMP = "payload.update_timestamp";
    private static final String TAG = "MessagesAsListAdapter";
    private static final String TYPE_SCROLL_TO_BOTTOM = "bottom";
    private static final String TYPE_SCROLL_TO_LAST_POSITION = "lastposition";
    private static final String TYPE_SCROLL_TO_FIRST_UNREAD = "firstunreadmessage";
    private static final String KEY_LAST_SCROLLED_FIRST_VISIBLE_ITEM_POSITION = "last_scrolled_first_visible_item_position";
    private static final String KEY_SCROLLING_OFFSET = "scrolling_items_offser";
    private static final int VIBRATION_DURATION_IN_MILLISECONDS = 400;
    private static final long SCROLL_EXPIRATION_DELAY = 10000L;
    private static final int SMOOTH_SCROLL_RANGE = 20;
    private static final int DB_MESSAGE_LOAD_LIMIT = 100;
    private final ChatMessageListRecyclerView mRecyclerView;
    private final IScrollDownIndicator mScrollDownIndicator;
    private MessagesAsListLoader messagesAsListLoader;
    private ContextualActionBehavior mMessagingContextualActionController;
    private ConversationViewCallback conversationViewCallback;
    private LPAppointmentSchedulerHandler lpAppointmentSchedulerHandler;
    private boolean mHideResolveMessage;
    private boolean mHideResolveSeparator;
    private boolean firstTimeBringToForeground;
    private boolean fromPushNotification;
    private boolean pendingScrollToFirstUnreadMessage;
    private boolean pendingScrollToBottom;
    private boolean keepLastPositionOnNewMessage;
    private boolean isFirstScrollPerformed;
    private String mBrandId;
    private boolean permissionGranted = false;
    private boolean shouldScrollToFirstByPush = false;
    private boolean shouldScrollToFirstByInApp = false;
    private int lastScrolledPosition = 0;
    private int lastUIItemPosition = 0;
    private int mFirstUIItemPosition = 0;
    private int focusedViewPosition = -1;
    private boolean isLastItemFocused = false;
    private AccessibilityEvent lastEvent;
    private final Handler mUpdatesHandler = new Handler(Looper.getMainLooper());
    private boolean mIsForeground = false;

    MessagesAsListAdapter(ChatMessageListRecyclerView chatMessageListRecyclerView, IScrollDownIndicator scrollDownIndicator, String brandId, ConversationViewCallback conversationViewCallback) {
        this.mBrandId = brandId;
        this.firstTimeBringToForeground = true;
        this.mRecyclerView = chatMessageListRecyclerView;
        this.mScrollDownIndicator = scrollDownIndicator;
        this.conversationViewCallback = conversationViewCallback;
    }

    public void init() {
        this.messagesAsListLoader = new MessagesAsListLoader(this.mRecyclerView, this, this.mBrandId, this.conversationViewCallback);
        this.lpAppointmentSchedulerHandler = new LPAppointmentSchedulerHandler(this.mRecyclerView.getContext().getApplicationContext(), this.mBrandId, this.conversationViewCallback);
        this.mScrollDownIndicator.setOnClickListener(view -> this.scrollOnScrollDownIndicatorClicked());
        this.mHideResolveMessage = !Configuration.getBoolean((int)R.bool.enable_conversation_resolved_message);
        this.mHideResolveSeparator = !Configuration.getBoolean((int)R.bool.enable_conversation_resolved_separator);
        this.initScrollListener();
        boolean isVibrateEnabled = Configuration.getBoolean((int)R.bool.vibrate_enabled);
        if (this.mRecyclerView.getContext().checkCallingOrSelfPermission("android.permission.VIBRATE") == 0 && isVibrateEnabled) {
            this.permissionGranted = true;
        }
        this.fromPushNotification = PushMessagePreferences.INSTANCE.isPushNotificationClicked();
        this.setUpAccessibilityDelegates();
    }

    private void onScrolled() {
        RecyclerView.LayoutManager manager = this.mRecyclerView.getLayoutManager();
        if (!(manager instanceof StickyHeadersLinearLayoutManager)) {
            return;
        }
        StickyHeadersLinearLayoutManager layoutManager = (StickyHeadersLinearLayoutManager)manager;
        int firstPos = layoutManager.findFirstVisibleItemPosition();
        int lastPos = layoutManager.findLastVisibleItemPosition();
        if (this.mFirstUIItemPosition == firstPos && this.lastUIItemPosition == lastPos) {
            return;
        }
        this.mFirstUIItemPosition = firstPos;
        this.lastUIItemPosition = lastPos;
        if ((this.lastUIItemPosition <= this.lastScrolledPosition || this.lastScrolledPosition == 0) && this.lastUIItemPosition >= 0) {
            this.lastScrolledPosition = this.lastUIItemPosition;
        }
        LPLog.INSTANCE.d(TAG, "onScrolled: FirstVisibleItemPosition " + this.mFirstUIItemPosition + " lastUIItemPosition = " + this.lastUIItemPosition + " lastScrolledPosition: " + this.lastScrolledPosition);
        this.messagesAsListLoader.onScroll(this.mFirstUIItemPosition);
        int visibleItemCount = layoutManager.getChildCount();
        int totalItemCount = layoutManager.getItemCount();
        int pastVisibleItems = layoutManager.findFirstVisibleItemPosition();
        LPLog.INSTANCE.d(TAG, "onScrolled: if(pastVisibleItems + visibleItemCount >= totalItemCount) -> (" + pastVisibleItems + "+" + visibleItemCount + ">=" + totalItemCount + ")");
        if (pastVisibleItems + visibleItemCount >= totalItemCount) {
            LPLog.INSTANCE.d(TAG, "onScrolled: resetAndHide -> pastVisibleItems + visibleItemCount >= totalItemCount (" + pastVisibleItems + "+" + visibleItemCount + ">=" + totalItemCount + ")");
            this.mScrollDownIndicator.resetAndHide();
            this.messagesAsListLoader.setNewMessageRead(true);
            this.messagesAsListLoader.setScrollDownIndicatorVisible(false);
        } else {
            int unreadPosition = this.messagesAsListLoader.getUnreadPosition();
            LPLog.INSTANCE.d(TAG, "onScrolled: lastUIItemPosition = " + this.lastUIItemPosition + " unreadPosition = " + unreadPosition);
            if (this.lastUIItemPosition >= unreadPosition && this.lastUIItemPosition != -1 || this.lastUIItemPosition < this.messagesAsListLoader.size() - 1 && !this.messagesAsListLoader.isScrollDownIndicatorVisible()) {
                LPLog.INSTANCE.d(TAG, "onScrolled: resetAndShowCollapsed -> (lastUIItemPosition >= unreadPosition) && (lastUIItemPosition != -1) (" + this.lastUIItemPosition + ">=" + unreadPosition + " && " + this.lastUIItemPosition + " != -1)");
                this.mScrollDownIndicator.resetAndShowCollapsed();
                this.messagesAsListLoader.setScrollDownIndicatorVisible(true);
            }
        }
    }

    private void initScrollListener() {
        this.mRecyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                MessagesAsListAdapter.this.onScrolled();
            }
        });
    }

    private void setUpAccessibilityDelegates() {
        this.mRecyclerView.getRootView().setAccessibilityDelegate(new View.AccessibilityDelegate(){

            public boolean onRequestSendAccessibilityEvent(ViewGroup host, View child, AccessibilityEvent event) {
                if (MessagesAsListAdapter.this.lastEvent != event && event.getEventType() == 128) {
                    MessagesAsListAdapter.this.focusedViewPosition = -1;
                    MessagesAsListAdapter.this.isLastItemFocused = false;
                }
                return super.onRequestSendAccessibilityEvent(host, child, event);
            }
        });
        this.mRecyclerView.setAccessibilityDelegateCompat(new RecyclerViewAccessibilityDelegate(this.mRecyclerView){

            public boolean onRequestSendAccessibilityEvent(ViewGroup host, View child, AccessibilityEvent event) {
                LPLog.INSTANCE.d(MessagesAsListAdapter.TAG, "mRecyclerView. onRequestSendAccessibilityEvent. event = " + event);
                if (event.getEventType() == 128) {
                    MessagesAsListAdapter.this.lastEvent = event;
                    Object tag = child.getTag(R.id.lp_messages_as_list_view_holder_position_key);
                    if (tag instanceof Integer) {
                        MessagesAsListAdapter.this.focusedViewPosition = (Integer)tag;
                        MessagesAsListAdapter.this.isLastItemFocused = MessagesAsListAdapter.this.focusedViewPosition >= MessagesAsListAdapter.this.messagesAsListLoader.size() - 1;
                    }
                }
                return super.onRequestSendAccessibilityEvent(host, child, event);
            }
        });
    }

    @Override
    public int getLoadLimit() {
        if (this.firstTimeBringToForeground) {
            String pushNavigation = Configuration.getString((int)R.string.lp_scroll_when_push_notification).toLowerCase();
            String inAppNavigation = Configuration.getString((int)R.string.lp_scroll_show_conversation).toLowerCase();
            int offset = PreferenceManager.getInstance().getIntValue(KEY_SCROLLING_OFFSET, this.mBrandId, -1);
            if (this.fromPushNotification) {
                if (TYPE_SCROLL_TO_LAST_POSITION.equals(pushNavigation)) {
                    if (offset < 100) {
                        this.shouldScrollToFirstByPush = true;
                        return Math.max(offset, 25);
                    }
                    return 25;
                }
                return 25;
            }
            if (TYPE_SCROLL_TO_LAST_POSITION.equals(inAppNavigation)) {
                if (offset < 100) {
                    this.shouldScrollToFirstByInApp = true;
                    return Math.max(offset, 25);
                }
                return 25;
            }
            return 25;
        }
        return 25;
    }

    @Override
    public int getFirstVisibleItemPosition() {
        if (this.mRecyclerView.getLayoutManager() == null) {
            return -1;
        }
        return ((StickyHeadersLinearLayoutManager)this.mRecyclerView.getLayoutManager()).findFirstVisibleItemPosition();
    }

    @Override
    public int getLastVisibleItemPosition() {
        if (this.mRecyclerView.getLayoutManager() == null) {
            return -1;
        }
        return ((StickyHeadersLinearLayoutManager)this.mRecyclerView.getLayoutManager()).findLastVisibleItemPosition();
    }

    @Override
    public void notifyUnreadMessagesChanged(int numOfUnreadAgentMessages, String lastMessage, int indexNumOfUnreadAgentMessage) {
        int lastVisibleItemPosition = this.getLastVisibleItemPosition();
        if (lastVisibleItemPosition < indexNumOfUnreadAgentMessage && !this.pendingScrollToBottom) {
            LPLog.INSTANCE.d(TAG, "notifyUnreadMessagesChanged: getLastVisibleItemPosition(" + lastVisibleItemPosition + ") < indexNumOfUnreadAgentMessage(" + indexNumOfUnreadAgentMessage + "). ShowScrollDownIndicator.");
            this.mScrollDownIndicator.show(numOfUnreadAgentMessages, lastMessage);
            if (Configuration.getBoolean((int)R.bool.scroll_down_indicator_unread_summary_enabled)) {
                this.messagesAsListLoader.setScrollDownIndicatorVisible(true);
            }
        } else {
            LPLog.INSTANCE.d(TAG, "notifyUnreadMessagesChanged: don't show scrollDownIndicator. getLastVisibleItemPosition(" + lastVisibleItemPosition + ") > indexNumOfUnreadAgentMessage(" + indexNumOfUnreadAgentMessage + ")");
        }
    }

    @Override
    public void onItemMoved(int fromPos, int toPos) {
        this.notifyItemMoved(fromPos, toPos);
    }

    @Override
    public void onNewAgentMessageReceived(int position, FullMessageRow fullMessageRow) {
        int updatedLastUIItemPosition = this.getLastVisibleItemPosition();
        this.notifyItemInserted(position);
        this.mRecyclerView.invalidateItemDecorations();
        LPLog.INSTANCE.d(TAG, "new Agent Message at position: " + position + " lastUIItemPosition = " + updatedLastUIItemPosition + " getItemCount() = " + this.getItemCount());
        if (updatedLastUIItemPosition + 1 == position) {
            LPLog.INSTANCE.d(TAG, "onNewAgentMessageReceived: scrollToPosition: " + position);
            if (this.pendingScrollToFirstUnreadMessage) {
                this.scrollToUnreadPosition();
                this.pendingScrollToFirstUnreadMessage = false;
            } else if (!this.fromPushNotification) {
                this.mRecyclerView.scrollToPosition(position);
            }
            this.setPushNotificationClickedFalse();
        }
        this.announceAccessibilityMessage(this.mRecyclerView.getResources().getString(R.string.lp_accessibility_new_agent_message), fullMessageRow);
        if (this.permissionGranted) {
            Vibrator v = (Vibrator)this.mRecyclerView.getContext().getSystemService("vibrator");
            v.vibrate(400L);
        }
    }

    @Override
    public void onQuickRepliesMessageReceived() {
        MessagingChatMessage messagingChatMessage = this.messagesAsListLoader.getLastMessage().getMessagingChatMessage();
        String message = messagingChatMessage.getMessage();
        try {
            JSONObject jsonObject = new JSONObject(message);
            QuickRepliesElement quickRepliesElement = new QuickRepliesElement(jsonObject);
            List elements = quickRepliesElement.getElementList();
            if (elements.isEmpty()) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000043, "Failed to parse JSON, List is empty");
            } else {
                String qrContentDescription = SCUtils.composeQrContentDescription((Context)this.mRecyclerView.getContext(), (QuickRepliesElement)quickRepliesElement);
                this.mRecyclerView.announceForAccessibility(qrContentDescription);
            }
        }
        catch (JSONException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000043, "Failed to parse JSON", (Throwable)e);
        }
    }

    @Override
    public void onNewUnreadMessages(int indexNumOfUnreadAgentMessage, int numOfUnreadMessages) {
        LPLog.INSTANCE.d(TAG, "onNewUnreadMessages, indexNumOfUnreadAgentMessage = " + indexNumOfUnreadAgentMessage + ", numOfUnreadMessages = " + numOfUnreadMessages + ", lastVisibleItem = " + this.getLastVisibleItemPosition());
        if (this.pendingScrollToBottom) {
            this.scrollToBottom();
            this.pendingScrollToBottom = false;
        } else if (this.pendingScrollToFirstUnreadMessage) {
            this.scrollToUnreadPosition();
            this.pendingScrollToFirstUnreadMessage = false;
        } else if (!this.fromPushNotification && (!this.messagesAsListLoader.hasVisibleItems() || numOfUnreadMessages == 1 && this.messagesAsListLoader.isItemAtPositionVisible(indexNumOfUnreadAgentMessage))) {
            this.mRecyclerView.scrollToPosition(indexNumOfUnreadAgentMessage + numOfUnreadMessages);
        }
        this.setPushNotificationClickedFalse();
        this.notifyItemInserted(indexNumOfUnreadAgentMessage);
        this.mRecyclerView.invalidateItemDecorations();
    }

    @Override
    public void onNewMessagesLoaded(int position, int itemCount, int unreadMessages) {
        int updatedLastUIItemPosition = this.getLastVisibleItemPosition();
        LPLog.INSTANCE.d(TAG, "onNewMessagesLoaded, start: " + position + " lastUIItemPosition: " + updatedLastUIItemPosition + " count: " + itemCount + " unread messages: " + unreadMessages);
        this.notifyItemRangeInserted(position, itemCount);
        this.mRecyclerView.invalidateItemDecorations();
        LPLog.INSTANCE.d(TAG, "onNewMessagesLoaded: updatedLastUIItemPosition: " + updatedLastUIItemPosition);
        if (updatedLastUIItemPosition != -1) {
            if (Math.abs(updatedLastUIItemPosition - position) <= 2) {
                if (unreadMessages > 0) {
                    if (!this.pendingScrollToBottom && !this.keepLastPositionOnNewMessage) {
                        ((StickyHeadersLinearLayoutManager)this.mRecyclerView.getLayoutManager()).scrollToPositionWithOffset(position, 0);
                    }
                } else {
                    LPLog.INSTANCE.d(TAG, "onNewMessagesLoaded: scrollToPosition position + itemCount -1 = " + (position + itemCount - 1));
                    this.mRecyclerView.scrollToPosition(position + itemCount - 1);
                }
            }
        } else if (this.isFirstScrollPerformed) {
            this.mRecyclerView.scrollToPosition(this.messagesAsListLoader.size() - 1);
        }
        this.keepLastPositionOnNewMessage = false;
        for (int i = position; i < position + itemCount; ++i) {
            if (this.messagesAsListLoader.getItem(position) == null || this.messagesAsListLoader.getItem(position).getMessagingChatMessage() == null || this.messagesAsListLoader.getItem(position).getMessagingChatMessage().getMessageType() != MessagingChatMessage.MessageType.CONTROLLER_SYSTEM) continue;
            this.announceAccessibilityMessage(this.mRecyclerView.getResources().getString(R.string.lp_accessibility_new_system_message), this.messagesAsListLoader.getItem(position));
        }
    }

    @Override
    public void onHistoryLoaded(int position, int numItems, boolean firstLoad) {
        LPLog.INSTANCE.d(TAG, "onHistoryLoaded, position: " + position + " numItems: " + numItems + " firstLoad  = " + firstLoad);
        this.notifyItemRangeInserted(position, numItems);
        this.mRecyclerView.invalidateItemDecorations();
        if (firstLoad) {
            this.conversationViewCallback.restoreRecyclerViewInstanceState();
            this.performScroll();
        }
    }

    @Override
    public void onNewUserMessageAdded(int position) {
        int lastItem = this.messagesAsListLoader.size() - 1;
        LPLog.INSTANCE.d(TAG, "onNewUserMessageAdded, at position: " + position + " scrolling to the end position: " + lastItem);
        this.notifyItemInserted(position);
        this.mRecyclerView.invalidateItemDecorations();
        LPLog.INSTANCE.d(TAG, "onNewUserMessageAdded: scrollToPosition: " + lastItem);
        if (position > lastItem / 2) {
            this.mRecyclerView.scrollToPosition(lastItem);
        }
        this.mRecyclerView.invalidateItemDecorations();
    }

    @Override
    public void onNewSystemMessageAdded(int position, FullMessageRow fullMessageRow) {
        LPLog.INSTANCE.d(TAG, "onNewSystemMessageAdded at position " + position);
        this.notifyItemInserted(position);
        this.mRecyclerView.invalidateItemDecorations();
        MessagingChatMessage.MessageType messageType = fullMessageRow.getMessagingChatMessage().getMessageType();
        if (messageType == MessagingChatMessage.MessageType.SYSTEM_RESOLVED || messageType == MessagingChatMessage.MessageType.SYSTEM_DIALOG_RESOLVED) {
            boolean scrollToBottomAfterResolveConversation = Configuration.getBoolean((int)R.bool.lp_scroll_to_bottom_after_resolve_conversation);
            if (this.mHideResolveSeparator && this.mHideResolveMessage) {
                this.messagesAsListLoader.removeItemFromDataSet(position, "onNewSystemMessageAdded");
                this.notifyItemRemoved(position);
                this.mRecyclerView.invalidateItemDecorations();
                if (scrollToBottomAfterResolveConversation) {
                    this.scrollToBottom();
                }
            } else {
                LPLog.INSTANCE.d(TAG, "onNewSystemMessageAdded, resolve message. scrolling to position: " + position);
                int updatedLastUIItemPosition = this.getLastVisibleItemPosition();
                if (position > updatedLastUIItemPosition) {
                    LPLog.INSTANCE.d(TAG, "onNewSystemMessageAdded: scrollToPosition: " + position);
                    this.mRecyclerView.scrollToPosition(position);
                }
            }
            if (this.messagesAsListLoader.addWelcomeMessage()) {
                this.mRecyclerView.smoothScrollToPosition(this.messagesAsListLoader.size());
            }
        } else if (messageType == MessagingChatMessage.MessageType.SYSTEM_MASKED) {
            LPLog.INSTANCE.d(TAG, "onNewSystemMessageAdded, system masked message. scrolling to position: " + position);
            this.mRecyclerView.scrollToPosition(position);
        } else if (messageType == MessagingChatMessage.MessageType.CONTROLLER_SYSTEM) {
            int updatedLastUIItemPosition = this.getLastVisibleItemPosition();
            LPLog.INSTANCE.d(TAG, "new Auto Message at position: " + position + " lastUIItemPosition = " + updatedLastUIItemPosition + " getItemCount() = " + this.getItemCount());
            if (updatedLastUIItemPosition + 1 == position) {
                LPLog.INSTANCE.d(TAG, "onNewSystemMessageAdded: scrollToPosition: " + position);
                this.mRecyclerView.scrollToPosition(position);
            }
        }
        this.announceAccessibilityMessage(this.mRecyclerView.getResources().getString(R.string.lp_accessibility_new_system_message), fullMessageRow);
    }

    @Override
    public void onMessageUpdated(int position, Bundle changes) {
        LPLog.INSTANCE.d(TAG, "onMessageUpdated position: " + position + " changes = " + changes);
        if (changes == null || changes.isEmpty()) {
            this.notifyItemChanged(position);
        } else {
            this.notifyItemChanged(position, changes);
            if (this.isLastItemFocused) {
                this.moveAccessibilityFocusToLastItem();
            }
        }
        this.mRecyclerView.invalidateItemDecorations();
    }

    @Override
    public void onAnnounceDialogResolvedMessage(FullMessageRow fullMessageRow) {
        this.announceAccessibilityMessage(this.mRecyclerView.getResources().getString(R.string.lp_accessibility_new_system_message), fullMessageRow);
    }

    @Override
    public void onClearAllMessages(int posStart, int itemCount) {
        LPLog.INSTANCE.d(TAG, "onClearAllMessages itemCount: " + itemCount);
        this.notifyItemRangeRemoved(posStart, itemCount);
        this.mRecyclerView.invalidateItemDecorations();
        this.mScrollDownIndicator.resetAndHide();
    }

    @Override
    public void onItemAdded(int position) {
        LPLog.INSTANCE.d(TAG, "onItemAdded position: " + position);
        this.notifyItemInserted(position);
        this.mRecyclerView.invalidateItemDecorations();
    }

    @Override
    public void onItemRemoved(int position) {
        LPLog.INSTANCE.d(TAG, "onItemRemoved position: " + position);
        this.notifyItemRemoved(position);
        if (this.isLastItemFocused && position > 0) {
            this.moveAccessibilityFocusToLastItem();
        }
        this.mRecyclerView.invalidateItemDecorations();
    }

    private void moveAccessibilityFocusToLastItem() {
        RecyclerView.ViewHolder holder = this.mRecyclerView.findViewHolderForAdapterPosition(this.messagesAsListLoader.size() - 1);
        if (holder != null) {
            LPLog.INSTANCE.d(TAG, "moveFocusToLast. isFocused = " + holder.itemView.isAccessibilityFocused());
            holder.itemView.performAccessibilityAction(64, null);
        }
    }

    public int getItemViewType(int position) {
        return this.messagesAsListLoader.getItem(position).getMessagingChatMessage().getMessageType().ordinal();
    }

    @NonNull
    public BaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        Object holder = null;
        LayoutInflater layoutInflater = LayoutInflater.from((Context)parent.getContext());
        MessagingChatMessage.MessageType messageType = MessagingChatMessage.MessageType.values()[viewType];
        switch (messageType) {
            case LOADING: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_bubble_load_more, parent, false);
                holder = new AmsLoadMoreViewHolder(v);
                break;
            }
            case SYSTEM_DIALOG_RESOLVED: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_bubble_system_dialog_resolved, parent, false);
                holder = new AmsSystemDialogResolvedViewHolder(v);
                break;
            }
            case SYSTEM_RESOLVED: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_bubble_system_resolved, parent, false);
                holder = new AmsSystemResolvedViewHolder(v);
                break;
            }
            case SYSTEM_MASKED: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_bubble_system, parent, false);
                holder = new AmsSystemMaskedViewHolder(v);
                break;
            }
            case BRAND: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_bubble_brand, parent, false);
                holder = new AmsBrandMsgViewHolder(v, this.mMessagingContextualActionController);
                break;
            }
            case AGENT: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_bubble_agent, parent, false);
                holder = new AmsAgentViewHolder(v);
                break;
            }
            case AGENT_MARKDOWN_HYPERLINK: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_bubble_agent, parent, false);
                holder = new AmsAgentMarkdownHyperlinkViewHolder(v);
                break;
            }
            case AGENT_IS_TYPING_INDICATOR: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_bubble_agent_is_typing, parent, false);
                holder = new AmsAgentTypingViewHolder(v);
                break;
            }
            case AGENT_IMAGE: 
            case AGENT_DOCUMENT: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_image_bubble_agent, parent, false);
                holder = new AmsAgentFileViewHolder(v, messageType);
                break;
            }
            case AGENT_URL: {
                boolean isBigPic = Configuration.getBoolean((int)R.bool.link_preview_use_big_picture);
                View v = isBigPic ? layoutInflater.inflate(R.layout.lpmessaging_ui_chat_url_bubble_agent, parent, false) : layoutInflater.inflate(R.layout.lpmessaging_ui_chat_url_small_bubble_agent, parent, false);
                holder = new AmsAgentURLViewHolder(v, this.mMessagingContextualActionController);
                break;
            }
            case AGENT_FORM: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_form_invitation_bubble_agent, parent, false);
                holder = new AmsAgentFormInvitationViewHolder(v, this.mBrandId);
                break;
            }
            case CONSUMER: 
            case CONSUMER_MASKED: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_bubble_consumer, parent, false);
                holder = new AmsConsumerViewHolder(v, messageType);
                break;
            }
            case CONSUMER_IMAGE: 
            case CONSUMER_DOCUMENT: 
            case CONSUMER_IMAGE_MASKED: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_image_bubble_consumer, parent, false);
                holder = new AmsConsumerFileViewHolder(v, messageType);
                break;
            }
            case CONSUMER_URL_MASKED: 
            case CONSUMER_URL: {
                boolean isBigPic = Configuration.getBoolean((int)R.bool.link_preview_use_big_picture);
                View v = isBigPic ? layoutInflater.inflate(R.layout.lpmessaging_ui_chat_url_bubble_consumer, parent, false) : layoutInflater.inflate(R.layout.lpmessaging_ui_chat_url_small_bubble_consumer, parent, false);
                holder = new AmsConsumerURLViewHolder(v, messageType, this.mMessagingContextualActionController);
                break;
            }
            case CONSUMER_VOICE: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_voice_bubble_consumer, parent, false);
                holder = new AmsConsumerVoiceViewHolder(v, MessagingChatMessage.MessageType.CONSUMER_VOICE, this.mBrandId);
                break;
            }
            case CONSUMER_FORM: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_bubble_consumer, parent, false);
                holder = new AmsConsumerFormSubmissionViewHolder(v, messageType);
                break;
            }
            case UNREAD_INDICATOR: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_bubble_unread_indicator, parent, false);
                holder = new UiUnreadIndicatorViewHolder(v);
                break;
            }
            case AGENT_STRUCTURED_CONTENT: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_structured_content_agent, parent, false);
                holder = new AmsAgentStructuredContentViewHolder(v, this.mBrandId);
                break;
            }
            case AGENT_QUICK_REPLIES: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_structured_content_agent, parent, false);
                holder = new AmsAgentStructuredContentViewHolder(v, this.mBrandId);
                break;
            }
            case CONTROLLER_SYSTEM: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_bubble_controller_system, parent, false);
                holder = new AmsControllerSystemViewHolder(v);
                break;
            }
            case COBROWSE: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_bubble_cobrowse, parent, false);
                holder = new AmsCoBrowseViewHolder(v);
                break;
            }
            case DATE_HEADER: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_bubble_date_header, parent, false);
                holder = new DateHeaderViewHolder(v);
            }
        }
        return holder;
    }

    public void onBindViewHolder(@NonNull BaseViewHolder holder, int position, @NonNull List<Object> payloads) {
        if (!payloads.isEmpty()) {
            for (Object payload : payloads) {
                boolean isQr;
                MessagingChatMessage mMessagingChatMessage = this.messagesAsListLoader.getItem(position).getMessagingChatMessage();
                boolean bl = isQr = mMessagingChatMessage.getMessageType() == MessagingChatMessage.MessageType.AGENT_QUICK_REPLIES;
                if (PAYLOAD_UPDATE_TIMESTAMP.equals(payload) && !isQr) {
                    holder.onUpdateTimestampText();
                    holder.updateContentDescription();
                    continue;
                }
                if (!(payload instanceof Bundle)) continue;
                holder.applyChanges((Bundle)payload, (Message)mMessagingChatMessage);
            }
        } else {
            super.onBindViewHolder((RecyclerView.ViewHolder)holder, position, payloads);
        }
    }

    public boolean isStickyHeader(int position) {
        FullMessageRow row = this.messagesAsListLoader.getItem(position);
        if (row == null) {
            return false;
        }
        MessagingChatMessage message = row.getMessagingChatMessage();
        return message.getMessageType() == MessagingChatMessage.MessageType.DATE_HEADER;
    }

    public void decorateHeaderView(@Nullable View stickyHeader, int position) {
        if (stickyHeader != null) {
            ViewCompat.setElevation((View)stickyHeader, (float)10.0f);
            this.changeAccessibilityMode(stickyHeader, 2);
        }
    }

    public void removeHeaderViewDecoration(@Nullable View stickyHeader) {
        if (stickyHeader != null) {
            ViewCompat.setElevation((View)stickyHeader, (float)0.0f);
            this.changeAccessibilityMode(stickyHeader, 1);
        }
    }

    private void savePositionInTag(BaseViewHolder holder) {
        holder.itemView.setTag(R.id.lp_messages_as_list_view_holder_position_key, (Object)holder.getAbsoluteAdapterPosition());
    }

    public void onBindViewHolder(@NonNull BaseViewHolder holder, int position) {
        this.savePositionInTag(holder);
        FullMessageRow currentMessagingChatMessage = this.messagesAsListLoader.getItem(position);
        if (position == this.messagesAsListLoader.size() - 1) {
            this.messagesAsListLoader.setScrollDownIndicatorVisible(false);
            this.mScrollDownIndicator.resetAndHide();
        }
        if (currentMessagingChatMessage == null) {
            LPLog.INSTANCE.d(TAG, "onBindViewHolder position: " + position + " message is null, skipping binding");
            return;
        }
        MessagingChatMessage mMessagingChatMessage = currentMessagingChatMessage.getMessagingChatMessage();
        String message = mMessagingChatMessage.getMessage();
        MessagingChatMessage.MessageType messageType = mMessagingChatMessage.getMessageType();
        long timeStamp = -1L;
        switch (messageType) {
            case LOADING: {
                AmsLoadMoreViewHolder loadingViewHolder = (AmsLoadMoreViewHolder)holder;
                loadingViewHolder.setMessageTextView(message);
                break;
            }
            case SYSTEM_DIALOG_RESOLVED: {
                LPLog.INSTANCE.d(TAG, "onBindViewHolder position: " + position + " systemDialogResolved");
                AmsSystemDialogResolvedViewHolder dialogResolvedViewHolder = (AmsSystemDialogResolvedViewHolder)holder;
                dialogResolvedViewHolder.hideSystemMessageView(this.mHideResolveSeparator);
                dialogResolvedViewHolder.setMessageTextView(message);
                dialogResolvedViewHolder.updateContentDescription();
                break;
            }
            case SYSTEM_RESOLVED: {
                AmsSystemResolvedViewHolder systemResolvedViewHolder = (AmsSystemResolvedViewHolder)holder;
                systemResolvedViewHolder.setMessageTextView(message);
                systemResolvedViewHolder.updateContentDescription();
                systemResolvedViewHolder.hideSystemMessageView(this.mHideResolveMessage, this.mHideResolveSeparator);
                break;
            }
            case SYSTEM_MASKED: {
                AmsSystemMaskedViewHolder systemMaskedViewHolder = (AmsSystemMaskedViewHolder)holder;
                systemMaskedViewHolder.setMessageTextView(message);
                systemMaskedViewHolder.updateContentDescription();
                break;
            }
            case BRAND: {
                AmsBrandMsgViewHolder brandViewHolder = (AmsBrandMsgViewHolder)holder;
                brandViewHolder.setMessageText(message, true);
                timeStamp = mMessagingChatMessage.getTimeStamp();
                brandViewHolder.setTimestamp(mMessagingChatMessage.getTimeStamp());
                brandViewHolder.updateContentDescription();
                break;
            }
            case AGENT: {
                AmsAgentViewHolder agentViewHolder = (AmsAgentViewHolder)holder;
                timeStamp = mMessagingChatMessage.getTimeStamp();
                agentViewHolder.setAgentAvatar(currentMessagingChatMessage.getAgentAvatar());
                agentViewHolder.setAgentNickName(currentMessagingChatMessage.getAgentNickName());
                this.setAgentMessageText(mMessagingChatMessage, message, agentViewHolder);
                break;
            }
            case AGENT_MARKDOWN_HYPERLINK: {
                AmsAgentMarkdownHyperlinkViewHolder amsAgentMarkdownHyperlinkViewHolder = (AmsAgentMarkdownHyperlinkViewHolder)holder;
                timeStamp = mMessagingChatMessage.getTimeStamp();
                amsAgentMarkdownHyperlinkViewHolder.setAgentAvatar(currentMessagingChatMessage.getAgentAvatar());
                amsAgentMarkdownHyperlinkViewHolder.setAgentNickName(currentMessagingChatMessage.getAgentNickName());
                this.setAgentMessageText(mMessagingChatMessage, message, amsAgentMarkdownHyperlinkViewHolder);
                break;
            }
            case AGENT_IS_TYPING_INDICATOR: {
                AmsAgentTypingViewHolder agentViewHolder = (AmsAgentTypingViewHolder)holder;
                agentViewHolder.showTypingAnimation();
                agentViewHolder.setAgentAvatar(currentMessagingChatMessage.getAgentAvatar());
                String agentIsTyping = agentViewHolder.itemView.getContext().getString(R.string.lp_accessibility_agent_is_typing);
                agentViewHolder.setContentDescription(agentIsTyping);
                break;
            }
            case AGENT_URL: {
                AmsAgentURLViewHolder agentUrlViewHolder = (AmsAgentURLViewHolder)holder;
                timeStamp = mMessagingChatMessage.getTimeStamp();
                agentUrlViewHolder.setAgentAvatar(currentMessagingChatMessage.getAgentAvatar());
                agentUrlViewHolder.setAgentNickName(currentMessagingChatMessage.getAgentNickName());
                this.setAgentMessageText(mMessagingChatMessage, message, agentUrlViewHolder);
                break;
            }
            case AGENT_FORM: {
                AmsAgentFormInvitationViewHolder agentFormInvitationViewHolder = (AmsAgentFormInvitationViewHolder)holder;
                timeStamp = mMessagingChatMessage.getTimeStamp();
                agentFormInvitationViewHolder.setAgentAvatar(currentMessagingChatMessage.getAgentAvatar());
                agentFormInvitationViewHolder.setAgentNickName(currentMessagingChatMessage.getAgentNickName());
                agentFormInvitationViewHolder.setMessageState(mMessagingChatMessage.getMessageState());
                agentFormInvitationViewHolder.setViewAppearanceByState(mMessagingChatMessage.getMessageState());
                this.setAgentMessageText(mMessagingChatMessage, message, agentFormInvitationViewHolder);
                break;
            }
            case CONSUMER: 
            case CONSUMER_MASKED: {
                AmsConsumerViewHolder consumerViewHolder = (AmsConsumerViewHolder)holder;
                timeStamp = mMessagingChatMessage.getTimeStamp();
                this.setConsumerMessageText(mMessagingChatMessage, message, consumerViewHolder);
                break;
            }
            case CONSUMER_IMAGE: 
            case CONSUMER_DOCUMENT: {
                AmsConsumerFileViewHolder consumerFileViewHolder = (AmsConsumerFileViewHolder)holder;
                this.setConsumerMessageText(mMessagingChatMessage, message, consumerFileViewHolder);
                timeStamp = mMessagingChatMessage.getTimeStamp();
                FileMessage fileMessage = currentMessagingChatMessage.getFileMessage();
                if (fileMessage != null) {
                    String previewUri = fileMessage.getPreview();
                    String fullImagePath = fileMessage.getLocalUrl();
                    FilesTable.LoadStatus loadStatus = fileMessage.getLoadStatus();
                    String fileType = fileMessage.getFileType();
                    consumerFileViewHolder.setMessageImage(fullImagePath, previewUri, loadStatus, fileType);
                    consumerFileViewHolder.getAmsDownloadableFileViewProcessor().setFileRowId(fileMessage.getFileRowId());
                }
                consumerFileViewHolder.setImageLongClickListener(v -> {
                    FileMessage onClickFileMessage = currentMessagingChatMessage.getFileMessage();
                    return consumerFileViewHolder.setContextualBehaviorOnLongClick(this.mMessagingContextualActionController.getOnLongClickListener((int)currentMessagingChatMessage.getMessagingChatMessage().getTimeStamp(), (BaseViewHolder)consumerFileViewHolder, onClickFileMessage));
                });
                consumerFileViewHolder.setImageClickListener(v -> {
                    if (this.conversationViewCallback != null) {
                        final MessagingChatMessage currentChatMessage = currentMessagingChatMessage.getMessagingChatMessage();
                        if (currentChatMessage == null) {
                            return;
                        }
                        final String dialogId = currentChatMessage.getDialogId();
                        final FileMessage mostUpdatedFileMessage = currentMessagingChatMessage.getFileMessage();
                        if (this.mMessagingContextualActionController.isSelectable()) {
                            consumerFileViewHolder.setContextualBehaviorOnClick(this.mMessagingContextualActionController.getOnClickListener((int)mMessagingChatMessage.getTimeStamp(), (BaseViewHolder)consumerFileViewHolder, mostUpdatedFileMessage));
                            return;
                        }
                        if (v.getId() != R.id.lpui_message_image) {
                            return;
                        }
                        if (mostUpdatedFileMessage == null) {
                            LPLog.INSTANCE.d(TAG, "file message is null, cannot download or open file");
                            return;
                        }
                        if (!MessagingFactory.getInstance().getController().mConnectionController.isSocketReady(this.mBrandId) && TextUtils.isEmpty((CharSequence)mostUpdatedFileMessage.getLocalUrl())) {
                            consumerFileViewHolder.getAmsDownloadableFileViewProcessor().startFailedAnimation();
                        } else {
                            MessagingFactory.getInstance().getController().amsDialogs.getDialogByIdAsync(dialogId, (ICallback)new ICallback<Dialog, Exception>(){

                                public void onSuccess(Dialog dialog) {
                                    this.handleOnClick(dialog.getConversationId());
                                }

                                public void onError(Exception exception) {
                                    this.handleOnClick(dialogId);
                                }

                                private void handleOnClick(String conversationId) {
                                    try {
                                        String fileExtension = mostUpdatedFileMessage.getFileType().toLowerCase();
                                        MessagesAsListAdapter.this.conversationViewCallback.onFileClicked(FileSharingType.getFileTypeFromExtension((String)fileExtension), mostUpdatedFileMessage.getLocalUrl(), mostUpdatedFileMessage.getSwiftPath(), currentChatMessage.getLocalId(), mostUpdatedFileMessage.getFileRowId(), conversationId);
                                    }
                                    catch (Exception e) {
                                        LPLog.INSTANCE.e(MessagesAsListAdapter.TAG, ErrorCode.ERR_000000F2, "Failed to perform file action.", (Throwable)e);
                                    }
                                }
                            });
                        }
                    }
                });
                break;
            }
            case AGENT_IMAGE: 
            case AGENT_DOCUMENT: {
                AmsAgentFileViewHolder agentFileViewHolder = (AmsAgentFileViewHolder)holder;
                timeStamp = mMessagingChatMessage.getTimeStamp();
                agentFileViewHolder.setAgentAvatar(currentMessagingChatMessage.getAgentAvatar());
                agentFileViewHolder.setAgentNickName(currentMessagingChatMessage.getAgentNickName());
                this.setAgentMessageText(mMessagingChatMessage, message, agentFileViewHolder);
                FileMessage fileMessage = currentMessagingChatMessage.getFileMessage();
                if (fileMessage != null) {
                    String previewUri = fileMessage.getPreview();
                    String fullImagePath = fileMessage.getLocalUrl();
                    FilesTable.LoadStatus loadStatus = fileMessage.getLoadStatus();
                    String fileType = fileMessage.getFileType();
                    agentFileViewHolder.setMessageImage(fullImagePath, previewUri, loadStatus, fileType);
                    agentFileViewHolder.getAmsDownloadableFileViewProcessor().setFileRowId(fileMessage.getFileRowId());
                }
                agentFileViewHolder.setImageLongClickListener(v -> {
                    FileMessage onClickFileMessage = currentMessagingChatMessage.getFileMessage();
                    MessagingChatMessage messagingChatMessage = currentMessagingChatMessage.getMessagingChatMessage();
                    if (messagingChatMessage == null) {
                        return false;
                    }
                    return agentFileViewHolder.setContextualBehaviorOnLongClick(this.mMessagingContextualActionController.getOnLongClickListener((int)messagingChatMessage.getTimeStamp(), (BaseViewHolder)agentFileViewHolder, onClickFileMessage));
                });
                agentFileViewHolder.setImageClickListener(v -> {
                    if (this.conversationViewCallback != null) {
                        final MessagingChatMessage chatMessage = currentMessagingChatMessage.getMessagingChatMessage();
                        if (chatMessage == null) {
                            return;
                        }
                        final String dialogId = chatMessage.getDialogId();
                        final FileMessage mostUpdatedFileMessage = currentMessagingChatMessage.getFileMessage();
                        if (this.mMessagingContextualActionController.isSelectable()) {
                            agentFileViewHolder.setContextualBehaviorOnClick(this.mMessagingContextualActionController.getOnClickListener((int)mMessagingChatMessage.getTimeStamp(), (BaseViewHolder)agentFileViewHolder, mostUpdatedFileMessage));
                            return;
                        }
                        if (mostUpdatedFileMessage == null) {
                            LPLog.INSTANCE.d(TAG, "file message is null, cannot download or open file");
                            return;
                        }
                        if (!MessagingFactory.getInstance().getController().mConnectionController.isSocketReady(this.mBrandId) && TextUtils.isEmpty((CharSequence)mostUpdatedFileMessage.getLocalUrl())) {
                            agentFileViewHolder.getAmsDownloadableFileViewProcessor().startFailedAnimation();
                        } else {
                            MessagingFactory.getInstance().getController().amsDialogs.getDialogByIdAsync(dialogId, (ICallback)new ICallback<Dialog, Exception>(){

                                public void onSuccess(Dialog dialog) {
                                    this.handleOnClick(dialog.getConversationId());
                                }

                                public void onError(Exception exception) {
                                    this.handleOnClick(dialogId);
                                }

                                private void handleOnClick(String conversationId) {
                                    FileSharingType fileSharingType;
                                    try {
                                        fileSharingType = FileSharingType.valueOf((String)mostUpdatedFileMessage.getFileType());
                                    }
                                    catch (IllegalArgumentException e) {
                                        fileSharingType = FileSharingType.UNKNOWN;
                                        LPLog.INSTANCE.e(MessagesAsListAdapter.TAG, ErrorCode.ERR_000000F3, "Unknown file sharing type: " + mostUpdatedFileMessage.getFileType(), (Throwable)e);
                                    }
                                    try {
                                        MessagesAsListAdapter.this.conversationViewCallback.onFileClicked(fileSharingType, mostUpdatedFileMessage.getLocalUrl(), mostUpdatedFileMessage.getSwiftPath(), chatMessage.getLocalId(), mostUpdatedFileMessage.getFileRowId(), conversationId);
                                    }
                                    catch (Exception e) {
                                        LPLog.INSTANCE.e(MessagesAsListAdapter.TAG, ErrorCode.ERR_000000F4, "Failed to perform file action.", (Throwable)e);
                                    }
                                }
                            });
                        }
                    }
                });
                break;
            }
            case CONSUMER_VOICE: {
                AmsConsumerVoiceViewHolder consumerVoiceViewHolder = (AmsConsumerVoiceViewHolder)holder;
                this.setConsumerMessageText(mMessagingChatMessage, message, consumerVoiceViewHolder);
                FileMessage voiceMessage = currentMessagingChatMessage.getFileMessage();
                if (voiceMessage != null) {
                    String voiceFilePath = voiceMessage.getLocalUrl();
                    FilesTable.LoadStatus loadStatus = voiceMessage.getLoadStatus();
                    consumerVoiceViewHolder.setVoiceProperties(voiceFilePath, loadStatus, currentMessagingChatMessage);
                    LPAudioUtils audioUtils = MessagingFactory.getInstance().getController().getAudioUtils();
                    if (audioUtils.isPlaying(voiceFilePath)) {
                        int playingLocation = audioUtils.getCurrentPlayingLocation();
                        int playingDuration = audioUtils.getCurrentPlayingDuration();
                        consumerVoiceViewHolder.setCurrentPlaying(voiceFilePath, playingLocation, playingDuration);
                    }
                }
                holder.updateContentDescription();
                break;
            }
            case CONSUMER_URL_MASKED: 
            case CONSUMER_URL: {
                AmsConsumerURLViewHolder consumerURLViewHolder = (AmsConsumerURLViewHolder)holder;
                timeStamp = mMessagingChatMessage.getTimeStamp();
                this.setConsumerMessageText(mMessagingChatMessage, message, consumerURLViewHolder);
                break;
            }
            case CONSUMER_FORM: {
                AmsConsumerFormSubmissionViewHolder consumerFormSubmissionViewHolder = (AmsConsumerFormSubmissionViewHolder)holder;
                timeStamp = mMessagingChatMessage.getTimeStamp();
                this.setConsumerMessageText(mMessagingChatMessage, message, consumerFormSubmissionViewHolder);
                break;
            }
            case UNREAD_INDICATOR: {
                UiUnreadIndicatorViewHolder amsUnreadIndicatorViewHolder = (UiUnreadIndicatorViewHolder)holder;
                amsUnreadIndicatorViewHolder.setMessageTextView(message);
                amsUnreadIndicatorViewHolder.updateContentDescription();
                break;
            }
            case AGENT_STRUCTURED_CONTENT: {
                AmsAgentStructuredContentViewHolder amsAgentStructuredContentViewHolder = (AmsAgentStructuredContentViewHolder)holder;
                OnSCActionClickListener globalListener = this.getSCActionClickListener(currentMessagingChatMessage.getMessagingChatMessage(), false, -5 == mMessagingChatMessage.getServerSequence());
                amsAgentStructuredContentViewHolder.setAgentNickName(currentMessagingChatMessage.getAgentNickName());
                amsAgentStructuredContentViewHolder.loadContent(currentMessagingChatMessage, globalListener, null);
                if (-5 == mMessagingChatMessage.getServerSequence()) {
                    amsAgentStructuredContentViewHolder.setAgentAvatarAsBrand();
                } else {
                    amsAgentStructuredContentViewHolder.setAgentAvatar(currentMessagingChatMessage.getAgentAvatar());
                }
                this.setAgentMessageText(mMessagingChatMessage, null, amsAgentStructuredContentViewHolder);
                break;
            }
            case AGENT_QUICK_REPLIES: {
                AmsAgentStructuredContentViewHolder amsAgentStructuredContentViewHolder = (AmsAgentStructuredContentViewHolder)holder;
                OnSCActionClickListener globalListener = this.getSCActionClickListener(currentMessagingChatMessage.getMessagingChatMessage(), this.isMetadataFromWelcomeMessage(holder, currentMessagingChatMessage.getMessagingChatMessage()), -5 == mMessagingChatMessage.getServerSequence());
                QRActionClickListener quickRepliesCloseAction = () -> this.messagesAsListLoader.hideShowQuickRepliesFlagInSharedPreference();
                amsAgentStructuredContentViewHolder.loadContent(currentMessagingChatMessage, globalListener, quickRepliesCloseAction);
                amsAgentStructuredContentViewHolder.setTimestamp(mMessagingChatMessage.getTimeStamp());
                amsAgentStructuredContentViewHolder.setAgentAvatar(currentMessagingChatMessage.getAgentAvatar());
                break;
            }
            case CONTROLLER_SYSTEM: {
                AmsControllerSystemViewHolder controllerSystemViewHolder = (AmsControllerSystemViewHolder)holder;
                controllerSystemViewHolder.setMessageTextView(message);
                controllerSystemViewHolder.updateContentDescription();
                break;
            }
            case COBROWSE: {
                LPLog.INSTANCE.d(TAG, "onBindViewHolder position: " + position + " cobrowse");
                AmsCoBrowseViewHolder coBrowseViewHolder = (AmsCoBrowseViewHolder)holder;
                coBrowseViewHolder.setTimestamp(mMessagingChatMessage.getTimeStamp());
                coBrowseViewHolder.setAgentNickName(currentMessagingChatMessage.getAgentNickName());
                coBrowseViewHolder.setAgentAvatar(currentMessagingChatMessage.getAgentAvatar());
                CoBrowseMetadata metadata = CoBrowseManager.instance.getMetadata(this.mBrandId, currentMessagingChatMessage.getMessagingChatMessage().getMessage());
                if (metadata != null) {
                    LPLog.INSTANCE.d(TAG, "cobrowsetable dialogId " + metadata.dialogId + "   isPresentable: " + metadata.isPresentable() + "    isClosed: " + metadata.isClosed() + "    isJoinable: " + metadata.isJoinable() + "   isInvite: " + metadata.isInvite() + "     sessionState: " + metadata.sessionState + "    notificationKey: " + metadata.notificationKey + "   metadataPresent: " + (metadata != null));
                    coBrowseViewHolder.setMetadata(metadata, this.mBrandId);
                    coBrowseViewHolder.setVisibility(metadata.isPresentable());
                    break;
                }
                coBrowseViewHolder.setVisibility(true);
                break;
            }
            case DATE_HEADER: {
                DateHeaderViewHolder dateHeaderViewHolder = (DateHeaderViewHolder)holder;
                dateHeaderViewHolder.setTimestamp(mMessagingChatMessage.getTimeStamp());
            }
        }
        if (timeStamp != -1L && this.mMessagingContextualActionController != null) {
            this.mMessagingContextualActionController.applyContextualActionBehavior((int)timeStamp, holder, currentMessagingChatMessage.getFileMessage());
        }
        holder.onBind();
    }

    private boolean isMetadataFromWelcomeMessage(BaseViewHolder holder, MessagingChatMessage chatMessage) {
        if (holder.getBindingAdapterPosition() == 0) {
            return false;
        }
        FullMessageRow previousMessageRow = this.messagesAsListLoader.getItem(holder.getBindingAdapterPosition() - 1);
        return previousMessageRow.getMessagingChatMessage().getServerSequence() == -4 && chatMessage.getMessageType() == MessagingChatMessage.MessageType.AGENT_QUICK_REPLIES;
    }

    private OnSCActionClickListener getSCActionClickListener(final MessagingChatMessage chatMessage, final boolean isMetadataFromWelcomeMessage, final boolean isProactive) {
        return new OnSCActionClickListener(){

            public void onPublishTextActionClick(String text, JSONArray metadata) {
                if (metadata != null) {
                    MessagesAsListAdapter.this.sendSCActionStatus(metadata, chatMessage, isMetadataFromWelcomeMessage);
                }
                MessagingFactory.getInstance().getController().sendMessage(MessagesAsListAdapter.this.mBrandId, MessagesAsListAdapter.this.mBrandId, text, new DeliveryStatusUpdateInfo(metadata));
                MessagesAsListAdapter.this.logAnalyticSCAction(isProactive, "onPublishTextActionClick");
            }

            public void onLinkActionClick(String link, JSONArray metadata) {
                if (metadata != null) {
                    MessagesAsListAdapter.this.sendSCActionStatus(metadata, chatMessage, isMetadataFromWelcomeMessage);
                }
                if (!TextUtils.isEmpty((CharSequence)link)) {
                    if (Configuration.getBoolean((int)R.bool.structured_content_link_as_callback)) {
                        MessagingFactory.getInstance().getController().mEventsProxy.onStructuredContentLinkClicked(link);
                    } else {
                        MessagesAsListAdapter.this.mMessagingContextualActionController.getContextualItemAction().performOpenLink(link, false, BaseViewHolder.LinkType.URL);
                    }
                }
                MessagesAsListAdapter.this.logAnalyticSCAction(isProactive, "onLinkActionClick");
            }

            public void onNavigateActionClick(String latitude, String longitude, JSONArray metadata) {
                if (metadata != null) {
                    MessagesAsListAdapter.this.sendSCActionStatus(metadata, chatMessage, isMetadataFromWelcomeMessage);
                }
                if (!TextUtils.isEmpty((CharSequence)latitude) && !TextUtils.isEmpty((CharSequence)longitude)) {
                    String link = "geo:" + latitude + "," + longitude + "?q=" + latitude + "," + longitude;
                    MessagesAsListAdapter.this.mMessagingContextualActionController.getContextualItemAction().performOpenLink(link, false, BaseViewHolder.LinkType.NAVIGATION);
                }
                MessagesAsListAdapter.this.logAnalyticSCAction(isProactive, "onNavigateActionClick");
            }

            public void onDatePickerActionClick(JSONObject data) {
                try {
                    boolean hasMaxDate;
                    if (data.has("type") && data.getString("type").equals("scheduleSlotList")) {
                        MessagesAsListAdapter.this.lpAppointmentSchedulerHandler.initializeAppointmentScheduler(data);
                        return;
                    }
                    long DEFAULT_RANGE = 4730400000000L;
                    String type = data.getString("class");
                    String title = data.getString("title");
                    long minDate = new Date().getTime() - 4730400000000L;
                    long maxDate = new Date().getTime() + 4730400000000L;
                    boolean hasMinDate = data.has("minDate");
                    boolean bl = hasMaxDate = data.has("maxDate");
                    if (hasMinDate && !hasMaxDate) {
                        minDate = data.getLong("minDate") * 1000L;
                        maxDate = minDate + 4730400000000L;
                    } else if (!hasMinDate && hasMaxDate) {
                        maxDate = data.getLong("maxDate") * 1000L;
                        minDate = maxDate - 4730400000000L;
                    } else if (hasMinDate && hasMaxDate) {
                        minDate = data.getLong("minDate") * 1000L;
                        maxDate = data.getLong("maxDate") * 1000L;
                    }
                    String dateFormat = "";
                    if (data.has("dateFormat")) {
                        dateFormat = data.getString("dateFormat");
                    }
                    CalendarInitInfo calendarInitInfo = new CalendarInitInfo(type, title, minDate, maxDate, dateFormat);
                    MessagesAsListAdapter.this.conversationViewCallback.onDatePickerClicked(calendarInitInfo);
                }
                catch (JSONException e) {
                    Toast.makeText((Context)MessagesAsListAdapter.this.mRecyclerView.getContext(), (int)R.string.lpmessaging_general_error_message, (int)0).show();
                    LPLog.INSTANCE.e(MessagesAsListAdapter.TAG, ErrorCode.ERR_0000015E, e.getMessage(), (Throwable)e);
                }
                MessagesAsListAdapter.this.logAnalyticSCAction(isProactive, "onDatePickerActionClick");
            }
        };
    }

    private void logAnalyticSCAction(boolean isProactive, String actionType) {
        LPAuthenticationParams params = MessagingFactory.getInstance().getController().mAccountsController.getLPAuthenticationParams(this.mBrandId);
        if (params != null) {
            LPAnalytics.ConsumerAction.INSTANCE.trackClickStructuredContent(params.getAuthType(), LocaleUtils.getInstance().getLocaleCode(), isProactive, actionType);
        } else {
            LPLog.INSTANCE.d(TAG, "getLPAuthenticationParams: getLPAuthenticationParams returns null for brand with id: " + this.mBrandId);
        }
    }

    private void sendSCActionStatus(JSONArray metadata, MessagingChatMessage chatMessage, boolean isMetadataFromWelcomeMessage) {
        if (isMetadataFromWelcomeMessage || !MessagingFactory.getInstance().getController().isDialogClosed(chatMessage.getDialogId())) {
            LPLog.INSTANCE.d(TAG, "onClick: Sending metadata to UMS: " + LPLog.INSTANCE.mask((Object)metadata.toString()));
            Conversation conversation = MessagingFactory.getInstance().getController().amsConversations.getConversationFromTargetIdMap(this.mBrandId);
            String conversationId = conversation == null ? "" : conversation.getConversationId();
            MessagingFactory.getInstance().getController().sendDeliveryStatusUpdateCommand(this.mBrandId, chatMessage.getDialogId(), conversationId, chatMessage.getServerSequence(), DeliveryStatus.ACTION, new DeliveryStatusUpdateInfo(metadata));
        } else {
            LPLog.INSTANCE.i(TAG, "dialog closed, don't send metadata to UMS: " + LPLog.INSTANCE.mask((Object)metadata.toString()));
        }
    }

    private void setConsumerMessageText(MessagingChatMessage mMessagingChatMessage, String message, AmsConsumerViewHolder consumerViewHolder) {
        consumerViewHolder.setContextualActionBehavior(this.mMessagingContextualActionController);
        consumerViewHolder.setMessageText(message, true);
        consumerViewHolder.setTimestamp(mMessagingChatMessage.getTimeStamp());
        consumerViewHolder.setViewAppearanceByState(mMessagingChatMessage.getMessageState(), mMessagingChatMessage.getMessageType(), (Message)mMessagingChatMessage);
        consumerViewHolder.updateContentDescription();
    }

    private void setAgentMessageText(MessagingChatMessage mMessagingChatMessage, String message, AmsAgentViewHolder agentViewHolder) {
        agentViewHolder.setContextualActionBehavior(this.mMessagingContextualActionController);
        if (message != null) {
            agentViewHolder.setMessageText(message, true);
        }
        agentViewHolder.setTimestamp(mMessagingChatMessage.getTimeStamp());
        agentViewHolder.updateContentDescription();
    }

    void setCopyBehavior(ContextualActionBehavior contextualActionBehavior) {
        this.mMessagingContextualActionController = contextualActionBehavior;
        contextualActionBehavior.setMenuStateListener(new IMenuCallback(){

            @Override
            public void onMenuOpen() {
            }

            @Override
            public void onMenuClose() {
                MessagesAsListAdapter.this.notifyDataSetChanged();
            }
        });
        contextualActionBehavior.setActionMode();
    }

    public void onViewRecycled(@NonNull BaseViewHolder holder) {
        if (this.mMessagingContextualActionController != null) {
            this.mMessagingContextualActionController.onViewRecycled((RecyclerView.ViewHolder)holder);
        }
        holder.recycle();
        LPLog.INSTANCE.d(TAG, "onViewRecycled holder = " + holder.hashCode() + " type = " + holder.getItemViewType());
        super.onViewRecycled((RecyclerView.ViewHolder)holder);
    }

    public void onViewAttachedToWindow(@NonNull BaseViewHolder holder) {
        super.onViewAttachedToWindow((RecyclerView.ViewHolder)holder);
        holder.setRequestTimestampListener((BaseViewHolder.OnRequestTimestampUpdateListener)this);
        holder.observeTimestampChanges();
    }

    public void onViewDetachedFromWindow(@NonNull BaseViewHolder holder) {
        super.onViewDetachedFromWindow((RecyclerView.ViewHolder)holder);
        holder.stopObservingTimestampsChanges();
    }

    public int getItemCount() {
        return this.messagesAsListLoader.size();
    }

    void onConnectionAvailable() {
        this.messagesAsListLoader.onConnectionAvailable();
        this.mRecyclerView.postDelayed(() -> {
            this.pendingScrollToBottom = false;
        }, 10000L);
    }

    void onConnectionLost() {
        this.messagesAsListLoader.onConnectionLost();
    }

    @Override
    public void onBackground() {
        this.mIsForeground = false;
        this.lpAppointmentSchedulerHandler.unSubscribeToAppointmentLogs();
        this.messagesAsListLoader.onBackground();
        this.saveCurrentVisiblePosition();
        this.cancelTimestampUpdates();
    }

    public void requestTimestampsUpdate(int position) {
        if (this.mIsForeground) {
            this.notifyItemChanged(position, PAYLOAD_UPDATE_TIMESTAMP);
        }
    }

    public void onUpdateTimestampWithDelay(long delay, Runnable runnable) {
        if (this.mIsForeground) {
            if (delay > 0L) {
                this.mUpdatesHandler.postDelayed(runnable, delay);
            } else {
                this.mUpdatesHandler.post(runnable);
            }
        } else {
            this.cancelTimestampsUpdate(runnable);
        }
    }

    public void cancelTimestampsUpdate(Runnable runnable) {
        this.mUpdatesHandler.removeCallbacks(runnable);
    }

    private void saveCurrentVisiblePosition() {
        int savedFirstVisibleItemPosition;
        int firstVisiblePos = this.getFirstVisibleItemPosition();
        int threshold = firstVisiblePos + 100;
        int serverMessQuantity = this.messagesAsListLoader.getTotalMessagesWithPositiveSequence(threshold);
        int distance = serverMessQuantity - firstVisiblePos;
        if (this.messagesAsListLoader.size() < 100) {
            savedFirstVisibleItemPosition = this.getFirstVisibleItemPosition();
        } else if (distance < 100) {
            savedFirstVisibleItemPosition = 100 - distance;
            if (this.messagesAsListLoader.getUnreadPosition() != -1) {
                ++savedFirstVisibleItemPosition;
            }
        } else {
            savedFirstVisibleItemPosition = -1;
            distance = 0;
        }
        int lastPosition = this.getLastVisibleItemPosition();
        if (lastPosition == this.messagesAsListLoader.size() - 1) {
            distance = 0;
        }
        PreferenceManager.getInstance().setIntValue(KEY_SCROLLING_OFFSET, this.mBrandId, distance);
        PreferenceManager.getInstance().setIntValue(KEY_LAST_SCROLLED_FIRST_VISIBLE_ITEM_POSITION, this.mBrandId, savedFirstVisibleItemPosition);
    }

    @Override
    public void onForeground() {
        this.fromPushNotification = PushMessagePreferences.INSTANCE.isPushNotificationClicked();
        this.messagesAsListLoader.onForeground();
        this.mIsForeground = true;
        this.resumeTimestampUpdates();
        if (!this.firstTimeBringToForeground) {
            this.performScroll();
        }
    }

    private void announceAccessibilityMessage(String prefix, FullMessageRow fullMessageRow) {
        MessagingChatMessage.MessageType messageType = fullMessageRow.getMessagingChatMessage().getMessageType();
        String accessibilityText = "";
        switch (messageType) {
            case AGENT_FORM: {
                String securityFormDescription = this.mRecyclerView.getContext().getString(R.string.lpmessaging_ui_secure_form_to_fill_in_message);
                String fillInFormButton = this.mRecyclerView.getContext().getString(R.string.lpmessaging_ui_fill_in_form_text_button);
                String buttonAccessibilityText = this.mRecyclerView.getContext().getString(R.string.lp_accessibility_sc_button);
                accessibilityText = securityFormDescription + ". " + fillInFormButton + ". " + buttonAccessibilityText;
                break;
            }
            case AGENT_URL: {
                accessibilityText = this.mRecyclerView.getContext().getString(R.string.lp_accessibility_link);
                break;
            }
            case AGENT_MARKDOWN_HYPERLINK: {
                String message = fullMessageRow.getMessagingChatMessage().getMessage();
                List<MarkdownHyperlinkItem> hyperlinkItemList = HyperLinkUtils.INSTANCE.buildHyperlinkList(message);
                String linkWord = this.mRecyclerView.getResources().getQuantityString(R.plurals.lp_accessibility_links, hyperlinkItemList.size(), new Object[]{hyperlinkItemList.size()});
                accessibilityText = HyperLinkUtils.INSTANCE.buildMessageString(message) + ", " + linkWord;
                break;
            }
            default: {
                accessibilityText = "";
            }
        }
        String accessibilityMessage = AccessbilityUtilsKt.getAccessibilityMessage(fullMessageRow.getMessagingChatMessage(), accessibilityText, this.mRecyclerView.getContext());
        if (!TextUtils.isEmpty((CharSequence)accessibilityMessage) || messageType != MessagingChatMessage.MessageType.SYSTEM_RESOLVED) {
            this.mRecyclerView.announceForAccessibility(prefix + accessibilityMessage);
        }
    }

    String getAgentAvatarUrl(String originatorId) {
        return this.messagesAsListLoader.getAgentUrl(originatorId);
    }

    void removeQuickRepliesMessageOfDialog(String dialogId) {
        this.messagesAsListLoader.removeQuickRepliesMessageOfDialog(dialogId);
    }

    void removeQuickRepliesMessageOfConversation(String conversationId) {
        this.messagesAsListLoader.removeQuickRepliesMessageOfConversation(conversationId);
    }

    void removeCoBrowsMessageOfConversation(String dialogId) {
        this.messagesAsListLoader.hideCoBrowsMessage(dialogId);
    }

    private void performScroll() {
        if (!MessagingFactory.getInstance().getController().mAccountsController.isInUnAuthMode(this.mBrandId)) {
            if (this.fromPushNotification) {
                this.scrollOnPushNotification();
            } else if (!this.firstTimeBringToForeground) {
                this.scrollOnForeground();
            } else {
                this.scrollOnInAppNavigation();
            }
            this.firstTimeBringToForeground = false;
        }
        this.isFirstScrollPerformed = true;
    }

    private void scrollOnForeground() {
        String scrollPosition;
        switch (scrollPosition = Configuration.getString((int)R.string.lp_scroll_when_foreground).toLowerCase()) {
            case "lastposition": {
                this.pendingScrollToBottom = false;
                break;
            }
            case "bottom": {
                this.scrollToBottom();
                break;
            }
            case "firstunreadmessage": {
                this.pendingScrollToBottom = false;
                if (this.messagesAsListLoader.getUnreadPosition() != -1) {
                    this.scrollToUnreadPosition();
                    break;
                }
                this.scrollToBottom();
                break;
            }
            default: {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000F5, "Invalid scroll configuration for string: lp_scroll_when_foreground." + scrollPosition);
                this.pendingScrollToBottom = false;
            }
        }
    }

    private void scrollOnInAppNavigation() {
        String scrollPosition;
        int position = PreferenceManager.getInstance().getIntValue(KEY_LAST_SCROLLED_FIRST_VISIBLE_ITEM_POSITION, this.mBrandId, -1);
        int offset = PreferenceManager.getInstance().getIntValue(KEY_SCROLLING_OFFSET, this.mBrandId, 0);
        switch (scrollPosition = Configuration.getString((int)R.string.lp_scroll_show_conversation).toLowerCase()) {
            case "lastposition": {
                this.pendingScrollToBottom = false;
                if (position < 0) break;
                StickyHeadersLinearLayoutManager manager = (StickyHeadersLinearLayoutManager)this.mRecyclerView.getLayoutManager();
                if (this.shouldScrollToFirstByInApp) {
                    int scrollingOffset = this.messagesAsListLoader.size() - offset;
                    manager.scrollToPositionWithOffset(scrollingOffset, 0);
                } else {
                    manager.scrollToPositionWithOffset(position, 0);
                }
                this.shouldScrollToFirstByInApp = false;
                break;
            }
            case "bottom": {
                this.pendingScrollToBottom = true;
                break;
            }
            case "firstunreadmessage": {
                this.pendingScrollToBottom = false;
                if (this.messagesAsListLoader.getUnreadPosition() != -1) {
                    this.scrollToUnreadPosition();
                }
                this.pendingScrollToFirstUnreadMessage = true;
                break;
            }
            default: {
                this.pendingScrollToBottom = true;
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000F6, "Invalid scroll configuration for string: lp_scroll_show_conversation." + scrollPosition);
            }
        }
        PreferenceManager.getInstance().setIntValue(KEY_SCROLLING_OFFSET, this.mBrandId, 0);
        PreferenceManager.getInstance().setIntValue(KEY_LAST_SCROLLED_FIRST_VISIBLE_ITEM_POSITION, this.mBrandId, -1);
    }

    private void scrollOnPushNotification() {
        String scrollPosition;
        switch (scrollPosition = Configuration.getString((int)R.string.lp_scroll_when_push_notification).toLowerCase()) {
            case "lastposition": {
                this.pendingScrollToBottom = false;
                int inAppLastScrolledPosition = PreferenceManager.getInstance().getIntValue(KEY_LAST_SCROLLED_FIRST_VISIBLE_ITEM_POSITION, this.mBrandId, -1);
                int offset = PreferenceManager.getInstance().getIntValue(KEY_SCROLLING_OFFSET, this.mBrandId, 0);
                if (inAppLastScrolledPosition >= 0) {
                    this.keepLastPositionOnNewMessage = true;
                    if (this.shouldScrollToFirstByPush) {
                        int scrollingOffset = this.messagesAsListLoader.size() - offset;
                        ((StickyHeadersLinearLayoutManager)this.mRecyclerView.getLayoutManager()).scrollToPositionWithOffset(scrollingOffset, 0);
                    } else {
                        ((StickyHeadersLinearLayoutManager)this.mRecyclerView.getLayoutManager()).scrollToPositionWithOffset(inAppLastScrolledPosition, 0);
                    }
                    this.shouldScrollToFirstByPush = false;
                    break;
                }
                this.keepLastPositionOnNewMessage = false;
                break;
            }
            case "bottom": {
                this.pendingScrollToBottom = true;
                break;
            }
            case "firstunreadmessage": {
                this.pendingScrollToBottom = false;
                if (this.messagesAsListLoader.getUnreadPosition() != -1) {
                    this.scrollToUnreadPosition();
                }
                this.pendingScrollToFirstUnreadMessage = true;
                break;
            }
            default: {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000F7, "Invalid scroll configuration for string: lp_scroll_when_push_notification." + scrollPosition);
                this.pendingScrollToBottom = true;
            }
        }
    }

    private void scrollOnScrollDownIndicatorClicked() {
        String scrollPosition;
        switch (scrollPosition = Configuration.getString((int)R.string.lp_scroll_when_scroll_down).toLowerCase()) {
            case "firstunreadmessage": {
                this.scrollToUnreadPosition();
                break;
            }
            case "bottom": {
                this.smoothScrollToBottom();
                break;
            }
            default: {
                this.smoothScrollToBottom();
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000F8, "Invalid scroll configuration for string: lp_scroll_when_scroll_down." + scrollPosition);
            }
        }
    }

    private void scrollToBottom() {
        this.mRecyclerView.scrollToPosition(this.messagesAsListLoader.size() - 1);
    }

    private void smoothScrollToBottom() {
        int bottomPosition = this.messagesAsListLoader.size() - 1;
        if (this.messagesAsListLoader.size() - this.getLastVisibleItemPosition() <= 20) {
            this.mRecyclerView.smoothScrollToPosition(bottomPosition);
        } else {
            this.mRecyclerView.scrollToPosition(bottomPosition);
        }
    }

    private void scrollToUnreadPosition() {
        int unreadPosition = this.messagesAsListLoader.getUnreadPosition();
        if (this.messagesAsListLoader.size() > 0) {
            if (unreadPosition > -1 && unreadPosition < this.messagesAsListLoader.size()) {
                ((StickyHeadersLinearLayoutManager)this.mRecyclerView.getLayoutManager()).scrollToPositionWithOffset(unreadPosition, 0);
                this.mScrollDownIndicator.resetAndShowCollapsed();
                this.messagesAsListLoader.setScrollDownIndicatorVisible(true);
            } else {
                this.scrollToBottom();
            }
        }
    }

    private void setPushNotificationClickedFalse() {
        this.fromPushNotification = false;
    }

    private void cancelTimestampUpdates() {
        this.mUpdatesHandler.removeCallbacksAndMessages(null);
    }

    private void resumeTimestampUpdates() {
        int firstPosition = this.getFirstVisibleItemPosition();
        int lastPosition = this.getLastVisibleItemPosition();
        for (int i = firstPosition; i < lastPosition; ++i) {
            RecyclerView.ViewHolder holder = this.mRecyclerView.findViewHolderForLayoutPosition(i);
            if (!(holder instanceof BaseViewHolder)) continue;
            this.onUpdateTimestampWithDelay(0L, (Runnable)((BaseViewHolder)holder));
        }
    }

    private void changeAccessibilityMode(@NonNull View headerView, int mode) {
        View child;
        headerView.setImportantForAccessibility(mode);
        if (headerView instanceof ViewGroup && (child = ((ViewGroup)headerView).getChildAt(0)) != null) {
            child.setImportantForAccessibility(mode);
        }
    }
}

