/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.uicomponents;

import android.app.AlertDialog;
import android.content.Context;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.StringRes;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.messaging.ActionFailureReason;
import com.liveperson.messaging.Messaging;

public class MessagingUIUtils {
    private Messaging messagingController;

    public MessagingUIUtils(Messaging messagingController) {
        this.messagingController = messagingController;
    }

    public static TextView prepareDialogTitle(Context ctx, @StringRes int id2) {
        TextView textView = new TextView((Context)new ContextThemeWrapper(ctx, R.style.LpDialogWindowTitle), null, 0);
        float paddingFloat = ctx.getResources().getDimension(R.dimen.lp_alert_dialog_padding);
        textView.setPadding((int)paddingFloat, (int)paddingFloat, (int)paddingFloat, 0);
        textView.setText(id2);
        return textView;
    }

    public void showMarkAsUrgentDialog(Context context, String targetId, String brandId) {
        if (this.checkActionAvailableMessage(brandId, context)) {
            return;
        }
        new AlertDialog.Builder(context, R.style.LpAlertDialogCustom).setCustomTitle((View)MessagingUIUtils.prepareDialogTitle(context, R.string.lp_mark_as_urgent_dialog_header)).setMessage(R.string.lp_mark_as_urgent_dialog_message).setPositiveButton(R.string.lp_ok, (dialog, which) -> {
            ActionFailureReason errorType = this.messagingController.markConversationAsUrgent(targetId, brandId);
            this.showRelevantErrorIfNeeded(context, errorType);
            dialog.dismiss();
        }).setNegativeButton(R.string.lp_cancel, (dialog, which) -> dialog.dismiss()).show();
    }

    public void showMarkAsNormalDialog(Context context, String targetId, String brandId) {
        if (this.checkActionAvailableMessage(brandId, context)) {
            return;
        }
        new AlertDialog.Builder(context, R.style.LpAlertDialogCustom).setCustomTitle((View)MessagingUIUtils.prepareDialogTitle(context, R.string.lp_dismiss_urgent_dialog_header)).setMessage(R.string.lp_dismiss_urgent_dialog_message).setPositiveButton(R.string.lp_ok, (dialog, which) -> {
            ActionFailureReason errorType = this.messagingController.markConversationAsNormal(targetId, brandId);
            this.showRelevantErrorIfNeeded(context, errorType);
            dialog.dismiss();
        }).setNegativeButton(R.string.lp_cancel, (dialog, which) -> dialog.dismiss()).show();
    }

    public void showResolveDialog(Context context, String brandId) {
        if (this.checkActionAvailableMessage(brandId, context)) {
            return;
        }
        new AlertDialog.Builder(context, R.style.LpAlertDialogCustom).setCustomTitle((View)MessagingUIUtils.prepareDialogTitle(context, R.string.lp_end_conversation)).setTitle(R.string.lp_end_conversation).setMessage(R.string.lp_mark_as_resolved_dialog_message).setPositiveButton(R.string.lp_end, (dialog, which) -> {
            ActionFailureReason actionFailureReason = this.messagingController.closeDialog(brandId);
            this.showRelevantErrorIfNeeded(context, actionFailureReason);
            dialog.dismiss();
        }).setNegativeButton(R.string.lp_cancel, (dialog, which) -> dialog.dismiss()).show();
    }

    private void showRelevantErrorIfNeeded(Context context, ActionFailureReason errorType) {
        if (errorType == null) {
            return;
        }
        switch (errorType) {
            case NOT_ACTIVE: {
                this.showActionNotAvailableMessage(context);
                break;
            }
            case NO_NETWORK: {
                this.showNoNetworkMessage(context);
                break;
            }
            case POST_SURVEY_IN_PROGRESS: {
                this.showActionNotAvailableInDialogTypeMessage(context);
            }
        }
    }

    private void showActionNotAvailableInDialogTypeMessage(Context context) {
        Toast.makeText((Context)context, (int)R.string.lp_action_not_available_in_dialog_type_toast_message, (int)1).show();
    }

    private void showNoNetworkMessage(Context context) {
        Toast.makeText((Context)context, (int)R.string.lp_no_network_toast_message, (int)1).show();
    }

    private void showActionNotAvailableMessage(Context context) {
        Toast.makeText((Context)context, (int)R.string.lp_no_action_not_available_toast_message, (int)1).show();
    }

    private boolean checkActionAvailableMessage(String brandId, Context context) {
        if (!this.messagingController.mConnectionController.isSocketReady(brandId)) {
            this.showNoNetworkMessage(context);
            return true;
        }
        if (!this.messagingController.amsConversations.isConversationActive(brandId)) {
            this.showActionNotAvailableMessage(context);
            return true;
        }
        return false;
    }
}

