/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.uicomponents;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.os.Handler;
import android.os.Message;
import android.os.Vibrator;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.LinearInterpolator;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.google.android.gms.common.util.Strings;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.IPermissionCallback;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.messaging_ui.MessagingUIFactory;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.model.types.ChatState;
import com.liveperson.infra.ui.R;
import com.liveperson.infra.ui.view.ui.TooltipWindow;
import com.liveperson.infra.ui.view.uicomponents.BaseEnterMessage;
import com.liveperson.infra.utils.DateUtils;
import com.liveperson.infra.utils.DetectHeadsetUnpluggedBroadcastReceiver;
import com.liveperson.infra.utils.LPAudioUtils;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.background.filesharing.FileSharingType;
import java.io.File;
import java.util.concurrent.TimeUnit;

public class AmsEnterMessage
extends BaseEnterMessage {
    private static final String TAG = "AmsEnterMessage";
    private static final long SHOW_TYPING_DELAY_MS = 2000L;
    public static final int MAX_RECORD_TIME_MS = 120000;
    public Handler mHandler = new Handler();
    private ChatState currentChatState = ChatState.ACTIVE;
    private ValueAnimator mColorAnim;
    private ValueAnimator mRecordProgressBarAnimator;
    protected ProgressBar mRecordProgressBar;
    protected TextView mMaxRecordTimeTextView;
    protected TextView mRecordProgressTimeTextView;
    protected int mMaxRecordTimeMs;
    private ViewGroup enterMessageLayout;
    private ViewGroup recordVoiceLayout;
    private ViewGroup recordingControlsLayout;
    private static final int MSG_MIC_LONGER_PRESS = 117;
    protected ImageButton voiceControlButton;
    protected ImageView recordingIndicator;
    protected TooltipWindow mMicTooltipWindow;
    private boolean voiceButtonEnabled = false;
    private String mPausedRecordingFilePath = null;
    private RecordingStatus recordingStatus = RecordingStatus.STOPPED;
    private DetectHeadsetUnpluggedBroadcastReceiver mDetectHeadsetUnpluggedBroadcastReceiver = new DetectHeadsetUnpluggedBroadcastReceiver(){

        protected void onUnpluggedHeadset() {
            AmsEnterMessage.this.onCancelRecording();
        }
    };
    private Handler handler = new Handler(new Handler.Callback(){

        public boolean handleMessage(Message message) {
            if (message.what == 117) {
                AmsEnterMessage.this.mMicTooltipWindow.showToolTip((View)AmsEnterMessage.this.voiceControlButton, AmsEnterMessage.this.getResources().getString(R.string.lp_mic_tooltip_release));
            }
            return true;
        }
    });

    public AmsEnterMessage(Context context) {
        super(context);
    }

    public AmsEnterMessage(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AmsEnterMessage(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mRecordProgressBar = (ProgressBar)this.findViewById(R.id.lpui_voice_recording_progress_bar);
        this.mMaxRecordTimeTextView = (TextView)this.findViewById(R.id.lpui_voice_recording_max_time_text_view);
        this.mRecordProgressTimeTextView = (TextView)this.findViewById(R.id.lpui_voice_recording_time_text_view);
        this.mMaxRecordTimeMs = Configuration.getInteger((int)R.integer.lp_record_max_time_seconds) * 1000;
        if (this.mMaxRecordTimeMs > 120000) {
            this.mMaxRecordTimeMs = 120000;
        }
        this.enterMessageLayout = (ViewGroup)this.findViewById(R.id.lpui_enter_message_layout);
        this.recordVoiceLayout = (ViewGroup)this.findViewById(R.id.lpui_voice_record_layout);
        this.recordingControlsLayout = (ViewGroup)this.findViewById(R.id.lpui_recording_controls_layout);
        this.voiceControlButton = (ImageButton)this.findViewById(R.id.lpui_voice_control_button);
        this.mMicTooltipWindow = new TooltipWindow(this.getContext());
        this.recordingIndicator = (ImageView)this.findViewById(R.id.lpui_recording_indicator);
        this.setVoiceControlButtonPreferences();
        this.setRecordingTrashButtonPreferences();
        this.setRecordingLayoutAnimation();
    }

    public void onConnectionChanged(boolean isConnected) {
        super.onConnectionChanged(isConnected);
        this.setVoiceControlButtonPreferences();
        this.updateVoiceControlButton();
        if (this.voiceButtonEnabled) {
            this.updateEnterMessageView(this.recordingStatus != RecordingStatus.STOPPED);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.updateVoiceControlButton();
        }
    }

    public void enableMicButtonTooltips(boolean enable) {
        if (this.mMicTooltipWindow != null) {
            this.mMicTooltipWindow.enable(enable);
            if (!enable) {
                this.mMicTooltipWindow.dismissTooltip();
            }
        }
    }

    private void updateVoiceControlButton() {
        if (this.mIsConnected) {
            this.voiceControlButton.setEnabled(true);
            this.voiceControlButton.setAlpha(1.0f);
        } else {
            this.voiceControlButton.setEnabled(false);
            this.voiceControlButton.setAlpha(0.5f);
        }
    }

    private boolean isVoiceConfigurationEnabled() {
        boolean voiceSharingSiteSettingsEnabled = PreferenceManager.getInstance().getBooleanValue("site_settings_voice_sharing_enabled_preference_key", "appLevelPreferences", true);
        return voiceSharingSiteSettingsEnabled && Configuration.getBoolean((int)R.bool.enable_voice_sharing);
    }

    private void setVoiceControlButtonPreferences() {
        if (!this.isVoiceConfigurationEnabled()) {
            this.voiceControlButton.setVisibility(8);
            this.voiceButtonEnabled = false;
        } else {
            this.voiceControlButton.setVisibility(0);
            this.voiceButtonEnabled = true;
        }
        LPLog.INSTANCE.d(TAG, "setVoiceControlButtonPreferences. voiceButtonEnabled = " + this.voiceButtonEnabled);
    }

    private void setRecordingTrashButtonPreferences() {
        this.trashButton.setOnClickListener(view -> this.onCancelRecording());
        this.trashButton.setColorFilter(ContextCompat.getColor((Context)this.getContext(), (int)R.color.lp_voice_trash_button_color), PorterDuff.Mode.MULTIPLY);
    }

    private void setRecordingLayoutAnimation() {
        Animation in = AnimationUtils.loadAnimation((Context)this.getContext(), (int)0x10A0000);
        Animation out = AnimationUtils.loadAnimation((Context)this.getContext(), (int)0x10A0001);
        in.setDuration(200L);
        out.setDuration(200L);
        this.mEnterMessageLayoutSwitcher.setInAnimation(in);
        this.mEnterMessageLayoutSwitcher.setOutAnimation(out);
    }

    public void onBackground() {
        super.onBackground();
        if (this.isRecordingInProgress()) {
            this.onCancelRecording();
        }
    }

    protected void sendMessageWithURL(String message, String urlToParse, String title, String imageURL, String description, String siteName) {
        String brandId = this.mBrandIdProvider.getBrandId();
        MessagingFactory controllerFactory = MessagingFactory.getInstance();
        if (controllerFactory.getController().mConnectionController.isSocketReady(brandId) && controllerFactory.getController().mConnectionController.isUpdated(brandId)) {
            this.clearText();
            controllerFactory.getController().sendMessageWithURL(this.mBrandIdProvider.getTargetId(), brandId, message, urlToParse, title, description, imageURL, siteName);
            if (this.mEnterMessageListener != null) {
                this.mEnterMessageListener.onMessageSent();
            }
        } else {
            this.showNoNetworkMessage();
        }
    }

    protected void sendMessage(String message) {
        String brandId = this.mBrandIdProvider.getBrandId();
        MessagingFactory controllerFactory = MessagingFactory.getInstance();
        if (controllerFactory.getController().mConnectionController.isSocketReady(brandId) && controllerFactory.getController().mConnectionController.isUpdated(brandId)) {
            this.clearText();
            controllerFactory.getController().sendMessage(this.mBrandIdProvider.getTargetId(), brandId, message, null);
            if (this.mEnterMessageListener != null) {
                this.mEnterMessageListener.onMessageSent();
            }
        } else {
            this.showNoNetworkMessage();
        }
    }

    protected void onHasText(boolean hasText) {
        if (this.voiceButtonEnabled) {
            if (hasText) {
                this.recordingControlsLayout.setVisibility(8);
            } else {
                this.recordingControlsLayout.setVisibility(0);
            }
        }
    }

    protected void onAfterChangedText(String text) {
        LPLog.INSTANCE.d(TAG, "onAfterChangedText: Consumer changed text. Clearing all pending runnables and set a new one");
        this.mHandler.removeCallbacksAndMessages(null);
        if (TextUtils.isEmpty((CharSequence)text)) {
            this.currentChatState = ChatState.ACTIVE;
            this.changeState(ChatState.ACTIVE);
        } else {
            this.mHandler.postDelayed(() -> {
                LPLog.INSTANCE.d(TAG, "onAfterChangedText: Setting state to 'Not Typing'");
                this.currentChatState = ChatState.ACTIVE;
                this.changeState(ChatState.ACTIVE);
            }, 2000L);
        }
    }

    protected void onBeforeChangedText() {
        LPLog.INSTANCE.d(TAG, "onBeforeChangedText: Remove all pending 'not typing' action");
        this.mHandler.removeCallbacksAndMessages(null);
        if (this.currentChatState != ChatState.COMPOSING) {
            LPLog.INSTANCE.d(TAG, "onBeforeChangedText: set the status to 'typing'");
            this.currentChatState = ChatState.COMPOSING;
            this.changeState(ChatState.COMPOSING);
        }
    }

    private void onRecordVoice() {
        if (this.isRecordingInProgress()) {
            return;
        }
        if (this.mMicTooltipWindow != null) {
            this.mMicTooltipWindow.enable(true);
        }
        String announcement = this.getResources().getString(R.string.lp_accessibility_voice_mic_activated, new Object[]{this.getMinutesLimit(), this.getSecondsLimit()});
        this.announceForAccessibility(announcement);
        this.recordingStatus = RecordingStatus.RECORDING;
        IntentFilter intentFilter = new IntentFilter("android.media.AUDIO_BECOMING_NOISY");
        this.getContext().registerReceiver((BroadcastReceiver)this.mDetectHeadsetUnpluggedBroadcastReceiver, intentFilter);
        MessagingFactory.getInstance().getController().getAudioUtils().getPlayingAudioManager().stopAllCurrentlyPlaying();
        this.vibrate();
        this.textInput.setEnabled(false);
        this.hideSoftKeyboard((View)this.textInput);
        this.updateEnterMessageView(true);
        this.animateRecordingIndicator();
        this.animateRecordProgress(this.mMaxRecordTimeMs);
        this.setDurationText(this.mMaxRecordTimeMs);
        MessagingFactory.getInstance().getController().getAudioUtils().startRecording(LPAudioUtils.generateVoiceFileName(), this.mMaxRecordTimeMs, new LPAudioUtils.RecordingResultCallback(){

            public void onMaxRecordingDurationReached(@Nullable String audioFilePath) {
                AmsEnterMessage.this.recordingStatus = RecordingStatus.MAX_REACHED;
                AmsEnterMessage.this.onRecordingTerminated(audioFilePath);
            }

            public void onRecordingInterrupted(@Nullable String audioFilePath) {
                if (AmsEnterMessage.this.recordingStatus == RecordingStatus.RECORDING) {
                    AmsEnterMessage.this.recordingStatus = RecordingStatus.PAUSED;
                    AmsEnterMessage.this.onRecordingTerminated(audioFilePath);
                }
            }
        });
    }

    private void onStopRecording(final boolean isSending, final @Nullable Runnable afterStopped) {
        if (this.recordingStatus == RecordingStatus.RECORDING) {
            this.getContext().unregisterReceiver((BroadcastReceiver)this.mDetectHeadsetUnpluggedBroadcastReceiver);
            MessagingFactory.getInstance().getController().getAudioUtils().stopRecording((ICallback)new ICallback<String, Exception>(){

                public void onSuccess(String filename) {
                    AmsEnterMessage.this.mPausedRecordingFilePath = filename;
                    AmsEnterMessage.this.recordingStatus = RecordingStatus.PAUSED;
                    AmsEnterMessage.this.stopRecordProgressBarAnimation();
                    if (afterStopped != null) {
                        afterStopped.run();
                    } else {
                        AmsEnterMessage.this.updateEnterMessageView(true);
                    }
                    LPAudioUtils.getDuration((String)filename, (ICallback)new ICallback<Integer, Exception>(){

                        public void onSuccess(Integer duration) {
                            if (!isSending) {
                                AmsEnterMessage.this.mRecordProgressTimeTextView.setText((CharSequence)DateUtils.getDurationString((long)duration.intValue()));
                                AmsEnterMessage.this.announceForAccessibility(String.format(AmsEnterMessage.this.getResources().getString(R.string.lp_accessibility_voice_stop_recording_activated), TimeUnit.MILLISECONDS.toMinutes(duration.intValue()) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(duration.intValue())), TimeUnit.MILLISECONDS.toSeconds(duration.intValue()) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(duration.intValue()))));
                            }
                        }

                        public void onError(Exception exception) {
                        }
                    });
                }

                public void onError(Exception exception) {
                    LPLog.INSTANCE.d(AmsEnterMessage.TAG, "voice recording failed to stop", (Throwable)exception);
                }
            });
        }
    }

    private void onRecordingTerminated(@Nullable String audioFilePath) {
        this.mPausedRecordingFilePath = audioFilePath;
        this.stopRecordingIndicatorAnimation();
        this.updateEnterMessageView(true);
        if (this.recordingStatus == RecordingStatus.MAX_REACHED) {
            String mMaxRecordingReachedString = this.getResources().getString(R.string.lp_accessibility_voice_recording_limit_reached);
            AccessibilityManager am = (AccessibilityManager)this.getContext().getSystemService("accessibility");
            if (!am.isEnabled()) {
                this.mMicTooltipWindow.showToolTip((View)this.voiceControlButton, mMaxRecordingReachedString, true);
            }
            this.announceForAccessibility(mMaxRecordingReachedString);
        }
    }

    private void onPlayBackRecording() {
        if (!(this.recordingStatus != RecordingStatus.MAX_REACHED && this.recordingStatus != RecordingStatus.PAUSED || Strings.isEmptyOrWhitespace((String)this.mPausedRecordingFilePath))) {
            MessagingFactory.getInstance().getController().getAudioUtils().getPlayingAudioManager().stopAllCurrentlyPlaying();
            MessagingFactory.getInstance().getController().getAudioUtils().playAudio(this.mPausedRecordingFilePath, TAG, new LPAudioUtils.PlaybackCallback(){

                public void onPlaybackStarted(String audioFileUrl, int durationMilliseconds) {
                    AmsEnterMessage.this.recordingStatus = RecordingStatus.PLAYING;
                    AmsEnterMessage.this.setDurationText(durationMilliseconds);
                    AmsEnterMessage.this.animateRecordProgress(durationMilliseconds);
                    AmsEnterMessage.this.updateEnterMessageView(true);
                }

                public void onPlaybackCompleted(boolean successfully, String audioFileUrl) {
                    AmsEnterMessage.this.stopRecordProgressBarAnimation();
                    AmsEnterMessage.this.recordingStatus = RecordingStatus.PAUSED;
                    AmsEnterMessage.this.updateEnterMessageView(true);
                }
            });
        }
    }

    private void onStopPlayback(boolean isSending, @Nullable Runnable afterStopped) {
        if (this.recordingStatus == RecordingStatus.PLAYING) {
            MessagingFactory.getInstance().getController().getAudioUtils().stopPlayback();
            this.recordingStatus = RecordingStatus.PAUSED;
            this.stopRecordProgressBarAnimation();
            if (afterStopped != null) {
                afterStopped.run();
            } else {
                this.updateEnterMessageView(true);
            }
            if (!isSending) {
                this.announceForAccessibility(this.getResources().getString(R.string.lp_accessibility_voice_stop_replay_activated));
            }
        }
    }

    private void onCancelRecording() {
        switch (this.recordingStatus) {
            case RECORDING: {
                this.onStopRecording(false, this::deleteRecording);
                break;
            }
            case PLAYING: {
                this.onStopPlayback(false, this::deleteRecording);
                break;
            }
            default: {
                this.deleteRecording();
            }
        }
        this.textInput.setEnabled(true);
        this.announceForAccessibility(this.getResources().getString(R.string.lp_accessibility_voice_trash_activated));
    }

    protected void sendMessage() {
        switch (this.recordingStatus) {
            case RECORDING: {
                this.onStopRecording(true, this::uploadRecording);
                break;
            }
            case PLAYING: {
                this.onStopPlayback(true, this::uploadRecording);
                break;
            }
            case PAUSED: 
            case MAX_REACHED: {
                this.uploadRecording();
                break;
            }
            default: {
                super.sendMessage();
            }
        }
        this.textInput.setEnabled(true);
    }

    private void deleteRecording() {
        boolean deleted = false;
        if (!Strings.isEmptyOrWhitespace((String)this.mPausedRecordingFilePath)) {
            File file = new File(this.mPausedRecordingFilePath);
            deleted = file.delete();
        }
        this.recordingStatus = RecordingStatus.STOPPED;
        LPLog.INSTANCE.d(TAG, "deleteRecording: file " + this.mPausedRecordingFilePath + (deleted ? " deleted" : " not deleted"));
        this.mPausedRecordingFilePath = null;
        this.updateEnterMessageView(false);
    }

    private void uploadRecording() {
        if (!Strings.isEmptyOrWhitespace((String)this.mPausedRecordingFilePath)) {
            MessagingFactory.getInstance().getController().sendFileMessage(FileSharingType.VOICE, this.mBrandIdProvider.getBrandId(), this.mBrandIdProvider.getTargetId(), this.mPausedRecordingFilePath, "", false);
        }
        this.recordingStatus = RecordingStatus.STOPPED;
        this.mPausedRecordingFilePath = null;
        this.updateEnterMessageView(false);
    }

    protected boolean isContentWaiting() {
        return this.recordingStatus != RecordingStatus.STOPPED || super.isContentWaiting();
    }

    private void updateEnterMessageView(boolean voiceWaiting) {
        this.updateSendButtonState();
        if (this.voiceControlButton != null) {
            switch (this.recordingStatus) {
                case PAUSED: 
                case MAX_REACHED: {
                    this.setVoiceControlAsReplayButton();
                    break;
                }
                case RECORDING: 
                case PLAYING: {
                    this.setVoiceControlAsStopButton();
                    break;
                }
                default: {
                    this.setVoiceControlAsMicButton();
                }
            }
            this.voiceControlButton.setVisibility(this.voiceButtonEnabled ? 0 : 8);
        }
        if (this.recordingStatus == RecordingStatus.STOPPED || this.recordingStatus == RecordingStatus.PAUSED) {
            this.stopRecordingIndicatorAnimation();
            this.stopRecordProgressBarAnimation();
        }
        if (voiceWaiting && this.mEnterMessageLayoutSwitcher.getNextView() == this.recordVoiceLayout || !voiceWaiting && this.mEnterMessageLayoutSwitcher.getNextView() == this.enterMessageLayout) {
            this.mEnterMessageLayoutSwitcher.showNext();
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void setVoiceControlAsMicButton() {
        this.voiceControlButton.setImageResource(R.drawable.lpinfra_ui_ic_mic);
        this.voiceControlButton.setColorFilter(ContextCompat.getColor((Context)this.getContext(), (int)R.color.lp_voice_record_button_color), PorterDuff.Mode.MULTIPLY);
        this.voiceControlButton.setOnClickListener(view -> {
            if (this.mEnterMessageListener != null) {
                this.mEnterMessageListener.onVoiceRecordingPermissionRequired(new IPermissionCallback(){

                    public void onPermissionsGranted() {
                        if (!AmsEnterMessage.this.isRecordingInProgress()) {
                            String longPressToRecordString = AmsEnterMessage.this.getResources().getString(R.string.lp_mic_tooltip_long_press);
                            AccessibilityManager am = (AccessibilityManager)AmsEnterMessage.this.getContext().getSystemService("accessibility");
                            if (!am.isEnabled()) {
                                AmsEnterMessage.this.mMicTooltipWindow.showToolTip((View)AmsEnterMessage.this.voiceControlButton, longPressToRecordString);
                            }
                            AmsEnterMessage.this.announceForAccessibility(longPressToRecordString);
                        }
                    }

                    public void onPermissionsDenied() {
                        LPLog.INSTANCE.w(AmsEnterMessage.TAG, "onPermissionsDenied: Record voice permissions denied by user");
                    }
                });
            }
        });
        this.voiceControlButton.setOnLongClickListener(view -> {
            if (this.mEnterMessageListener != null) {
                this.mEnterMessageListener.onVoiceRecordingPermissionRequired(new IPermissionCallback(){

                    public void onPermissionsGranted() {
                        AmsEnterMessage.this.onRecordVoice();
                    }

                    public void onPermissionsDenied() {
                        LPLog.INSTANCE.w(AmsEnterMessage.TAG, "onPermissionsDenied: Record voice permissions denied by user");
                    }
                });
                return true;
            }
            return false;
        });
        this.voiceControlButton.setOnTouchListener((v, event) -> {
            switch (event.getAction()) {
                case 0: {
                    AccessibilityManager am = (AccessibilityManager)this.getContext().getSystemService("accessibility");
                    if (this.isRecordingInProgress() || am.isEnabled()) break;
                    int micLongPressDelayForTooltip = this.getResources().getInteger(R.integer.lp_mic_tooltip_long_press_delay_ms);
                    this.handler.sendEmptyMessageDelayed(117, (long)micLongPressDelayForTooltip);
                    break;
                }
                case 1: {
                    this.handler.removeMessages(117);
                    this.mMicTooltipWindow.dismissTooltip();
                }
            }
            return false;
        });
        this.voiceControlButton.setContentDescription((CharSequence)String.format(this.getResources().getString(R.string.lp_accessibility_voice_mic_button), this.getMinutesLimit(), this.getSecondsLimit()));
        ViewCompat.setAccessibilityDelegate((View)this.voiceControlButton, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

            public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat info) {
                super.onInitializeAccessibilityNodeInfo(host, info);
                info.setClassName(null);
            }

            public void onPopulateAccessibilityEvent(View host, AccessibilityEvent event) {
                super.onPopulateAccessibilityEvent(host, event);
                host.setClickable(false);
                host.setLongClickable(true);
            }
        });
    }

    private long getMinutesLimit() {
        return TimeUnit.MILLISECONDS.toMinutes(this.mMaxRecordTimeMs) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(this.mMaxRecordTimeMs));
    }

    private long getSecondsLimit() {
        return TimeUnit.MILLISECONDS.toSeconds(this.mMaxRecordTimeMs) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(this.mMaxRecordTimeMs));
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void setVoiceControlAsStopButton() {
        this.voiceControlButton.setImageResource(R.drawable.lpinfra_ui_ic_stop);
        this.voiceControlButton.setColorFilter(ContextCompat.getColor((Context)this.getContext(), (int)R.color.lp_voice_stop_button_color), PorterDuff.Mode.MULTIPLY);
        if (this.recordingStatus == RecordingStatus.RECORDING) {
            this.voiceControlButton.setOnClickListener(v -> this.onStopRecording(false, null));
            this.voiceControlButton.setContentDescription((CharSequence)this.getResources().getString(R.string.lp_accessibility_voice_stop_recording_button));
        } else {
            this.voiceControlButton.setOnClickListener(v -> this.onStopPlayback(false, null));
            this.voiceControlButton.setContentDescription((CharSequence)this.getResources().getString(R.string.lp_accessibility_voice_stop_replay_button));
        }
        this.voiceControlButton.setOnLongClickListener(null);
        this.voiceControlButton.setOnTouchListener(null);
        ViewCompat.setAccessibilityDelegate((View)this.voiceControlButton, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

            public void onPopulateAccessibilityEvent(View host, AccessibilityEvent event) {
                super.onPopulateAccessibilityEvent(host, event);
                host.setClickable(true);
                host.setLongClickable(false);
            }
        });
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void setVoiceControlAsReplayButton() {
        this.voiceControlButton.setImageResource(R.drawable.lpinfra_ui_ic_replay);
        this.voiceControlButton.setColorFilter(ContextCompat.getColor((Context)this.getContext(), (int)R.color.lp_voice_replay_button_color), PorterDuff.Mode.MULTIPLY);
        this.voiceControlButton.setOnClickListener(v -> this.onPlayBackRecording());
        this.voiceControlButton.setContentDescription((CharSequence)this.getResources().getString(R.string.lp_accessibility_voice_replay_button));
        this.voiceControlButton.setOnLongClickListener(null);
        this.voiceControlButton.setOnTouchListener(null);
        ViewCompat.setAccessibilityDelegate((View)this.voiceControlButton, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

            public void onPopulateAccessibilityEvent(View host, AccessibilityEvent event) {
                super.onPopulateAccessibilityEvent(host, event);
                host.setClickable(true);
                host.setLongClickable(false);
            }
        });
    }

    protected boolean shouldUpdateSendButton() {
        return true;
    }

    private void vibrate() {
        if (this.getContext().checkCallingOrSelfPermission("android.permission.VIBRATE") == 0) {
            Vibrator v = (Vibrator)this.getContext().getSystemService("vibrator");
            v.vibrate((long)Configuration.getInteger((int)R.integer.lp_on_recording_max_time_vibrate_ms));
        }
    }

    protected void changeState(ChatState state) {
        boolean isInitialized = MessagingUIFactory.getInstance().isInitialized();
        if (isInitialized) {
            MessagingFactory.getInstance().getController().changeChatState(this.mBrandIdProvider.getTargetId(), this.mBrandIdProvider.getBrandId(), state);
        }
    }

    private void animateRecordingIndicator() {
        if (this.recordingIndicator != null) {
            this.mColorAnim = ObjectAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            this.mColorAnim.addUpdateListener(this::onRecordingIndicatorAnimationUpdate);
            this.mColorAnim.setDuration(1000L);
            this.mColorAnim.setRepeatMode(2);
            this.mColorAnim.setRepeatCount(-1);
            this.mColorAnim.start();
            this.recordingIndicator.setVisibility(0);
        }
    }

    private void onRecordingIndicatorAnimationUpdate(ValueAnimator animation) {
        if (this.recordingIndicator != null) {
            int red = this.getResources().getColor(0x1060016);
            float mul = ((Float)animation.getAnimatedValue()).floatValue();
            int alphaRed = this.adjustAlpha(red, mul);
            this.recordingIndicator.setColorFilter(alphaRed, PorterDuff.Mode.SRC_IN);
            if ((double)mul == 0.0) {
                this.recordingIndicator.setColorFilter(null);
            }
        }
    }

    private void animateRecordProgress(int durationMs) {
        if (this.mRecordProgressBar != null && this.mRecordProgressTimeTextView != null) {
            this.mRecordProgressBarAnimator = ValueAnimator.ofInt((int[])new int[]{0, durationMs});
            this.mRecordProgressBarAnimator.setDuration((long)durationMs);
            this.mRecordProgressBarAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            this.mRecordProgressBar.setMax(durationMs);
            this.mRecordProgressBarAnimator.addUpdateListener(valueAnimator -> {
                this.mRecordProgressBar.setProgress(((Integer)valueAnimator.getAnimatedValue()).intValue());
                this.mRecordProgressTimeTextView.setText((CharSequence)DateUtils.getDurationString((long)valueAnimator.getCurrentPlayTime()));
            });
            this.mRecordProgressBarAnimator.start();
        }
    }

    private void setDurationText(int durationMs) {
        if (this.mMaxRecordTimeTextView != null) {
            this.mMaxRecordTimeTextView.setText((CharSequence)DateUtils.getDurationString((long)durationMs));
        }
    }

    private void stopRecordProgressBarAnimation() {
        if (this.mRecordProgressBarAnimator != null) {
            this.mRecordProgressBarAnimator.cancel();
        }
    }

    private void stopRecordingIndicatorAnimation() {
        if (this.recordingIndicator != null) {
            this.recordingIndicator.setVisibility(8);
            if (this.mColorAnim != null) {
                this.mColorAnim.cancel();
                this.recordingIndicator.setColorFilter(null);
                this.mColorAnim = null;
            }
        }
    }

    protected boolean isRecordingInProgress() {
        return this.recordingStatus != RecordingStatus.STOPPED;
    }

    private int adjustAlpha(int color2, float factor) {
        int alpha = Math.round((float)Color.alpha((int)color2) * factor);
        int red = Color.red((int)color2);
        int green = Color.green((int)color2);
        int blue = Color.blue((int)color2);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    private static enum RecordingStatus {
        STOPPED,
        MAX_REACHED,
        RECORDING,
        PAUSED,
        PLAYING;

    }
}

