/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.fragment;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.BoolRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.Fragment;
import com.liveperson.api.response.types.DeliveryStatus;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.fragment.NestedFragmentsContainerCallbacks;
import com.liveperson.infra.messaging_ui.uicomponents.MessagingUIUtils;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.model.Form;
import org.json.JSONException;
import org.json.JSONObject;

public class SecuredFormFragment
extends Fragment {
    public static final String TAG = "SecuredFormFragment";
    public static final String JS_INTERFACE_OBJ_NAME = "android";
    public static final String STATE = "state";
    public static final String VIEWED = "viewed";
    public static final String SUBMIT = "submit";
    public static final String TOKEN = "token";
    public static final String ERROR = "error";
    public static final String URL = "url";
    public static final String INVITATION_ID = "invitation_id";
    public static final String FORM_TITLE = "form_title";
    public static final String ABORTED = "aborted";
    private String mUrl;
    private String mInvitationId;
    private String mFormTitle;
    private WebView mWebView;
    private NestedFragmentsContainerCallbacks mNestedFragmentsContainerCallbacks;
    private String webFormState = null;
    private int mOldOrientation = -1;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        LPLog.INSTANCE.d(TAG, "On Create");
        if (this.getArguments() != null) {
            this.mUrl = this.getArguments().getString(URL);
            this.mInvitationId = this.getArguments().getString(INVITATION_ID);
            this.mFormTitle = this.getArguments().getString(FORM_TITLE);
        }
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        LPLog.INSTANCE.d(TAG, "onActivityCreated");
        this.mNestedFragmentsContainerCallbacks.setSecureFormMode(true, this.mFormTitle);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (this.getParentFragment() instanceof NestedFragmentsContainerCallbacks) {
            this.mNestedFragmentsContainerCallbacks = (NestedFragmentsContainerCallbacks)this.getParentFragment();
            return;
        }
        this.mNestedFragmentsContainerCallbacks = new NestedFragmentsContainerCallbacks.NullNestedFragmentsContainerCallbacks();
    }

    public void onStart() {
        super.onStart();
        this.holdCurrentOrientation();
    }

    private void holdCurrentOrientation() {
        android.content.res.Configuration config = this.getResources().getConfiguration();
        int orientation = config.orientation;
        LPLog.INSTANCE.d(TAG, "holdCurrentOrientation: config = " + (orientation == 1 ? "Configuration.ORIENTATION_PORTRAIT" : "Configuration.ORIENTATION_LANDSCAPE"));
        LPLog.INSTANCE.d(TAG, "holdCurrentOrientation: old orientation = " + this.requireActivity().getRequestedOrientation());
        if (this.mOldOrientation == -1) {
            this.mOldOrientation = this.requireActivity().getRequestedOrientation();
        }
        LPLog.INSTANCE.d(TAG, "holdCurrentOrientation: Getting old orientation: " + this.mOldOrientation);
        if (orientation == 1) {
            this.requireActivity().setRequestedOrientation(1);
        } else if (orientation == 2) {
            this.requireActivity().setRequestedOrientation(0);
        }
    }

    private void restoreOriginalOrientation() {
        LPLog.INSTANCE.d(TAG, "restoreOriginalOrientation: oldOrientation = " + this.mOldOrientation);
        this.requireActivity().setRequestedOrientation(this.mOldOrientation);
    }

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);
        LPLog.INSTANCE.d(TAG, "onActivityCreated");
        View layoutScreen = inflater.inflate(R.layout.lpmessaging_ui_form_layout, container, false);
        this.mWebView = (WebView)layoutScreen.findViewById(R.id.lpmessaging_ui_webview);
        this.mUrl = this.getArguments().getString(URL);
        LPLog.INSTANCE.d(TAG, "Url = " + this.mUrl);
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        if (Build.VERSION.SDK_INT > 28) {
            if (this.getRuntimeConfiguration(R.bool.isDarkModeOn) && this.getRuntimeConfiguration(R.bool.darkMode_force_enable_for_webView)) {
                this.mWebView.getSettings().setForceDark(2);
            } else {
                this.mWebView.getSettings().setForceDark(0);
            }
        }
        this.mWebView.addJavascriptInterface((Object)new WebAppInterface(), JS_INTERFACE_OBJ_NAME);
        this.mWebView.setWebViewClient(new WebViewClient(){

            public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
                super.onReceivedHttpError(view, request, errorResponse);
                LPLog.INSTANCE.i(SecuredFormFragment.TAG, "PCI receive http error: " + errorResponse);
            }

            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                LPLog.INSTANCE.i(SecuredFormFragment.TAG, "PCI receive  error: " + error);
            }

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                LPLog.INSTANCE.i(SecuredFormFragment.TAG, "PCI receive  redirect: " + url);
                return false;
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                LPLog.INSTANCE.d(SecuredFormFragment.TAG, "onPageFinished sdk - " + Build.VERSION.SDK_INT);
                if (Build.VERSION.SDK_INT >= 19) {
                    SecuredFormFragment.this.mWebView.evaluateJavascript("(function() { return ('<html>'+document.getElementsByTagName('html')[0].innerHTML+'</html>'); })();", html -> LPLog.INSTANCE.d(SecuredFormFragment.TAG, "HTML=" + html));
                }
            }
        });
        this.mWebView.loadUrl(this.mUrl);
        layoutScreen.setOnClickListener(view -> {});
        return layoutScreen;
    }

    private void changeFormStateViewed() {
        MessagingFactory.getInstance().getController().amsMessages.mFormsManager.getForm(this.mInvitationId).setFormStatus(Form.FormStatus.VIEWED);
        MessagingFactory.getInstance().getController().amsMessages.setDeliveryStatusUpdateCommand(MessagingFactory.getInstance().getController().amsMessages.mFormsManager.getForm(this.mInvitationId), DeliveryStatus.VIEWED);
    }

    public void slideOutSecureFormFragment() {
        this.requireActivity().runOnUiThread(() -> {
            this.restoreOriginalOrientation();
            this.mNestedFragmentsContainerCallbacks.slideOutSecureFormFragment();
        });
    }

    public boolean slideOutFragment() {
        AlertDialog alertDialog = new AlertDialog.Builder(this.requireContext(), R.style.LpAlertDialogCustom).create();
        alertDialog.setCustomTitle((View)MessagingUIUtils.prepareDialogTitle((Context)this.getActivity(), R.string.lpmessaging_ui_pci_leave_dialog_title));
        alertDialog.setMessage((CharSequence)this.getString(R.string.lpmessaging_ui_pci_leave_dialog_description));
        alertDialog.setButton(-3, (CharSequence)this.getString(R.string.lpmessaging_ui_pci_leave_dialog_btn_positive), (dialog, which) -> {
            dialog.dismiss();
            if (this.webFormState == null) {
                this.changeFormStateViewed();
            }
            this.slideOutSecureFormFragment();
        });
        alertDialog.setButton(-2, (CharSequence)this.getString(R.string.lpmessaging_ui_pci_leave_dialog_btn_negative), (dialog, which) -> dialog.dismiss());
        alertDialog.show();
        return true;
    }

    private boolean getRuntimeConfiguration(@BoolRes int boolResId) {
        return Configuration.getBoolean((int)boolResId);
    }

    private class WebAppInterface {
        private static final String TAG = "WebAppInterface";

        private WebAppInterface() {
        }

        @JavascriptInterface
        public void onPCIMessage(String state) {
            try {
                JSONObject jo = new JSONObject(state);
                SecuredFormFragment.this.webFormState = jo.getString(SecuredFormFragment.STATE);
                LPLog.INSTANCE.d(TAG, "the state is: " + SecuredFormFragment.this.webFormState);
                if (SecuredFormFragment.this.webFormState.equalsIgnoreCase(SecuredFormFragment.VIEWED)) {
                    SecuredFormFragment.this.changeFormStateViewed();
                } else if (SecuredFormFragment.this.webFormState.equalsIgnoreCase(SecuredFormFragment.SUBMIT)) {
                    String token = jo.getString(SecuredFormFragment.TOKEN);
                    MessagingFactory.getInstance().getController().amsMessages.mFormsManager.getForm(SecuredFormFragment.this.mInvitationId).setSubmissionId(token);
                    MessagingFactory.getInstance().getController().sendFormSubmissionMessageCommand(SecuredFormFragment.this.mInvitationId);
                    SecuredFormFragment.this.slideOutSecureFormFragment();
                } else if (SecuredFormFragment.this.webFormState.equalsIgnoreCase(SecuredFormFragment.ERROR)) {
                    MessagingFactory.getInstance().getController().amsMessages.mFormsManager.getForm(SecuredFormFragment.this.mInvitationId).setFormStatus(Form.FormStatus.ERROR);
                    MessagingFactory.getInstance().getController().amsMessages.setDeliveryStatusUpdateCommand(MessagingFactory.getInstance().getController().amsMessages.mFormsManager.getForm(SecuredFormFragment.this.mInvitationId), DeliveryStatus.ERROR);
                    SecuredFormFragment.this.slideOutFragment();
                } else if (SecuredFormFragment.this.webFormState.equalsIgnoreCase(SecuredFormFragment.ABORTED)) {
                    MessagingFactory.getInstance().getController().amsMessages.mFormsManager.getForm(SecuredFormFragment.this.mInvitationId).setFormStatus(Form.FormStatus.ABORTED);
                    MessagingFactory.getInstance().getController().amsMessages.setDeliveryStatusUpdateCommand(MessagingFactory.getInstance().getController().amsMessages.mFormsManager.getForm(SecuredFormFragment.this.mInvitationId), DeliveryStatus.ABORTED);
                    SecuredFormFragment.this.slideOutFragment();
                } else {
                    LPLog.INSTANCE.w(TAG, "Couldn't parse the response");
                    SecuredFormFragment.this.slideOutFragment();
                }
            }
            catch (JSONException e) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000E6, "Exception while parsing json.", (Throwable)e);
            }
        }
    }
}

