/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.fragment;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieManager;
import android.webkit.PermissionRequest;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import com.liveperson.infra.LocalBroadcastReceiver;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.fragment.NestedFragmentsContainerCallbacks;
import com.liveperson.messaging.background.CoBrowseManager;
import com.liveperson.messaging.model.CoBrowseMetadata;

public class CobrowseFragment
extends Fragment {
    public static final String TAG = "CobrowseFragment";
    public static final String URL = "url";
    public static final String JOIN = "join";
    public static final String ACTION = "action";
    public static final String DIALOG_ID = "dialogId";
    public static final String FRAGMENT_DIALOG = "dialog";
    private static final int MY_PERMISSIONS_REQUEST_RECORD_AUDIO = 101;
    private static final int MY_PERMISSIONS_REQUEST_CAMERA = 102;
    private String mUrl;
    private String mDialogId;
    private WebView mWebView;
    private PermissionRequest myRequest;
    private LocalBroadcastReceiver mCobrowseReceivedReceiver;
    private NestedFragmentsContainerCallbacks mNestedFragmentsContainerCallbacks;
    private int mOldOrientation = -1;

    public static CobrowseFragment newInstance(String url, String dialogId) {
        Bundle bundle = new Bundle();
        bundle.putString(DIALOG_ID, dialogId);
        bundle.putString(URL, url);
        CobrowseFragment cobrowseFragment = new CobrowseFragment();
        cobrowseFragment.setArguments(bundle);
        return cobrowseFragment;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.mUrl = this.getArguments().getString(URL);
            this.mDialogId = this.getArguments().getString(DIALOG_ID);
        }
    }

    public void onResume() {
        super.onResume();
        this.registerCobrowseReceivedReceiver();
    }

    protected void registerCobrowseReceivedReceiver() {
        if (this.mCobrowseReceivedReceiver == null) {
            LPLog.INSTANCE.d(TAG, "CoBrowseLogic cobrowsefragment registerCobrowseReceivedReceiver");
            this.mCobrowseReceivedReceiver = new LocalBroadcastReceiver.Builder().addAction("BROADCAST_COBROWSE_RECEIVED").build((context, intent) -> {
                String dialogId = intent.getStringExtra(DIALOG_ID);
                String brandId = intent.getStringExtra("brandId");
                if (this.mDialogId.equals(dialogId)) {
                    CoBrowseMetadata metadata = CoBrowseManager.instance.getMetadata(brandId, dialogId);
                    LPLog.INSTANCE.d(TAG, "CoBrowseLogic cobrowsefragment registerCobrowseReceivedReceiver brandId: " + brandId + " callback " + dialogId + "   mDialogId:" + this.mDialogId + "   metdata: " + (metadata != null));
                    if (metadata != null && !metadata.isJoinable()) {
                        this.slideOutCobrowseFragment();
                    }
                }
            });
        } else {
            this.mCobrowseReceivedReceiver.register();
        }
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.mNestedFragmentsContainerCallbacks.setCobrowseMode(true);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (this.getParentFragment() instanceof NestedFragmentsContainerCallbacks) {
            this.mNestedFragmentsContainerCallbacks = (NestedFragmentsContainerCallbacks)this.getParentFragment();
            return;
        }
        this.mNestedFragmentsContainerCallbacks = new NestedFragmentsContainerCallbacks.NullNestedFragmentsContainerCallbacks();
    }

    public void onStart() {
        super.onStart();
        this.holdCurrentOrientation();
    }

    private void holdCurrentOrientation() {
        Configuration config = this.getResources().getConfiguration();
        int orientation = config.orientation;
        LPLog.INSTANCE.d(TAG, "holdCurrentOrientation: config = " + (orientation == 1 ? "Configuration.ORIENTATION_PORTRAIT" : "Configuration.ORIENTATION_LANDSCAPE"));
        LPLog.INSTANCE.d(TAG, "holdCurrentOrientation: old orientation = " + this.requireActivity().getRequestedOrientation());
        if (this.mOldOrientation == -1) {
            this.mOldOrientation = this.requireActivity().getRequestedOrientation();
        }
        LPLog.INSTANCE.d(TAG, "holdCurrentOrientation: Getting old orientation: " + this.mOldOrientation);
        if (orientation == 1) {
            this.requireActivity().setRequestedOrientation(1);
        } else if (orientation == 2) {
            this.requireActivity().setRequestedOrientation(0);
        }
    }

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);
        View layoutScreen = inflater.inflate(R.layout.lpmessaging_ui_cobrowse_layout, container, false);
        this.mWebView = (WebView)layoutScreen.findViewById(R.id.lpmessaging_ui_webview);
        this.mUrl = this.getArguments().getString(URL);
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.getSettings().setAllowFileAccessFromFileURLs(true);
        this.mWebView.getSettings().setMediaPlaybackRequiresUserGesture(false);
        this.mWebView.getSettings().setAllowUniversalAccessFromFileURLs(true);
        this.mWebView.setWebChromeClient(new WebChromeClient(){

            public void onPermissionRequest(PermissionRequest request) {
                if (CobrowseFragment.this.getContext() == null) {
                    return;
                }
                CobrowseFragment.this.myRequest = request;
                request.grant(request.getResources());
                block8: for (String permission2 : request.getResources()) {
                    LPLog.INSTANCE.i(CobrowseFragment.TAG, "onPermissionRequest " + permission2);
                    switch (permission2) {
                        case "android.webkit.resource.AUDIO_CAPTURE": {
                            if (CobrowseFragment.this.getContext().checkCallingOrSelfPermission("android.permission.RECORD_AUDIO") != 0) continue block8;
                            LPLog.INSTANCE.i(CobrowseFragment.TAG, "onPermissionRequest AUDIO_CAPTURE already GRANTED");
                            continue block8;
                        }
                        case "android.webkit.resource.VIDEO_CAPTURE": {
                            if (CobrowseFragment.this.getContext().checkCallingOrSelfPermission("android.permission.CAMERA") == 0) {
                                LPLog.INSTANCE.i(CobrowseFragment.TAG, "onPermissionRequest CAMERA already GRANTED");
                            }
                            if (CobrowseFragment.this.getContext().checkCallingOrSelfPermission("android.permission.READ_EXTERNAL_STORAGE") != 0) continue block8;
                            LPLog.INSTANCE.i(CobrowseFragment.TAG, "onPermissionRequest READ_EXTERNAL_STORAGE already GRANTED");
                        }
                    }
                }
            }

            public void onPermissionRequestCanceled(PermissionRequest request) {
                if (CobrowseFragment.this.getContext() == null) {
                    return;
                }
                CobrowseFragment.this.myRequest = null;
                DialogFragment fragment = (DialogFragment)CobrowseFragment.this.getChildFragmentManager().findFragmentByTag(CobrowseFragment.FRAGMENT_DIALOG);
                if (null != fragment) {
                    fragment.dismiss();
                }
            }
        });
        this.mWebView.setWebViewClient(new WebViewClient(){

            public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
                super.onReceivedHttpError(view, request, errorResponse);
                LPLog.INSTANCE.i(CobrowseFragment.TAG, "PCI receive http error: " + errorResponse);
            }

            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                LPLog.INSTANCE.i(CobrowseFragment.TAG, "PCI receive  error: " + error);
            }

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                LPLog.INSTANCE.i(CobrowseFragment.TAG, "PCI receive  redirect: " + url);
                return false;
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                LPLog.INSTANCE.d(CobrowseFragment.TAG, "onPageFinished sdk - " + Build.VERSION.SDK_INT);
                if (Build.VERSION.SDK_INT >= 19) {
                    CobrowseFragment.this.mWebView.evaluateJavascript("(function() { return ('<html>'+document.getElementsByTagName('html')[0].innerHTML+'</html>'); })();", html -> LPLog.INSTANCE.d("HTML", html));
                }
            }
        });
        CookieManager cookieManager = CookieManager.getInstance();
        cookieManager.setAcceptThirdPartyCookies(this.mWebView, true);
        this.mWebView.loadUrl(this.mUrl);
        layoutScreen.setOnClickListener(view -> {});
        return layoutScreen;
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        switch (requestCode) {
            case 101: {
                LPLog.INSTANCE.d(TAG, "onPermissionRequest PERMISSION FOR AUDIO");
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    this.myRequest.grant(this.myRequest.getResources());
                    this.mWebView.loadUrl(this.mUrl);
                }
            }
            case 102: {
                LPLog.INSTANCE.d(TAG, "onPermissionRequest PERMISSION FOR CAMERA");
                if (grantResults.length <= 0 || grantResults[0] != 0) break;
                this.myRequest.grant(this.myRequest.getResources());
                this.mWebView.loadUrl(this.mUrl);
            }
        }
    }

    public boolean slideOutCobrowseFragment() {
        if (this.getParentFragment() != null) {
            this.mNestedFragmentsContainerCallbacks.slideOutCobrowseFragment();
        }
        return true;
    }

    public void onPause() {
        super.onPause();
        if (this.mCobrowseReceivedReceiver != null) {
            this.mCobrowseReceivedReceiver.unregister();
        }
    }
}

