/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common.stats;

public class LongStats {
    private final int _count;
    private final double _average;
    private final double _standardDeviation;
    private final long _minimum;
    private final long _maximum;
    private final long _50Pct;
    private final long _90Pct;
    private final long _95Pct;
    private final long _99Pct;

    public LongStats() {
        this._count = 0;
        this._average = 0.0;
        this._standardDeviation = 0.0;
        this._minimum = 0L;
        this._maximum = 0L;
        this._50Pct = 0L;
        this._90Pct = 0L;
        this._95Pct = 0L;
        this._99Pct = 0L;
    }

    public LongStats(LongStats stats) {
        this._count = stats.getCount();
        this._average = stats.getAverage();
        this._standardDeviation = stats.getStandardDeviation();
        this._minimum = stats.getMinimum();
        this._maximum = stats.getMaximum();
        this._50Pct = stats.get50Pct();
        this._90Pct = stats.get90Pct();
        this._95Pct = stats.get95Pct();
        this._99Pct = stats.get99Pct();
    }

    public LongStats(int count, double average, double standardDeviation, long minimum, long maximum, long pct50, long pct90, long pct95, long pct99) {
        this._count = count;
        this._average = average;
        this._standardDeviation = standardDeviation;
        this._minimum = minimum;
        this._maximum = maximum;
        this._50Pct = pct50;
        this._90Pct = pct90;
        this._95Pct = pct95;
        this._99Pct = pct99;
    }

    public final int getCount() {
        return this._count;
    }

    public final double getAverage() {
        return this._average;
    }

    public final double getStandardDeviation() {
        return this._standardDeviation;
    }

    public final long getMinimum() {
        return this._minimum;
    }

    public final long getMaximum() {
        return this._maximum;
    }

    public final long get50Pct() {
        return this._50Pct;
    }

    public final long get90Pct() {
        return this._90Pct;
    }

    public final long get95Pct() {
        return this._95Pct;
    }

    public final long get99Pct() {
        return this._99Pct;
    }
}

