/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.thrift;

import com.google.common.util.concurrent.AbstractFuture;
import com.linecorp.armeria.common.annotation.Nullable;
import java.util.Objects;
import java.util.concurrent.CompletionException;
import org.apache.thrift.async.AsyncMethodCallback;

public final class ThriftListenableFuture<T>
extends AbstractFuture<T>
implements AsyncMethodCallback<T> {
    public static <T> ThriftListenableFuture<T> completedFuture(@Nullable T value) {
        ThriftListenableFuture<T> future = new ThriftListenableFuture<T>();
        future.onComplete(value);
        return future;
    }

    public static <T> ThriftListenableFuture<T> exceptionallyCompletedFuture(Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        ThriftListenableFuture<T> future = new ThriftListenableFuture<T>();
        future.onError(cause instanceof Exception ? (Exception)cause : new CompletionException(cause));
        return future;
    }

    public void onComplete(@Nullable T value) {
        this.set(value);
    }

    public void onError(Exception cause) {
        this.setException(cause);
    }
}

