/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.thrift;

import com.linecorp.armeria.client.AbstractClientOptionsBuilder;
import com.linecorp.armeria.client.ClientBuilderParams;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientOption;
import com.linecorp.armeria.client.ClientOptionValue;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.DecoratingHttpClientFunction;
import com.linecorp.armeria.client.DecoratingRpcClientFunction;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.RpcClient;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.redirect.RedirectConfig;
import com.linecorp.armeria.client.thrift.ThriftClientOptions;
import com.linecorp.armeria.common.RequestId;
import com.linecorp.armeria.common.Scheme;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.SuccessFunction;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.auth.AuthToken;
import com.linecorp.armeria.common.auth.BasicToken;
import com.linecorp.armeria.common.auth.OAuth1aToken;
import com.linecorp.armeria.common.auth.OAuth2Token;
import com.linecorp.armeria.common.thrift.ThriftSerializationFormats;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

@UnstableApi
public final class ThriftClientBuilder
extends AbstractClientOptionsBuilder {
    @Nullable
    private final EndpointGroup endpointGroup;
    @Nullable
    private URI uri;
    @Nullable
    private String path;
    private Scheme scheme;

    ThriftClientBuilder(URI uri) {
        Objects.requireNonNull(uri, "uri");
        Preconditions.checkArgument((uri.getScheme() != null ? 1 : 0) != 0, (String)"uri must have scheme: %s", (Object)uri);
        this.endpointGroup = null;
        this.uri = uri;
        this.scheme = Scheme.parse((String)uri.getScheme());
        this.validateOrSetSerializationFormat();
    }

    ThriftClientBuilder(Scheme scheme, EndpointGroup endpointGroup) {
        Objects.requireNonNull(scheme, "scheme");
        Objects.requireNonNull(endpointGroup, "endpointGroup");
        this.uri = null;
        this.scheme = scheme;
        this.validateOrSetSerializationFormat();
        this.endpointGroup = endpointGroup;
    }

    private void validateOrSetSerializationFormat() {
        if (this.scheme.serializationFormat() == SerializationFormat.NONE) {
            this.serializationFormat(ThriftSerializationFormats.BINARY);
        } else {
            ThriftClientBuilder.ensureThriftSerializationFormat(this.scheme.serializationFormat());
        }
    }

    public ThriftClientBuilder serializationFormat(SerializationFormat serializationFormat) {
        Objects.requireNonNull(serializationFormat, "serializationFormat");
        ThriftClientBuilder.ensureThriftSerializationFormat(serializationFormat);
        this.scheme = Scheme.of((SerializationFormat)serializationFormat, (SessionProtocol)this.scheme.sessionProtocol());
        if (this.uri != null) {
            String rawUri = this.uri.toString();
            this.uri = URI.create(this.scheme + rawUri.substring(rawUri.indexOf(58)));
        }
        return this;
    }

    private static void ensureThriftSerializationFormat(SerializationFormat serializationFormat) {
        Preconditions.checkArgument((boolean)ThriftSerializationFormats.isThrift(serializationFormat), (String)"serializationFormat: %s (expected: one of %s)", (Object)serializationFormat, ThriftSerializationFormats.values());
    }

    public ThriftClientBuilder path(String path) {
        Objects.requireNonNull(path, "path");
        Preconditions.checkArgument((!path.isEmpty() ? 1 : 0) != 0, (Object)"path is empty.");
        Preconditions.checkArgument((path.charAt(0) == '/' ? 1 : 0) != 0, (String)"path: %s (must start with '/')", (Object)path);
        this.path = path;
        return this;
    }

    public ThriftClientBuilder maxResponseStringLength(int maxResponseStringLength) {
        Preconditions.checkArgument((maxResponseStringLength >= 0 ? 1 : 0) != 0, (String)"maxResponseStringLength: %s (expected: >= 0)", (int)maxResponseStringLength);
        return this.option((ClientOptionValue)ThriftClientOptions.MAX_RESPONSE_STRING_LENGTH.newValue((Object)maxResponseStringLength));
    }

    public ThriftClientBuilder maxResponseContainerLength(int maxResponseContainerLength) {
        Preconditions.checkArgument((maxResponseContainerLength >= 0 ? 1 : 0) != 0, (String)"maxResponseContainerLength: %s (expected: >= 0)", (int)maxResponseContainerLength);
        return this.option((ClientOptionValue)ThriftClientOptions.MAX_RESPONSE_CONTAINER_LENGTH.newValue((Object)maxResponseContainerLength));
    }

    public <T> T build(Class<T> clientType) {
        Object client;
        Objects.requireNonNull(clientType, "clientType");
        ClientOptions options = this.buildOptions();
        ClientFactory factory = options.factory();
        URI uri = this.uri;
        if (uri != null) {
            if (this.path != null) {
                uri = uri.resolve(this.path);
            }
            client = factory.newClient(ClientBuilderParams.of((URI)uri, clientType, (ClientOptions)options));
        } else {
            assert (this.endpointGroup != null);
            client = factory.newClient(ClientBuilderParams.of((Scheme)this.scheme, (EndpointGroup)this.endpointGroup, (String)this.path, clientType, (ClientOptions)options));
        }
        Object cast = client;
        return (T)cast;
    }

    public ThriftClientBuilder options(ClientOptions options) {
        return (ThriftClientBuilder)super.options(options);
    }

    public ThriftClientBuilder options(ClientOptionValue<?> ... options) {
        return (ThriftClientBuilder)super.options(options);
    }

    public ThriftClientBuilder options(Iterable<ClientOptionValue<?>> options) {
        return (ThriftClientBuilder)super.options(options);
    }

    public <T> ThriftClientBuilder option(ClientOption<T> option, T value) {
        return (ThriftClientBuilder)super.option(option, value);
    }

    public <T> ThriftClientBuilder option(ClientOptionValue<T> optionValue) {
        return (ThriftClientBuilder)super.option(optionValue);
    }

    public ThriftClientBuilder factory(ClientFactory factory) {
        return (ThriftClientBuilder)super.factory(factory);
    }

    public ThriftClientBuilder writeTimeout(Duration writeTimeout) {
        return (ThriftClientBuilder)super.writeTimeout(writeTimeout);
    }

    public ThriftClientBuilder writeTimeoutMillis(long writeTimeoutMillis) {
        return (ThriftClientBuilder)super.writeTimeoutMillis(writeTimeoutMillis);
    }

    public ThriftClientBuilder responseTimeout(Duration responseTimeout) {
        return (ThriftClientBuilder)super.responseTimeout(responseTimeout);
    }

    public ThriftClientBuilder responseTimeoutMillis(long responseTimeoutMillis) {
        return (ThriftClientBuilder)super.responseTimeoutMillis(responseTimeoutMillis);
    }

    public ThriftClientBuilder maxResponseLength(long maxResponseLength) {
        return (ThriftClientBuilder)super.maxResponseLength(maxResponseLength);
    }

    public ThriftClientBuilder requestAutoAbortDelay(Duration delay) {
        return (ThriftClientBuilder)super.requestAutoAbortDelay(delay);
    }

    public ThriftClientBuilder requestAutoAbortDelayMillis(long delayMillis) {
        return (ThriftClientBuilder)super.requestAutoAbortDelayMillis(delayMillis);
    }

    public ThriftClientBuilder requestIdGenerator(Supplier<RequestId> requestIdGenerator) {
        return (ThriftClientBuilder)super.requestIdGenerator(requestIdGenerator);
    }

    public ThriftClientBuilder successFunction(SuccessFunction successFunction) {
        return (ThriftClientBuilder)super.successFunction(successFunction);
    }

    public ThriftClientBuilder endpointRemapper(Function<? super Endpoint, ? extends EndpointGroup> endpointRemapper) {
        return (ThriftClientBuilder)super.endpointRemapper(endpointRemapper);
    }

    public ThriftClientBuilder decorator(Function<? super HttpClient, ? extends HttpClient> decorator) {
        return (ThriftClientBuilder)super.decorator(decorator);
    }

    public ThriftClientBuilder decorator(DecoratingHttpClientFunction decorator) {
        return (ThriftClientBuilder)super.decorator(decorator);
    }

    public ThriftClientBuilder rpcDecorator(Function<? super RpcClient, ? extends RpcClient> decorator) {
        return (ThriftClientBuilder)super.rpcDecorator(decorator);
    }

    public ThriftClientBuilder rpcDecorator(DecoratingRpcClientFunction decorator) {
        return (ThriftClientBuilder)super.rpcDecorator(decorator);
    }

    public ThriftClientBuilder clearDecorators() {
        return (ThriftClientBuilder)super.clearDecorators();
    }

    public ThriftClientBuilder addHeader(CharSequence name, Object value) {
        return (ThriftClientBuilder)super.addHeader(name, value);
    }

    public ThriftClientBuilder addHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> headers) {
        return (ThriftClientBuilder)super.addHeaders(headers);
    }

    public ThriftClientBuilder setHeader(CharSequence name, Object value) {
        return (ThriftClientBuilder)super.setHeader(name, value);
    }

    public ThriftClientBuilder setHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> headers) {
        return (ThriftClientBuilder)super.setHeaders(headers);
    }

    public ThriftClientBuilder auth(BasicToken token) {
        return (ThriftClientBuilder)super.auth(token);
    }

    public ThriftClientBuilder auth(OAuth1aToken token) {
        return (ThriftClientBuilder)super.auth(token);
    }

    public ThriftClientBuilder auth(OAuth2Token token) {
        return (ThriftClientBuilder)super.auth(token);
    }

    public ThriftClientBuilder auth(AuthToken token) {
        return (ThriftClientBuilder)super.auth(token);
    }

    public ThriftClientBuilder followRedirects() {
        return (ThriftClientBuilder)super.followRedirects();
    }

    public ThriftClientBuilder followRedirects(RedirectConfig redirectConfig) {
        return (ThriftClientBuilder)super.followRedirects(redirectConfig);
    }

    public ThriftClientBuilder contextCustomizer(Consumer<? super ClientRequestContext> contextCustomizer) {
        return (ThriftClientBuilder)super.contextCustomizer(contextCustomizer);
    }
}

