/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.classic.spi.LoggingEvent;
import com.linecorp.armeria.common.annotation.Nullable;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.slf4j.Marker;
import org.slf4j.event.KeyValuePair;

final class LoggingEventWrapper
extends LoggingEvent {
    private final ILoggingEvent event;
    private final Map<String, String> mdcPropertyMap;
    @Nullable
    private final LoggerContextVO vo;

    LoggingEventWrapper(ILoggingEvent event, Map<String, String> mdcPropertyMap) {
        this.event = event;
        this.mdcPropertyMap = mdcPropertyMap;
        LoggerContextVO oldVo = event.getLoggerContextVO();
        this.vo = oldVo != null ? new LoggerContextVO(oldVo.getName(), mdcPropertyMap, oldVo.getBirthTime()) : null;
    }

    public Object[] getArgumentArray() {
        return this.event.getArgumentArray();
    }

    public Level getLevel() {
        return this.event.getLevel();
    }

    public String getLoggerName() {
        return this.event.getLoggerName();
    }

    public String getThreadName() {
        return this.event.getThreadName();
    }

    public IThrowableProxy getThrowableProxy() {
        return this.event.getThrowableProxy();
    }

    public void prepareForDeferredProcessing() {
        this.event.prepareForDeferredProcessing();
    }

    @Nullable
    public LoggerContextVO getLoggerContextVO() {
        return this.vo;
    }

    public String getMessage() {
        return this.event.getMessage();
    }

    public long getTimeStamp() {
        return this.event.getTimeStamp();
    }

    public Instant getInstant() {
        return this.event.getInstant();
    }

    public long getSequenceNumber() {
        return this.event.getSequenceNumber();
    }

    public StackTraceElement[] getCallerData() {
        return this.event.getCallerData();
    }

    public boolean hasCallerData() {
        return this.event.hasCallerData();
    }

    public Marker getMarker() {
        return this.event.getMarker();
    }

    public List<Marker> getMarkerList() {
        return this.event.getMarkerList();
    }

    public String getFormattedMessage() {
        return this.event.getFormattedMessage();
    }

    public Map<String, String> getMDCPropertyMap() {
        return this.mdcPropertyMap;
    }

    @Deprecated
    public Map<String, String> getMdc() {
        return this.event.getMDCPropertyMap();
    }

    public List<KeyValuePair> getKeyValuePairs() {
        return this.event.getKeyValuePairs();
    }

    public String toString() {
        return this.event.toString();
    }
}

