/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.initializer.util.internal.osgi.commands;

import com.liferay.commerce.initializer.util.CommerceOrderGenerator;
import com.liferay.commerce.initializer.util.CommerceShipmentGenerator;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.site.initializer.SiteInitializer;
import com.liferay.site.initializer.SiteInitializerRegistry;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"osgi.command.function=generateOrders", "osgi.command.function=generateShipments", "osgi.command.function=initializeSite", "osgi.command.scope=commerce"}, service={CommerceOSGiCommands.class})
public class CommerceOSGiCommands {
    @Reference
    private CommerceOrderGenerator _commerceOrderGenerator;
    @Reference
    private CommerceShipmentGenerator _commerceShipmentGenerator;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private PermissionCheckerFactory _permissionCheckerFactory;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private SiteInitializerRegistry _siteInitializerRegistry;
    @Reference
    private UserLocalService _userLocalService;

    public void generateOrders(long groupId, int ordersCount) {
        this._commerceOrderGenerator.generate(groupId, ordersCount);
    }

    public void generateShipments(long groupId, int shipmentsCount) throws Exception {
        this._commerceShipmentGenerator.generate(groupId, shipmentsCount);
    }

    public void initializeSite(long groupId, String key) throws Exception {
        Group group = this._groupLocalService.getGroup(groupId);
        Company company = this._companyLocalService.getCompanyById(group.getCompanyId());
        Role role = this._roleLocalService.fetchRole(company.getCompanyId(), "Administrator");
        List roleUsers = this._userLocalService.getRoleUsers(role.getRoleId());
        User user = (User)roleUsers.get(0);
        PermissionChecker permissionChecker = this._permissionCheckerFactory.create(user);
        PrincipalThreadLocal.setName((long)user.getUserId());
        PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        SiteInitializer siteInitializer = this._siteInitializerRegistry.getSiteInitializer(key);
        siteInitializer.initialize(groupId);
    }
}

