/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.initializer.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.ListTypeConstants;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.CountryService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={OrganizationImporter.class})
public class OrganizationImporter {
    @Reference
    private CountryService _countryService;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void importOrganizations(JSONArray jsonArray, long scopeGroupId, long userId) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(user.getCompanyId());
        serviceContext.setScopeGroupId(scopeGroupId);
        serviceContext.setUserId(userId);
        for (int i = 0; i < jsonArray.length(); ++i) {
            this._importOrganization(jsonArray.getJSONObject(i), 0L, serviceContext);
        }
    }

    private void _importOrganization(JSONObject jsonObject, long parentOrganizationId, ServiceContext serviceContext) throws PortalException {
        String name = jsonObject.getString("name");
        Organization organization = this._organizationLocalService.fetchOrganization(serviceContext.getCompanyId(), name);
        if (organization != null) {
            return;
        }
        String twoLetterISOCode = jsonObject.getString("twoLetterISOCode");
        Country country = this._countryService.getCountryByA2(serviceContext.getCompanyId(), twoLetterISOCode);
        organization = this._organizationLocalService.addOrganization(serviceContext.getUserId(), parentOrganizationId, name, "organization", 0L, country.getCountryId(), (long)ListTypeConstants.ORGANIZATION_STATUS_DEFAULT, "", false, serviceContext);
        JSONArray suborganizationsJSONArray = jsonObject.getJSONArray("suborganizations");
        if (suborganizationsJSONArray != null) {
            for (int i = 0; i < suborganizationsJSONArray.length(); ++i) {
                this._importOrganization(suborganizationsJSONArray.getJSONObject(i), organization.getOrganizationId(), serviceContext);
            }
        }
    }
}

