/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.sessions.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetSessionsRequest {
    private final Optional<Integer> page;
    private final Optional<Integer> limit;
    private final Optional<OffsetDateTime> fromTimestamp;
    private final Optional<OffsetDateTime> toTimestamp;
    private final Optional<String> environment;
    private final Map<String, Object> additionalProperties;

    private GetSessionsRequest(Optional<Integer> page, Optional<Integer> limit, Optional<OffsetDateTime> fromTimestamp, Optional<OffsetDateTime> toTimestamp, Optional<String> environment, Map<String, Object> additionalProperties) {
        this.page = page;
        this.limit = limit;
        this.fromTimestamp = fromTimestamp;
        this.toTimestamp = toTimestamp;
        this.environment = environment;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="page")
    public Optional<Integer> getPage() {
        return this.page;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="fromTimestamp")
    public Optional<OffsetDateTime> getFromTimestamp() {
        return this.fromTimestamp;
    }

    @JsonProperty(value="toTimestamp")
    public Optional<OffsetDateTime> getToTimestamp() {
        return this.toTimestamp;
    }

    @JsonProperty(value="environment")
    public Optional<String> getEnvironment() {
        return this.environment;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetSessionsRequest && this.equalTo((GetSessionsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetSessionsRequest other) {
        return this.page.equals(other.page) && this.limit.equals(other.limit) && this.fromTimestamp.equals(other.fromTimestamp) && this.toTimestamp.equals(other.toTimestamp) && this.environment.equals(other.environment);
    }

    public int hashCode() {
        return Objects.hash(this.page, this.limit, this.fromTimestamp, this.toTimestamp, this.environment);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Integer> page = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<OffsetDateTime> fromTimestamp = Optional.empty();
        private Optional<OffsetDateTime> toTimestamp = Optional.empty();
        private Optional<String> environment = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(GetSessionsRequest other) {
            this.page(other.getPage());
            this.limit(other.getLimit());
            this.fromTimestamp(other.getFromTimestamp());
            this.toTimestamp(other.getToTimestamp());
            this.environment(other.getEnvironment());
            return this;
        }

        @JsonSetter(value="page", nulls=Nulls.SKIP)
        public Builder page(Optional<Integer> page) {
            this.page = page;
            return this;
        }

        public Builder page(Integer page) {
            this.page = Optional.ofNullable(page);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value="fromTimestamp", nulls=Nulls.SKIP)
        public Builder fromTimestamp(Optional<OffsetDateTime> fromTimestamp) {
            this.fromTimestamp = fromTimestamp;
            return this;
        }

        public Builder fromTimestamp(OffsetDateTime fromTimestamp) {
            this.fromTimestamp = Optional.ofNullable(fromTimestamp);
            return this;
        }

        @JsonSetter(value="toTimestamp", nulls=Nulls.SKIP)
        public Builder toTimestamp(Optional<OffsetDateTime> toTimestamp) {
            this.toTimestamp = toTimestamp;
            return this;
        }

        public Builder toTimestamp(OffsetDateTime toTimestamp) {
            this.toTimestamp = Optional.ofNullable(toTimestamp);
            return this;
        }

        @JsonSetter(value="environment", nulls=Nulls.SKIP)
        public Builder environment(Optional<String> environment) {
            this.environment = environment;
            return this;
        }

        public Builder environment(String environment) {
            this.environment = Optional.ofNullable(environment);
            return this;
        }

        public GetSessionsRequest build() {
            return new GetSessionsRequest(this.page, this.limit, this.fromTimestamp, this.toTimestamp, this.environment, this.additionalProperties);
        }
    }
}

