/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.scoreconfigs.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.commons.types.ScoreConfig;
import com.langfuse.client.resources.utils.pagination.types.MetaResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ScoreConfigs {
    private final List<ScoreConfig> data;
    private final MetaResponse meta;
    private final Map<String, Object> additionalProperties;

    private ScoreConfigs(List<ScoreConfig> data, MetaResponse meta, Map<String, Object> additionalProperties) {
        this.data = data;
        this.meta = meta;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="data")
    public List<ScoreConfig> getData() {
        return this.data;
    }

    @JsonProperty(value="meta")
    public MetaResponse getMeta() {
        return this.meta;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ScoreConfigs && this.equalTo((ScoreConfigs)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ScoreConfigs other) {
        return this.data.equals(other.data) && this.meta.equals(other.meta);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.meta);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static MetaStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements MetaStage,
    _FinalStage {
        private MetaResponse meta;
        private List<ScoreConfig> data = new ArrayList<ScoreConfig>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ScoreConfigs other) {
            this.data(other.getData());
            this.meta(other.getMeta());
            return this;
        }

        @Override
        @JsonSetter(value="meta")
        public _FinalStage meta(@NotNull MetaResponse meta) {
            this.meta = Objects.requireNonNull(meta, "meta must not be null");
            return this;
        }

        @Override
        public _FinalStage addAllData(List<ScoreConfig> data) {
            this.data.addAll(data);
            return this;
        }

        @Override
        public _FinalStage addData(ScoreConfig data) {
            this.data.add(data);
            return this;
        }

        @Override
        @JsonSetter(value="data", nulls=Nulls.SKIP)
        public _FinalStage data(List<ScoreConfig> data) {
            this.data.clear();
            this.data.addAll(data);
            return this;
        }

        @Override
        public ScoreConfigs build() {
            return new ScoreConfigs(this.data, this.meta, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ScoreConfigs build();

        public _FinalStage data(List<ScoreConfig> var1);

        public _FinalStage addData(ScoreConfig var1);

        public _FinalStage addAllData(List<ScoreConfig> var1);
    }

    public static interface MetaStage {
        public _FinalStage meta(@NotNull MetaResponse var1);

        public Builder from(ScoreConfigs var1);
    }
}

