/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.scim.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.scim.types.ScimEmail;
import com.langfuse.client.resources.scim.types.ScimName;
import com.langfuse.client.resources.scim.types.UserMeta;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ScimUser {
    private final List<String> schemas;
    private final String id;
    private final String userName;
    private final ScimName name;
    private final List<ScimEmail> emails;
    private final UserMeta meta;
    private final Map<String, Object> additionalProperties;

    private ScimUser(List<String> schemas, String id, String userName, ScimName name, List<ScimEmail> emails, UserMeta meta, Map<String, Object> additionalProperties) {
        this.schemas = schemas;
        this.id = id;
        this.userName = userName;
        this.name = name;
        this.emails = emails;
        this.meta = meta;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schemas")
    public List<String> getSchemas() {
        return this.schemas;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="userName")
    public String getUserName() {
        return this.userName;
    }

    @JsonProperty(value="name")
    public ScimName getName() {
        return this.name;
    }

    @JsonProperty(value="emails")
    public List<ScimEmail> getEmails() {
        return this.emails;
    }

    @JsonProperty(value="meta")
    public UserMeta getMeta() {
        return this.meta;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ScimUser && this.equalTo((ScimUser)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ScimUser other) {
        return this.schemas.equals(other.schemas) && this.id.equals(other.id) && this.userName.equals(other.userName) && this.name.equals(other.name) && this.emails.equals(other.emails) && this.meta.equals(other.meta);
    }

    public int hashCode() {
        return Objects.hash(this.schemas, this.id, this.userName, this.name, this.emails, this.meta);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    UserNameStage,
    NameStage,
    MetaStage,
    _FinalStage {
        private String id;
        private String userName;
        private ScimName name;
        private UserMeta meta;
        private List<ScimEmail> emails = new ArrayList<ScimEmail>();
        private List<String> schemas = new ArrayList<String>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ScimUser other) {
            this.schemas(other.getSchemas());
            this.id(other.getId());
            this.userName(other.getUserName());
            this.name(other.getName());
            this.emails(other.getEmails());
            this.meta(other.getMeta());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public UserNameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="userName")
        public NameStage userName(@NotNull String userName) {
            this.userName = Objects.requireNonNull(userName, "userName must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public MetaStage name(@NotNull ScimName name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="meta")
        public _FinalStage meta(@NotNull UserMeta meta) {
            this.meta = Objects.requireNonNull(meta, "meta must not be null");
            return this;
        }

        @Override
        public _FinalStage addAllEmails(List<ScimEmail> emails) {
            this.emails.addAll(emails);
            return this;
        }

        @Override
        public _FinalStage addEmails(ScimEmail emails) {
            this.emails.add(emails);
            return this;
        }

        @Override
        @JsonSetter(value="emails", nulls=Nulls.SKIP)
        public _FinalStage emails(List<ScimEmail> emails) {
            this.emails.clear();
            this.emails.addAll(emails);
            return this;
        }

        @Override
        public _FinalStage addAllSchemas(List<String> schemas) {
            this.schemas.addAll(schemas);
            return this;
        }

        @Override
        public _FinalStage addSchemas(String schemas) {
            this.schemas.add(schemas);
            return this;
        }

        @Override
        @JsonSetter(value="schemas", nulls=Nulls.SKIP)
        public _FinalStage schemas(List<String> schemas) {
            this.schemas.clear();
            this.schemas.addAll(schemas);
            return this;
        }

        @Override
        public ScimUser build() {
            return new ScimUser(this.schemas, this.id, this.userName, this.name, this.emails, this.meta, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ScimUser build();

        public _FinalStage schemas(List<String> var1);

        public _FinalStage addSchemas(String var1);

        public _FinalStage addAllSchemas(List<String> var1);

        public _FinalStage emails(List<ScimEmail> var1);

        public _FinalStage addEmails(ScimEmail var1);

        public _FinalStage addAllEmails(List<ScimEmail> var1);
    }

    public static interface MetaStage {
        public _FinalStage meta(@NotNull UserMeta var1);
    }

    public static interface NameStage {
        public MetaStage name(@NotNull ScimName var1);
    }

    public static interface UserNameStage {
        public NameStage userName(@NotNull String var1);
    }

    public static interface IdStage {
        public UserNameStage id(@NotNull String var1);

        public Builder from(ScimUser var1);
    }
}

