/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.scim.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ScimEmail {
    private final boolean primary;
    private final String value;
    private final String type;
    private final Map<String, Object> additionalProperties;

    private ScimEmail(boolean primary, String value, String type, Map<String, Object> additionalProperties) {
        this.primary = primary;
        this.value = value;
        this.type = type;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="primary")
    public boolean getPrimary() {
        return this.primary;
    }

    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ScimEmail && this.equalTo((ScimEmail)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ScimEmail other) {
        return this.primary == other.primary && this.value.equals(other.value) && this.type.equals(other.type);
    }

    public int hashCode() {
        return Objects.hash(this.primary, this.value, this.type);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PrimaryStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PrimaryStage,
    ValueStage,
    TypeStage,
    _FinalStage {
        private boolean primary;
        private String value;
        private String type;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ScimEmail other) {
            this.primary(other.getPrimary());
            this.value(other.getValue());
            this.type(other.getType());
            return this;
        }

        @Override
        @JsonSetter(value="primary")
        public ValueStage primary(boolean primary) {
            this.primary = primary;
            return this;
        }

        @Override
        @JsonSetter(value="value")
        public TypeStage value(@NotNull String value) {
            this.value = Objects.requireNonNull(value, "value must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public _FinalStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        public ScimEmail build() {
            return new ScimEmail(this.primary, this.value, this.type, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ScimEmail build();
    }

    public static interface TypeStage {
        public _FinalStage type(@NotNull String var1);
    }

    public static interface ValueStage {
        public TypeStage value(@NotNull String var1);
    }

    public static interface PrimaryStage {
        public ValueStage primary(boolean var1);

        public Builder from(ScimEmail var1);
    }
}

