/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.scim.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ResourceMeta {
    private final String resourceType;
    private final String location;
    private final Map<String, Object> additionalProperties;

    private ResourceMeta(String resourceType, String location, Map<String, Object> additionalProperties) {
        this.resourceType = resourceType;
        this.location = location;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="resourceType")
    public String getResourceType() {
        return this.resourceType;
    }

    @JsonProperty(value="location")
    public String getLocation() {
        return this.location;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ResourceMeta && this.equalTo((ResourceMeta)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ResourceMeta other) {
        return this.resourceType.equals(other.resourceType) && this.location.equals(other.location);
    }

    public int hashCode() {
        return Objects.hash(this.resourceType, this.location);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ResourceTypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ResourceTypeStage,
    LocationStage,
    _FinalStage {
        private String resourceType;
        private String location;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ResourceMeta other) {
            this.resourceType(other.getResourceType());
            this.location(other.getLocation());
            return this;
        }

        @Override
        @JsonSetter(value="resourceType")
        public LocationStage resourceType(@NotNull String resourceType) {
            this.resourceType = Objects.requireNonNull(resourceType, "resourceType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="location")
        public _FinalStage location(@NotNull String location) {
            this.location = Objects.requireNonNull(location, "location must not be null");
            return this;
        }

        @Override
        public ResourceMeta build() {
            return new ResourceMeta(this.resourceType, this.location, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ResourceMeta build();
    }

    public static interface LocationStage {
        public _FinalStage location(@NotNull String var1);
    }

    public static interface ResourceTypeStage {
        public LocationStage resourceType(@NotNull String var1);

        public Builder from(ResourceMeta var1);
    }
}

