/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.scim.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class AuthenticationScheme {
    private final String name;
    private final String description;
    private final String specUri;
    private final String type;
    private final boolean primary;
    private final Map<String, Object> additionalProperties;

    private AuthenticationScheme(String name, String description, String specUri, String type, boolean primary, Map<String, Object> additionalProperties) {
        this.name = name;
        this.description = description;
        this.specUri = specUri;
        this.type = type;
        this.primary = primary;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="specUri")
    public String getSpecUri() {
        return this.specUri;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="primary")
    public boolean getPrimary() {
        return this.primary;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AuthenticationScheme && this.equalTo((AuthenticationScheme)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AuthenticationScheme other) {
        return this.name.equals(other.name) && this.description.equals(other.description) && this.specUri.equals(other.specUri) && this.type.equals(other.type) && this.primary == other.primary;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.specUri, this.type, this.primary);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    DescriptionStage,
    SpecUriStage,
    TypeStage,
    PrimaryStage,
    _FinalStage {
        private String name;
        private String description;
        private String specUri;
        private String type;
        private boolean primary;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(AuthenticationScheme other) {
            this.name(other.getName());
            this.description(other.getDescription());
            this.specUri(other.getSpecUri());
            this.type(other.getType());
            this.primary(other.getPrimary());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public DescriptionStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="description")
        public SpecUriStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="specUri")
        public TypeStage specUri(@NotNull String specUri) {
            this.specUri = Objects.requireNonNull(specUri, "specUri must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public PrimaryStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="primary")
        public _FinalStage primary(boolean primary) {
            this.primary = primary;
            return this;
        }

        @Override
        public AuthenticationScheme build() {
            return new AuthenticationScheme(this.name, this.description, this.specUri, this.type, this.primary, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public AuthenticationScheme build();
    }

    public static interface PrimaryStage {
        public _FinalStage primary(boolean var1);
    }

    public static interface TypeStage {
        public PrimaryStage type(@NotNull String var1);
    }

    public static interface SpecUriStage {
        public TypeStage specUri(@NotNull String var1);
    }

    public static interface DescriptionStage {
        public SpecUriStage description(@NotNull String var1);
    }

    public static interface NameStage {
        public DescriptionStage name(@NotNull String var1);

        public Builder from(AuthenticationScheme var1);
    }
}

