/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.projects.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Project {
    private final String id;
    private final String name;
    private final Map<String, Object> metadata;
    private final Optional<Integer> retentionDays;
    private final Map<String, Object> additionalProperties;

    private Project(String id, String name, Map<String, Object> metadata, Optional<Integer> retentionDays, Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.metadata = metadata;
        this.retentionDays = retentionDays;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="metadata")
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="retentionDays")
    public Optional<Integer> getRetentionDays() {
        return this.retentionDays;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Project && this.equalTo((Project)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Project other) {
        return this.id.equals(other.id) && this.name.equals(other.name) && this.metadata.equals(other.metadata) && this.retentionDays.equals(other.retentionDays);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.metadata, this.retentionDays);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    NameStage,
    _FinalStage {
        private String id;
        private String name;
        private Optional<Integer> retentionDays = Optional.empty();
        private Map<String, Object> metadata = new LinkedHashMap<String, Object>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Project other) {
            this.id(other.getId());
            this.name(other.getName());
            this.metadata(other.getMetadata());
            this.retentionDays(other.getRetentionDays());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        public _FinalStage retentionDays(Integer retentionDays) {
            this.retentionDays = Optional.ofNullable(retentionDays);
            return this;
        }

        @Override
        @JsonSetter(value="retentionDays", nulls=Nulls.SKIP)
        public _FinalStage retentionDays(Optional<Integer> retentionDays) {
            this.retentionDays = retentionDays;
            return this;
        }

        @Override
        public _FinalStage metadata(String key, Object value) {
            this.metadata.put(key, value);
            return this;
        }

        @Override
        public _FinalStage putAllMetadata(Map<String, Object> metadata) {
            this.metadata.putAll(metadata);
            return this;
        }

        @Override
        @JsonSetter(value="metadata", nulls=Nulls.SKIP)
        public _FinalStage metadata(Map<String, Object> metadata) {
            this.metadata.clear();
            this.metadata.putAll(metadata);
            return this;
        }

        @Override
        public Project build() {
            return new Project(this.id, this.name, this.metadata, this.retentionDays, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Project build();

        public _FinalStage metadata(Map<String, Object> var1);

        public _FinalStage putAllMetadata(Map<String, Object> var1);

        public _FinalStage metadata(String var1, Object var2);

        public _FinalStage retentionDays(Optional<Integer> var1);

        public _FinalStage retentionDays(Integer var1);
    }

    public static interface NameStage {
        public _FinalStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);

        public Builder from(Project var1);
    }
}

