/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.organizations.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.organizations.types.MembershipRole;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class MembershipRequest {
    private final String userId;
    private final MembershipRole role;
    private final Map<String, Object> additionalProperties;

    private MembershipRequest(String userId, MembershipRole role, Map<String, Object> additionalProperties) {
        this.userId = userId;
        this.role = role;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="userId")
    public String getUserId() {
        return this.userId;
    }

    @JsonProperty(value="role")
    public MembershipRole getRole() {
        return this.role;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof MembershipRequest && this.equalTo((MembershipRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(MembershipRequest other) {
        return this.userId.equals(other.userId) && this.role.equals((Object)other.role);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.userId, this.role});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static UserIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements UserIdStage,
    RoleStage,
    _FinalStage {
        private String userId;
        private MembershipRole role;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(MembershipRequest other) {
            this.userId(other.getUserId());
            this.role(other.getRole());
            return this;
        }

        @Override
        @JsonSetter(value="userId")
        public RoleStage userId(@NotNull String userId) {
            this.userId = Objects.requireNonNull(userId, "userId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="role")
        public _FinalStage role(@NotNull MembershipRole role) {
            this.role = Objects.requireNonNull(role, "role must not be null");
            return this;
        }

        @Override
        public MembershipRequest build() {
            return new MembershipRequest(this.userId, this.role, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public MembershipRequest build();
    }

    public static interface RoleStage {
        public _FinalStage role(@NotNull MembershipRole var1);
    }

    public static interface UserIdStage {
        public RoleStage userId(@NotNull String var1);

        public Builder from(MembershipRequest var1);
    }
}

