/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.media.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PatchMediaBody {
    private final OffsetDateTime uploadedAt;
    private final int uploadHttpStatus;
    private final Optional<String> uploadHttpError;
    private final Optional<Integer> uploadTimeMs;
    private final Map<String, Object> additionalProperties;

    private PatchMediaBody(OffsetDateTime uploadedAt, int uploadHttpStatus, Optional<String> uploadHttpError, Optional<Integer> uploadTimeMs, Map<String, Object> additionalProperties) {
        this.uploadedAt = uploadedAt;
        this.uploadHttpStatus = uploadHttpStatus;
        this.uploadHttpError = uploadHttpError;
        this.uploadTimeMs = uploadTimeMs;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="uploadedAt")
    public OffsetDateTime getUploadedAt() {
        return this.uploadedAt;
    }

    @JsonProperty(value="uploadHttpStatus")
    public int getUploadHttpStatus() {
        return this.uploadHttpStatus;
    }

    @JsonProperty(value="uploadHttpError")
    public Optional<String> getUploadHttpError() {
        return this.uploadHttpError;
    }

    @JsonProperty(value="uploadTimeMs")
    public Optional<Integer> getUploadTimeMs() {
        return this.uploadTimeMs;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PatchMediaBody && this.equalTo((PatchMediaBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PatchMediaBody other) {
        return this.uploadedAt.equals(other.uploadedAt) && this.uploadHttpStatus == other.uploadHttpStatus && this.uploadHttpError.equals(other.uploadHttpError) && this.uploadTimeMs.equals(other.uploadTimeMs);
    }

    public int hashCode() {
        return Objects.hash(this.uploadedAt, this.uploadHttpStatus, this.uploadHttpError, this.uploadTimeMs);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static UploadedAtStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements UploadedAtStage,
    UploadHttpStatusStage,
    _FinalStage {
        private OffsetDateTime uploadedAt;
        private int uploadHttpStatus;
        private Optional<Integer> uploadTimeMs = Optional.empty();
        private Optional<String> uploadHttpError = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PatchMediaBody other) {
            this.uploadedAt(other.getUploadedAt());
            this.uploadHttpStatus(other.getUploadHttpStatus());
            this.uploadHttpError(other.getUploadHttpError());
            this.uploadTimeMs(other.getUploadTimeMs());
            return this;
        }

        @Override
        @JsonSetter(value="uploadedAt")
        public UploadHttpStatusStage uploadedAt(@NotNull OffsetDateTime uploadedAt) {
            this.uploadedAt = Objects.requireNonNull(uploadedAt, "uploadedAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="uploadHttpStatus")
        public _FinalStage uploadHttpStatus(int uploadHttpStatus) {
            this.uploadHttpStatus = uploadHttpStatus;
            return this;
        }

        @Override
        public _FinalStage uploadTimeMs(Integer uploadTimeMs) {
            this.uploadTimeMs = Optional.ofNullable(uploadTimeMs);
            return this;
        }

        @Override
        @JsonSetter(value="uploadTimeMs", nulls=Nulls.SKIP)
        public _FinalStage uploadTimeMs(Optional<Integer> uploadTimeMs) {
            this.uploadTimeMs = uploadTimeMs;
            return this;
        }

        @Override
        public _FinalStage uploadHttpError(String uploadHttpError) {
            this.uploadHttpError = Optional.ofNullable(uploadHttpError);
            return this;
        }

        @Override
        @JsonSetter(value="uploadHttpError", nulls=Nulls.SKIP)
        public _FinalStage uploadHttpError(Optional<String> uploadHttpError) {
            this.uploadHttpError = uploadHttpError;
            return this;
        }

        @Override
        public PatchMediaBody build() {
            return new PatchMediaBody(this.uploadedAt, this.uploadHttpStatus, this.uploadHttpError, this.uploadTimeMs, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PatchMediaBody build();

        public _FinalStage uploadHttpError(Optional<String> var1);

        public _FinalStage uploadHttpError(String var1);

        public _FinalStage uploadTimeMs(Optional<Integer> var1);

        public _FinalStage uploadTimeMs(Integer var1);
    }

    public static interface UploadHttpStatusStage {
        public _FinalStage uploadHttpStatus(int var1);
    }

    public static interface UploadedAtStage {
        public UploadHttpStatusStage uploadedAt(@NotNull OffsetDateTime var1);

        public Builder from(PatchMediaBody var1);
    }
}

