/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.media.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.media.types.MediaContentType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetMediaUploadUrlRequest {
    private final String traceId;
    private final Optional<String> observationId;
    private final MediaContentType contentType;
    private final int contentLength;
    private final String sha256Hash;
    private final String field;
    private final Map<String, Object> additionalProperties;

    private GetMediaUploadUrlRequest(String traceId, Optional<String> observationId, MediaContentType contentType, int contentLength, String sha256Hash, String field, Map<String, Object> additionalProperties) {
        this.traceId = traceId;
        this.observationId = observationId;
        this.contentType = contentType;
        this.contentLength = contentLength;
        this.sha256Hash = sha256Hash;
        this.field = field;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="traceId")
    public String getTraceId() {
        return this.traceId;
    }

    @JsonProperty(value="observationId")
    public Optional<String> getObservationId() {
        return this.observationId;
    }

    @JsonProperty(value="contentType")
    public MediaContentType getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="contentLength")
    public int getContentLength() {
        return this.contentLength;
    }

    @JsonProperty(value="sha256Hash")
    public String getSha256Hash() {
        return this.sha256Hash;
    }

    @JsonProperty(value="field")
    public String getField() {
        return this.field;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetMediaUploadUrlRequest && this.equalTo((GetMediaUploadUrlRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetMediaUploadUrlRequest other) {
        return this.traceId.equals(other.traceId) && this.observationId.equals(other.observationId) && this.contentType.equals((Object)other.contentType) && this.contentLength == other.contentLength && this.sha256Hash.equals(other.sha256Hash) && this.field.equals(other.field);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.traceId, this.observationId, this.contentType, this.contentLength, this.sha256Hash, this.field});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TraceIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TraceIdStage,
    ContentTypeStage,
    ContentLengthStage,
    Sha256HashStage,
    FieldStage,
    _FinalStage {
        private String traceId;
        private MediaContentType contentType;
        private int contentLength;
        private String sha256Hash;
        private String field;
        private Optional<String> observationId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(GetMediaUploadUrlRequest other) {
            this.traceId(other.getTraceId());
            this.observationId(other.getObservationId());
            this.contentType(other.getContentType());
            this.contentLength(other.getContentLength());
            this.sha256Hash(other.getSha256Hash());
            this.field(other.getField());
            return this;
        }

        @Override
        @JsonSetter(value="traceId")
        public ContentTypeStage traceId(@NotNull String traceId) {
            this.traceId = Objects.requireNonNull(traceId, "traceId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="contentType")
        public ContentLengthStage contentType(@NotNull MediaContentType contentType) {
            this.contentType = Objects.requireNonNull(contentType, "contentType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="contentLength")
        public Sha256HashStage contentLength(int contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        @Override
        @JsonSetter(value="sha256Hash")
        public FieldStage sha256Hash(@NotNull String sha256Hash) {
            this.sha256Hash = Objects.requireNonNull(sha256Hash, "sha256Hash must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="field")
        public _FinalStage field(@NotNull String field) {
            this.field = Objects.requireNonNull(field, "field must not be null");
            return this;
        }

        @Override
        public _FinalStage observationId(String observationId) {
            this.observationId = Optional.ofNullable(observationId);
            return this;
        }

        @Override
        @JsonSetter(value="observationId", nulls=Nulls.SKIP)
        public _FinalStage observationId(Optional<String> observationId) {
            this.observationId = observationId;
            return this;
        }

        @Override
        public GetMediaUploadUrlRequest build() {
            return new GetMediaUploadUrlRequest(this.traceId, this.observationId, this.contentType, this.contentLength, this.sha256Hash, this.field, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public GetMediaUploadUrlRequest build();

        public _FinalStage observationId(Optional<String> var1);

        public _FinalStage observationId(String var1);
    }

    public static interface FieldStage {
        public _FinalStage field(@NotNull String var1);
    }

    public static interface Sha256HashStage {
        public FieldStage sha256Hash(@NotNull String var1);
    }

    public static interface ContentLengthStage {
        public Sha256HashStage contentLength(int var1);
    }

    public static interface ContentTypeStage {
        public ContentLengthStage contentType(@NotNull MediaContentType var1);
    }

    public static interface TraceIdStage {
        public ContentTypeStage traceId(@NotNull String var1);

        public Builder from(GetMediaUploadUrlRequest var1);
    }
}

