/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.ingestion.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.commons.types.CreateScoreValue;
import com.langfuse.client.resources.commons.types.ScoreDataType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ScoreBody {
    private final Optional<String> id;
    private final Optional<String> traceId;
    private final Optional<String> sessionId;
    private final Optional<String> observationId;
    private final Optional<String> datasetRunId;
    private final String name;
    private final Optional<String> environment;
    private final CreateScoreValue value;
    private final Optional<String> comment;
    private final Optional<Object> metadata;
    private final Optional<ScoreDataType> dataType;
    private final Optional<String> configId;
    private final Map<String, Object> additionalProperties;

    private ScoreBody(Optional<String> id, Optional<String> traceId, Optional<String> sessionId, Optional<String> observationId, Optional<String> datasetRunId, String name, Optional<String> environment, CreateScoreValue value, Optional<String> comment, Optional<Object> metadata, Optional<ScoreDataType> dataType, Optional<String> configId, Map<String, Object> additionalProperties) {
        this.id = id;
        this.traceId = traceId;
        this.sessionId = sessionId;
        this.observationId = observationId;
        this.datasetRunId = datasetRunId;
        this.name = name;
        this.environment = environment;
        this.value = value;
        this.comment = comment;
        this.metadata = metadata;
        this.dataType = dataType;
        this.configId = configId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="traceId")
    public Optional<String> getTraceId() {
        return this.traceId;
    }

    @JsonProperty(value="sessionId")
    public Optional<String> getSessionId() {
        return this.sessionId;
    }

    @JsonProperty(value="observationId")
    public Optional<String> getObservationId() {
        return this.observationId;
    }

    @JsonProperty(value="datasetRunId")
    public Optional<String> getDatasetRunId() {
        return this.datasetRunId;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="environment")
    public Optional<String> getEnvironment() {
        return this.environment;
    }

    @JsonProperty(value="value")
    public CreateScoreValue getValue() {
        return this.value;
    }

    @JsonProperty(value="comment")
    public Optional<String> getComment() {
        return this.comment;
    }

    @JsonProperty(value="metadata")
    public Optional<Object> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="dataType")
    public Optional<ScoreDataType> getDataType() {
        return this.dataType;
    }

    @JsonProperty(value="configId")
    public Optional<String> getConfigId() {
        return this.configId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ScoreBody && this.equalTo((ScoreBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ScoreBody other) {
        return this.id.equals(other.id) && this.traceId.equals(other.traceId) && this.sessionId.equals(other.sessionId) && this.observationId.equals(other.observationId) && this.datasetRunId.equals(other.datasetRunId) && this.name.equals(other.name) && this.environment.equals(other.environment) && this.value.equals(other.value) && this.comment.equals(other.comment) && this.metadata.equals(other.metadata) && this.dataType.equals(other.dataType) && this.configId.equals(other.configId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.traceId, this.sessionId, this.observationId, this.datasetRunId, this.name, this.environment, this.value, this.comment, this.metadata, this.dataType, this.configId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    ValueStage,
    _FinalStage {
        private String name;
        private CreateScoreValue value;
        private Optional<String> configId = Optional.empty();
        private Optional<ScoreDataType> dataType = Optional.empty();
        private Optional<Object> metadata = Optional.empty();
        private Optional<String> comment = Optional.empty();
        private Optional<String> environment = Optional.empty();
        private Optional<String> datasetRunId = Optional.empty();
        private Optional<String> observationId = Optional.empty();
        private Optional<String> sessionId = Optional.empty();
        private Optional<String> traceId = Optional.empty();
        private Optional<String> id = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ScoreBody other) {
            this.id(other.getId());
            this.traceId(other.getTraceId());
            this.sessionId(other.getSessionId());
            this.observationId(other.getObservationId());
            this.datasetRunId(other.getDatasetRunId());
            this.name(other.getName());
            this.environment(other.getEnvironment());
            this.value(other.getValue());
            this.comment(other.getComment());
            this.metadata(other.getMetadata());
            this.dataType(other.getDataType());
            this.configId(other.getConfigId());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public ValueStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="value")
        public _FinalStage value(@NotNull CreateScoreValue value) {
            this.value = Objects.requireNonNull(value, "value must not be null");
            return this;
        }

        @Override
        public _FinalStage configId(String configId) {
            this.configId = Optional.ofNullable(configId);
            return this;
        }

        @Override
        @JsonSetter(value="configId", nulls=Nulls.SKIP)
        public _FinalStage configId(Optional<String> configId) {
            this.configId = configId;
            return this;
        }

        @Override
        public _FinalStage dataType(ScoreDataType dataType) {
            this.dataType = Optional.ofNullable(dataType);
            return this;
        }

        @Override
        @JsonSetter(value="dataType", nulls=Nulls.SKIP)
        public _FinalStage dataType(Optional<ScoreDataType> dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public _FinalStage metadata(Object metadata) {
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        @Override
        @JsonSetter(value="metadata", nulls=Nulls.SKIP)
        public _FinalStage metadata(Optional<Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public _FinalStage comment(String comment) {
            this.comment = Optional.ofNullable(comment);
            return this;
        }

        @Override
        @JsonSetter(value="comment", nulls=Nulls.SKIP)
        public _FinalStage comment(Optional<String> comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public _FinalStage environment(String environment) {
            this.environment = Optional.ofNullable(environment);
            return this;
        }

        @Override
        @JsonSetter(value="environment", nulls=Nulls.SKIP)
        public _FinalStage environment(Optional<String> environment) {
            this.environment = environment;
            return this;
        }

        @Override
        public _FinalStage datasetRunId(String datasetRunId) {
            this.datasetRunId = Optional.ofNullable(datasetRunId);
            return this;
        }

        @Override
        @JsonSetter(value="datasetRunId", nulls=Nulls.SKIP)
        public _FinalStage datasetRunId(Optional<String> datasetRunId) {
            this.datasetRunId = datasetRunId;
            return this;
        }

        @Override
        public _FinalStage observationId(String observationId) {
            this.observationId = Optional.ofNullable(observationId);
            return this;
        }

        @Override
        @JsonSetter(value="observationId", nulls=Nulls.SKIP)
        public _FinalStage observationId(Optional<String> observationId) {
            this.observationId = observationId;
            return this;
        }

        @Override
        public _FinalStage sessionId(String sessionId) {
            this.sessionId = Optional.ofNullable(sessionId);
            return this;
        }

        @Override
        @JsonSetter(value="sessionId", nulls=Nulls.SKIP)
        public _FinalStage sessionId(Optional<String> sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Override
        public _FinalStage traceId(String traceId) {
            this.traceId = Optional.ofNullable(traceId);
            return this;
        }

        @Override
        @JsonSetter(value="traceId", nulls=Nulls.SKIP)
        public _FinalStage traceId(Optional<String> traceId) {
            this.traceId = traceId;
            return this;
        }

        @Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @Override
        public ScoreBody build() {
            return new ScoreBody(this.id, this.traceId, this.sessionId, this.observationId, this.datasetRunId, this.name, this.environment, this.value, this.comment, this.metadata, this.dataType, this.configId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ScoreBody build();

        public _FinalStage id(Optional<String> var1);

        public _FinalStage id(String var1);

        public _FinalStage traceId(Optional<String> var1);

        public _FinalStage traceId(String var1);

        public _FinalStage sessionId(Optional<String> var1);

        public _FinalStage sessionId(String var1);

        public _FinalStage observationId(Optional<String> var1);

        public _FinalStage observationId(String var1);

        public _FinalStage datasetRunId(Optional<String> var1);

        public _FinalStage datasetRunId(String var1);

        public _FinalStage environment(Optional<String> var1);

        public _FinalStage environment(String var1);

        public _FinalStage comment(Optional<String> var1);

        public _FinalStage comment(String var1);

        public _FinalStage metadata(Optional<Object> var1);

        public _FinalStage metadata(Object var1);

        public _FinalStage dataType(Optional<ScoreDataType> var1);

        public _FinalStage dataType(ScoreDataType var1);

        public _FinalStage configId(Optional<String> var1);

        public _FinalStage configId(String var1);
    }

    public static interface ValueStage {
        public _FinalStage value(@NotNull CreateScoreValue var1);
    }

    public static interface NameStage {
        public ValueStage name(@NotNull String var1);

        public Builder from(ScoreBody var1);
    }
}

